disp('Running MATLAB script file SiZerDist1Fig4.m') ;
%
%    For Making Figure 4
%    in the Advanced Distribution Theory for SiZer paper
%
%
%    Came from SiZerSimul1QQ.m 
%
%    Does Analysis of outputs from SiZerSimul1.m
%    which did simulations investigating Simultaneity issues for SiZer
%
%    This focuses on exploring distributions of maximizers
%
%    Only considers Run 4, because simultaneity is not an issue


ipart = 3 ;    %  1 - For overall max data, explore Gaussian Q-Q fit
               %  2 - For overall max data, explore Extreme Value Q-Q fit
               %  3 - For overall max data, explore Power of Abs Gaussian Q-Q fit
               %  11 - Row-wise????

% Uses run 1 of SZ version 2
irun = 1 ;
sz =2;

addpath 'd:\Research\SiZer\simul';

idat = 2; % use only second data file
vidat = [1 2 3] ;    %  index of data type
                     %  1  -  Uniform(0,1) density estimation
                     %  2  -  N(0,1) regression (equally spaced)
                     %  3  -  N(0,1) regression (Uniform(0,1) design)

in = 3; % use only second sample size
vn = [100 400 1600] ;    %  sample sizes
 
iregtdist = 0 ; % use normal approximation

%  These parameters are loaded from data file:
%  nsim = 1000 ;
%  left = 0 ;
%  right = 1 ;
%  nbin = 400 ;
%  hmin = 2 * (right - left) / nbin ;
%      %  usual default
%  hmax = (right - left) ;
%  nh = 11 ;



infilestr = ['SZSim' num2str(sz) 'OutRun' num2str(irun)] ;


if idat == 1 ;
  datstr = 'Uniform(0,1) density estimation' ;
elseif idat == 2 ;
  datstr = 'N(0,1) regression (equally spaced)' ;
elseif idat == 3 ;
  datstr = 'N(0,1) regression (Uniform(0,1) design)' ;
end ;


figure(1) ;
clf ;


%  load simulation output file
%
prestr = 'C:\BigDataJSM\SiZerSimulOutputs\' ;
    % if running on IBM ThinkPad
%prestr = '..\' ;
    % if running at UNC
instr = [prestr infilestr 'Dat' num2str(idat) 'n' num2str(in)] ;
eval(['load ' instr]) ;
disp(['    finished read of ' instr]) ;



titstr = ['Figure 4'] ;
outstr = ['SZsim' num2str(sz) 'QQoutMPGaD' num2str(idat) ...
                                   'n' num2str(in)] ;

paramstruct = struct('idist',5, ...
                     'ishowpar',1, ...
                     'vqalign',[0.5; 0.75], ...
                     'ishowcross',1, ...
                     'vshowq',[0.5; 0.75; 0.9; 0.99], ...
                     'titlestr',titstr, ...
                     'iscreenwrite',1) ;
%        paramstruct = struct('idist',5, ...
%                             'ishowpar',1, ...
%                             'vqalign',[0.8; 0.95], ...
%                             'ishowcross',1, ...
%                             'vshowq',[0.5; 0.75; 0.9; 0.99], ...
%                             'savestr',outstr, ...
%                             'titlestr',titstr, ...
%                             'iscreenwrite',1) ;

qqSM(max(A2dRM,[],2),paramstruct) ;
    %  global max, for each data set


pstr = 'SiZerDist1Fig4' ;

  orient portrait ;
  set(gcf,'PaperSize',[5.0, 5.0]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 4.5, 4.5]) ; 
print('-dpsc', [pstr '.ps']) ;




