disp('Running MATLAB script file SiZerDist1Fig8.m') ;
%
%    For Making Figure 8
%    in the Advanced Distribution Theory for SiZer paper
%
%
%    Copied from: SiZerSimul2power.m via SiZerDist1Fig1.m
%
%    For investigating power (using standard test bed examples)
%    of improved SiZer methods
%
%    Copied from sizerSMtest.m
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION sizerSM,
%    Default version of SiZer,


%vitest = [14] ;
                %  14 ER Wavelet Examples (regression)


%iout = 1 ;    %  1 - 4 panel SiZer plot, Regular, Hsing-R, H-Bonf, H-Global



fighand = figure(1) ;
clf ;

addpath \Research\SiZer\simul


nobs = 1024 ;
xgrid = linspace(1/(2*nobs), 1 - (1/(2*nobs)), nobs)' ;


%idist = 4 ;

tarstr = 'Blocks' ;
pos = [ .1 .13 .15 .23 .25 .40 .44 .65  .76 .78 .81];
hgt = [4 (-5) 3 (-4) 5 (-4.2) 2.1 4.3  (-3.1) 2.1 (-4.2)];
m = 2*ones(size(xgrid));
for j=1:length(pos)
  m = m + (1 + sign(xgrid-pos(j))).*(hgt(j)/2) ;
end
m = (0.6/9.2)*m + 0.2;


isig = 2 ;

if isig == 1 ;
  sigstr = 'Low Noise' ;
  sig = .02 ;
elseif isig == 2 ;
  sigstr = 'High Noise' ;
  sig = .1 ;
end ;

  randn('seed',92394873) ;
ydat = m + sig * randn(nobs,1) ;
data = [xgrid, ydat] ; 


figure(1) ;
clf ;

subplot(4,1,1) ;    %  Regular SiZer 
paramstruct = struct('sizertitle',['Figure 8a'],...
                     'iout',6, ...
                     'nsh',21, ...
                     'imovie',0, ...
                     'ishoweffwind',0, ...
                     'hhighlight',0, ...
                     'iscreenwrite',1) ;

sizerSM(data,paramstruct) ;
ylabel('') ;
set(gca,'XtickLabel',[]) ;


subplot(4,1,2) ;    %  Hsing R SiZer 

disp('        Working on Hsing Row-Wise SiZer') ;
paramstruct = struct('titlestr',['Figure 8b'],...
                     'ibdryadj',0, ...
                     'simflag',2) ;
  %  Note 'ibdryadj',0 is DIFFERENT from the 2 used in sims
  %  simflag is:
  %       1  -  Use old Row-wise Simultaneous C.I.'s
  %       2 (or not specified) - Use Row-wise based on Hsing at al. (1996)
  %       3  -  Use global adjustment (sum independent blocks calculated as in 2)
  %       4  -  Use global adjustment based on Bonferoni and Hsing at al. (1996).

sz2SMsim(data,paramstruct) ;
set(gca,'XtickLabel',[]) ;


subplot(4,1,3) ;    %  H-Bonf SiZer 
disp('        Working on Hsing Bonferroni SiZer') ;
paramstruct = struct('titlestr',['Figure 8c'],...
                     'ibdryadj',0, ...
                     'simflag',4) ;
  %  Note 'ibdryadj',0 is DIFFERENT from the 2 used in sims
  %  simflag is:
  %       4  -  Use global adjustment based on Bonferoni and Hsing at al. (1996).

sz2SMsim(data,paramstruct) ;
set(gca,'XtickLabel',[]) ;


subplot(4,1,4) ;    %  H-GLobal SiZer 
disp('        Working on Hsing Global SiZer') ;
paramstruct = struct('titlestr',['Figure 8d'],...
                     'ibdryadj',0, ...
                     'simflag',3) ;
  %  Note 'ibdryadj',0 is DIFFERENT from the 2 used in sims
  %  simflag is:
  %       3  -  Use global adjustment (sum independent blocks calculated as in 2)

sz2SMsim(data,paramstruct) ;


%paramstruct = struct('famoltitle','Figure 1a', ...
%                     'sizertitle','Figure 1b', ...
%                     'iout',1, ...
%                     'nsh',21, ...
%                     'imovie',0, ...
%                     'ibigdot',1, ...
%                     'ishoweffwind',1, ...
%                     'hhighlight',0, ...
%                     'iscreenwrite',1) ;
%
%sizerSM(data,paramstruct) ;


%subplot(2,1,1) ;
%hold on ;
%
%  plot(xgrid,m,'k-','LineWidth',2) ;
%
%hold off ;



pstr = 'SiZerDist1Fig8' ;

  orient portrait ;
  set(gcf,'PaperSize',[6.0, 6.0]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 5.5]) ; 
print('-dpsc', [pstr '.ps']) ;


