disp('Running MATLAB script file SiZerDist1Fig9.m') ;
%
%    For Making Figure 9
%    in the Advanced Distribution Theory for SiZer paper
%
%
%    Copied from: SiZerSimul2power.m via SiZerDist1Fig8.m
%
%    For investigating power (using standard test bed examples)
%    of improved SiZer methods
%
%    Copied from sizerSMtest.m
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION sizerSM,
%    Default version of SiZer,


%vitest = [2] ;
                %  14 ER Wavelet Examples (regression)


%iout = 1 ;    %  1 - 4 panel SiZer plot, Regular, Hsing-R, H-Bonf, H-Global



fighand = figure(1) ;
clf ;

idist = 9 ;
%idist= 14;

load \Research\GeneralData\nmstuff\nmpar.mat
eval(['parmat = nmpar' num2str(idist) ' ;']) ;

nobs = 10000 ;
%nobs = 1000;

%  Generate psuedo data and do SiZer
%rand('seed',1603703027);
%randn('seed',348735023);
       % use with idist = 14

rand('seed',1512096422);
randn('seed',1130364303);
       %use with idist = 9
      

%rand('seed',2043047520);
%randn('seed',1844898974);

%s1=rand('seed');
%s2=randn('seed');


data = nmdataSM(nobs,parmat) ;


subplot(4,1,1) ;    %  Regular SiZer 
paramstruct = struct('sizertitle',['Figure 9a'],...
                     'iout',6, ...
                     'nsh',21, ...
                     'imovie',0, ...
                     'ishoweffwind',0, ...
                     'hhighlight',0, ...
                     'iscreenwrite',1) ;

sizerSM(data,paramstruct) ;
ylabel('') ;
set(gca,'XtickLabel',[]) ;



subplot(4,1,2) ;    %  Hsing R SiZer 

disp('        Working on Hsing Row-Wise SiZer') ;
paramstruct = struct('titlestr',['Figure 9b'],...
                     'ibdryadj',0, ...
                     'simflag',2) ;
  %  Note 'ibdryadj',0 is DIFFERENT from the 2 used in sims
  %  simflag is:
  %       1  -  Use old Row-wise Simultaneous C.I.'s
  %       2 (or not specified) - Use Row-wise based on Hsing at al. (1996)
  %       3  -  Use global adjustment (sum independent blocks calculated as in 2)
  %       4  -  Use global adjustment based on Bonferoni and Hsing at al. (1996).

sz2SMsim(data,paramstruct) ;
set(gca,'XtickLabel',[]) ;


subplot(4,1,3) ;    %  H-Bonf SiZer 
disp('        Working on Hsing Bonferroni SiZer') ;
paramstruct = struct('titlestr',['Figure 9c'],...
                     'ibdryadj',0, ...
                     'simflag',4) ;
  %  Note 'ibdryadj',0 is DIFFERENT from the 2 used in sims
  %  simflag is:
  %       4  -  Use global adjustment based on Bonferoni and Hsing at al. (1996).

sz2SMsim(data,paramstruct) ;
set(gca,'XtickLabel',[]) ;


subplot(4,1,4) ;    %  H-GLobal SiZer 
disp('        Working on Hsing Global SiZer') ;
paramstruct = struct('titlestr',['Figure 9d'],...
                     'ibdryadj',0, ...
                     'simflag',3) ;
  %  Note 'ibdryadj',0 is DIFFERENT from the 2 used in sims
  %  simflag is:
  %       3  -  Use global adjustment (sum independent blocks calculated as in 2)

sz2SMsim(data,paramstruct) ;


%paramstruct = struct('famoltitle','Figure 1a', ...
%                     'sizertitle','Figure 1b', ...
%                     'iout',1, ...
%                     'nsh',21, ...
%                     'imovie',0, ...
%                     'ibigdot',1, ...
%                     'ishoweffwind',1, ...
%                     'hhighlight',0, ...
%                     'iscreenwrite',1) ;
%
%sizerSM(data,paramstruct) ;


%subplot(2,1,1) ;
%hold on ;
%
%  plot(xgrid,m,'k-','LineWidth',2) ;
%
%hold off ;



pstr = 'SiZerDist1Fig9' ;

  orient portrait ;
  set(gcf,'PaperSize',[6.0, 6.0]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 5.5]) ; 
print('-dpsc', [pstr '.ps']) ;

