function [y]=autocorr(z,hh)
%
% autocorrelation function
% for a column vector z, autocorr(z) returns the autocorrelation function 
% for lag h=0,...,hh
%
% input:
%	- z: column vector of data
%	- hh: maximum lag
%
% output:
%	- y: autocorrelation function

[n,m]=size(z);

mz=mean(z);

zz=z-mz;

ACOV=[];

var=(1/n)*zz'*zz;

for h=0:hh;
  zz0=zz(1:n-h);
  zzh=zz(1+h:n);
  acov=(1/n)*zz0'*zzh;
  ACOV=[ACOV acov];
end;

y=ACOV/var
