function y=autocov(z,hh)
%
% autocovariance function
% for a column vector z, autocov(z) returns the autocovariance function 
% for lag h=0,...,hh
%

[n,m]=size(z);

mz=mean(z);

zz=z-mz;

ACOV=[];

for h=0:hh;
  zz0=zz(1:n-h);
  zzh=zz(1+h:n);
  acov=(1/n)*zz0'*zzh;
  ACOV=[ACOV acov];
end;

y=ACOV;
