disp('Running MATLAB script file sizerdepSMtest.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION sizerdepSM,
%    Dependent data version of SiZer,


itest = 155 ;    %
               %  1 - test for iid data, iid autocorr
               %  2 - test for iid data, strong autocorr
               %
               %  101,...,112, simple parameter tests
               %  121,122,123,124,125,126,127,128  MA(1) tests
               %  131,132,133,134,135,136,137,138  AR(1) tests
               %  141,142,143,144  MA(10) tests
               %  151,152,153,154,155,156   sine curve with MA(1) tests
               %  161,162,163,164,165,166   sine curve with AR(1) tests
               %  171,172   sine curve with MA(10) tests


figure(1) ;
clf ;


if itest == 1 ;

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = [1; zeros(n-1,1)] ;


  sizerdepSM(indat,autocov) ;


elseif itest == 2 ;

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = 0.9.^(0:(n-1))' ;


  sizerdepSM(indat,autocov) ;


elseif itest == 101 ;

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = [1; zeros(n-1,1)] ;


  paramstruct = struct('imovie',1) ;

  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 102 ;

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = [1; zeros(n-1,1)] ;


  paramstruct = struct('icolor',0) ;

  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 103 ;

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = [1; zeros(n-1,1)] ;


  paramstruct = struct('xlabelstr','Test X axis', ...
                       'ylabelstr','Test y axis', ...
                       'labelfontsize',18) ;

  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 104 ;

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = [1; zeros(n-1,1)] ;


  paramstruct = struct('famoltitle','Test Family Title', ...
                       'sizertitle','Test SiZer Title', ...
                       'titlefontsize',18) ;

  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 105 ;

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = [1; zeros(n-1,1)] ;


  paramstruct = struct('ndataoverlay',100, ...
                       'dolcolor','r', ...
                       'ibigdot',1) ;

  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 106 ;    %  note these are ignored in current version

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = [1; zeros(n-1,1)] ;


  paramstruct = struct('nbin',40, ...
                       'minx',300, ...
                       'maxx',700) ;

  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 107 ;    %  note these are ignored in current version

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = [1; zeros(n-1,1)] ;


  paramstruct = struct('nbin',40, ...
                       'minx',300, ...
                       'maxx',700, ...
                       'bpar',1) ;

  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 108 ;    %  First benchmark against conventional SiZer

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle','3 Cycle Sin, iid noise', ...
                       'sizertitle','Benchmark with usual SiZer', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;

  sizerSM([(1:n)', indat],paramstruct) ;


elseif itest == 109 ;    %  now try corresponding dependent version

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = [1; zeros(n-1,1)] ;

  paramstruct = struct('famoltitle','3 Cycle Sin, iid noise', ...
                       'sizertitle','Indep. autocov., var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;

  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 110 ;

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = [0.25; zeros(n-1,1)] ;

  paramstruct = struct('famoltitle','3 Cycle Sin, iid noise', ...
                       'sizertitle','Indep. autocov., var = 0.25', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;

  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 111 ;

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = [4; zeros(n-1,1)] ;

  paramstruct = struct('famoltitle','3 Cycle Sin, iid noise', ...
                       'sizertitle','Indep. autocov., var = 4', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;

  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 112 ;

  n = 400 ;
  randn('state',94832750918) ;

  indat = sin(3 * 2 * pi * [1:n]' / n) + randn(n,1) ;

  autocov = [16; zeros(n-1,1)] ;

  paramstruct = struct('famoltitle','3 Cycle Sin, iid noise', ...
                       'sizertitle','Indep. autocov., var = 16', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;

  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 121 ;    % Generate MA(1) process and use regular SiZer
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.5] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle','MA(1), theta=0.5', ...
                       'sizertitle','Benchmark with usual SiZer', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerSM([(1:n)', indat],paramstruct) ;


elseif itest == 122 ;    % Generate MA(1) process (medium coeff.) and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.5] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = [sum(C.*C); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['MA(1), theta='num2str(C(2))], ...
                       'sizertitle','Indep. autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 123 ;    % Generate MA(1) process (medium coeff.) and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.5] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = [sum(C.*C); C(2); zeros(n-2,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['MA(1), theta='num2str(C(2))], ...
                       'sizertitle','True autocov. error var=1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 124 ;    % Generate MA(1) process (medium coeff.) and test with fatter cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.5] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = [sum(C.*C)*4; C(2)*4; zeros(n-2,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['MA(1), theta='num2str(C(2))], ...
                       'sizertitle','True autocov. error var=4', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;
  
  
elseif itest == 125 ;    % Generate MA(1) process (small coeff.) and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = [sum(C.*C); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['MA(1), theta='num2str(C(2))], ...
                       'sizertitle','Indep. autocov. error var=1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 126 ;    % Generate MA(1) process (small coeff.) and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = [sum(C.*C); C(2); zeros(n-2,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['MA(1), theta='num2str(C(2))], ...
                       'sizertitle','True autocov. error var=1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;
  
  
elseif itest == 127 ;    % Generate MA(1) process (big coeff.) and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.9] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = [sum(C.*C); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['MA(1), theta='num2str(C(2))], ...
                       'sizertitle','Indep. autocov. error var=1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 128 ;    % Generate MA(1) process (big coeff.) and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.9] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = [sum(C.*C); C(2); zeros(n-2,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['MA(1), theta='num2str(C(2))], ...
                       'sizertitle','True autocov. error var=1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;
  
  
elseif itest == 131 ;    % Generate AR(1) process (medium coeff.) and use regular SiZer

  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1, -0.5] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['AR(1), phi='num2str(A(2))], ...
                       'sizertitle','Benchmark with usual SiZer', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerSM([(1:n)', indat],paramstruct) ;
  

elseif itest == 132 ;    % Generate AR(1) process (medium coeff.) and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A =[1, -0.5] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = [1/(1-A(2)^2); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['AR(1), phi='num2str(A(2))], ...
                       'sizertitle','Indep. autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;

  
elseif itest == 133 ;    % Generate AR(1) process (medium coeff.) and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1, -0.5] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  clear autocov ;
  autocov(1) = 1/(1-A(2)^2) ;
  for i= 2:n ;
      autocov(i) = -A(2)*autocov(i-1) ;
  end;
  autocov = autocov' ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['AR(1), phi='num2str(A(2))], ...
                       'sizertitle','True autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 134 ;    % Generate AR(1) process (medium coeff.) and test with fatter cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1, -0.5] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  clear autocov ;
  autocov(1) = 1/(1-A(2)^2) ;
  for i= 2:n ;
      autocov(i) = -A(2)*autocov(i-1) ;
  end;
  autocov = 4*autocov' ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['AR(1), phi='num2str(A(2))], ...
                       'sizertitle','True autocov., error var = 4', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;
  
  

elseif itest == 135 ;    % Generate AR(1) process (small coeff.) and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A =[1, -0.1] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = [1/(1-A(2)^2); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['AR(1), phi='num2str(A(2))], ...
                       'sizertitle','Indep. autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;

  
elseif itest == 136 ;    % Generate AR(1) process (small coeff.) and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1, -0.1] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  clear autocov ;
  autocov(1) = 1/(1-A(2)^2) ;
  for i= 2:n ;
      autocov(i) = -A(2)*autocov(i-1) ;
  end;
  autocov = autocov' ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['AR(1), phi='num2str(A(2))], ...
                       'sizertitle','True autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;
  
  
  
elseif itest == 137 ;    % Generate AR(1) process (big coeff.) and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A =[1, -0.9] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = [1/(1-A(2)^2); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['AR(1), phi='num2str(A(2))], ...
                       'sizertitle','Indep. autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;

  
elseif itest == 138 ;    % Generate AR(1) process (big coeff.) and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1, -0.9] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  clear autocov ;
  autocov(1) = 1/(1-A(2)^2) ;
  for i= 2:n ;
      autocov(i) = -A(2)*autocov(i-1) ;
  end;
  autocov = autocov' ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['AR(1), phi='num2str(A(2))], ...
                       'sizertitle','True autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;  
  
  
elseif itest == 141 ;    % Generate MA(10) process and use regular SiZer

  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.9, 0.8, 0.7, 0.6, 0.5, 0.5, 0.4, 0.3, 0.2, 0.1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle','MA(10)', ...
                       'sizertitle','Benchmark with usual SiZer', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerSM([(1:n)', indat],paramstruct) ;

elseif itest == 142 ;    % Generate MA(10) process and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.9, 0.8, 0.7, 0.6, 0.5, 0.5, 0.4, 0.3, 0.2, 0.1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = [sum(C.*C); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle','MA(10)', ...
                       'sizertitle','Indep. autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 143 ;    % Generate MA(10) process and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.9, 0.8, 0.7, 0.6, 0.5, 0.5, 0.4, 0.3, 0.2, 0.1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = zeros(n,1) ;
  autocov(1) = sum(C.*C) ;
  for i = 2:11;
      for j = 1:12-i ;
          autocov(i) = autocov(i) + C(j)*C(j+i-1) ;
      end;
  end;

  paramstruct = struct('imovie',0, ...
                       'famoltitle','MA(10)', ...
                       'sizertitle','True autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 144 ;    % Generate MA(10) process and test with fatter cov 

    n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.9, 0.8, 0.7, 0.6, 0.5, 0.5, 0.4, 0.3, 0.2, 0.1] ;
  x = randn(n,1) ;
  
  indat = filter(C,A,x) ;
  
  autocov = zeros(n,1) ;
  autocov(1) = sum(C.*C) ;
  for i = 2:11;
      for j = 1:12-i ;
          autocov(i) = autocov(i) + C(j)*C(j+i-1) ;
      end;
  end;
  autocov = 4*autocov ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle','MA(10)', ...
                       'sizertitle','True autocov., error var = 4', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;

  

elseif itest == 151 ;    % Generate sine curve with MA(1) process (small coeff.) and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.1] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  autocov = [sum(C.*C); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['3 Cycle Sin with MA(1), theta='num2str(C(2))], ...
                       'sizertitle','Indep. autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 152 ;    % Generate sine curve with MA(1) process (small coeff.) and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.1] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  autocov = [sum(C.*C); C(2); zeros(n-2,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['3 Cycle Sin with MA(1), theta='num2str(C(2))], ...
                       'sizertitle','True autocov. error var=1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 153 ;    % Generate sine curve with MA(1) process (medium coeff.) and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.5] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  autocov = [sum(C.*C); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['3 Cycle Sin with MA(1), theta='num2str(C(2))], ...
                       'sizertitle','Indep. autocov. error var=1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 154 ;    % Generate sine curve with MA(1) process (medium coeff.) and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.5] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  autocov = [sum(C.*C); C(2); zeros(n-2,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['3 Cycle Sin with MA(1), theta='num2str(C(2))], ...
                       'sizertitle','True autocov. error var=1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;
  
  
elseif itest == 155 ;    % Generate sine curve with MA(1) process (big coeff.) and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.9] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  autocov = [sum(C.*C); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['3 Cycle Sin with MA(1), theta='num2str(C(2))], ...
                       'sizertitle','Indep. autocov. error var=1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 156 ;    % Generate sine curve with MA(1) process (big coeff.) and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.9] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  autocov = [sum(C.*C); C(2); zeros(n-2,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['3 Cycle Sin with MA(1), theta='num2str(C(2))], ...
                       'sizertitle','True autocov. error var=1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;
  
  
elseif itest == 161 ;    % Generate sine curve with AR(1) process (small coeff.) and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A =[1, -0.1] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  autocov = [1/(1-A(2)^2); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['3 Cycle Sin with AR(1), phi='num2str(A(2))], ...
                       'sizertitle','Indep. autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;

  
elseif itest == 162 ;    % Generate sine curve with AR(1) process (small coeff.) and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1, -0.1] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  clear autocov ;
  autocov(1) = 1/(1-A(2)^2) ;
  for i= 2:n ;
      autocov(i) = -A(2)*autocov(i-1) ;
  end;
  autocov = autocov' ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['3 Cycle Sin with AR(1), phi='num2str(A(2))], ...
                       'sizertitle','True autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 163 ;    % Generate sine curve with AR(1) process (medium coeff.) and test with fatter cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1, -0.5] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  autocov = [1/(1-A(2)^2); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['3 Cycle Sin with AR(1), phi='num2str(A(2))], ...
                       'sizertitle','Indep. autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;

  
elseif itest == 164 ;    % Generate sine curve with AR(1) process (medium coeff.) and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1, -0.5] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  clear autocov ;
  autocov(1) = 1/(1-A(2)^2) ;
  for i= 2:n ;
      autocov(i) = -A(2)*autocov(i-1) ;
  end;
  autocov = autocov' ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['3 Cycle Sin with AR(1), phi='num2str(A(2))], ...
                       'sizertitle','True autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;
  
  
elseif itest == 165 ;    % Generate sine curve with AR(1) process (big coeff.) and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A =[1, -0.9] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  autocov = [1/(1-A(2)^2); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['3 Cycle Sin with AR(1), phi='num2str(A(2))], ...
                       'sizertitle','Indep. autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;

  
elseif itest == 166 ;    % Generate sine curve with AR(1) process (big coeff.) and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1, -0.9] ;
  C = [1] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  clear autocov ;
  autocov(1) = 1/(1-A(2)^2) ;
  for i= 2:n ;
      autocov(i) = -A(2)*autocov(i-1) ;
  end;
  autocov = autocov' ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle',['3 Cycle Sin with AR(1), phi='num2str(A(2))], ...
                       'sizertitle','True autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;  
  
  
elseif itest == 171 ;    % Generate sine curve with MA(10) process and test with iid cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.9, 0.8, 0.7, 0.6, 0.5, 0.5, 0.4, 0.3, 0.2, 0.1] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  autocov = [sum(C.*C); zeros(n-1,1)] ;

  paramstruct = struct('imovie',0, ...
                       'famoltitle','3 Cycle Sin with MA(10)', ...
                       'sizertitle','Indep. autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


elseif itest == 172 ;    % Generate sine curve with MA(10) process and test with true cov 
    
  n = 400 ;
  randn('state',94832750918) ;
  
  A = [1] ;
  C = [1, 0.9, 0.8, 0.7, 0.6, 0.5, 0.5, 0.4, 0.3, 0.2, 0.1] ;
  x = randn(n,1) ;
  
  indat = sin(3 * 2 * pi * [1:n]' / n) + filter(C,A,x) ;
  
  autocov = zeros(n,1) ;
  autocov(1) = sum(C.*C) ;
  for i = 2:11;
      for j = 1:12-i ;
          autocov(i) = autocov(i) + C(j)*C(j+i-1) ;
      end;
  end;

  paramstruct = struct('imovie',0, ...
                       'famoltitle','3 Cycle Sin with MA(10)', ...
                       'sizertitle','True autocov., error var = 1', ...
                       'titlefontsize',18, ...
                       'savestr',['Test' num2str(itest) 'Output']) ;
                   
  sizerdepSM(indat,autocov,paramstruct) ;


end ;


