function jo = Checkjo(cjo,clo);

% checks whether jo is large enough for this filter and
% sets jo to smallest allowable value if jo was entered 
% as -1.  Important because later functions use jo!
% input:
%	cjo	jo that was entered by user
%	clo	lo-pass filter -- need to know length
% output:
%	jo	appropriate value of jo (or an error)
%

nfil = length(clo);		% length of filter

if cjo == -1;
  jo = ceil(log2(nfil))-1;
elseif 2^(cjo+1) < nfil;
  error('jo too small for this filter')
else 
  jo = cjo;
end;
