function DWTshifts = DWTshifts(f,mcoefs);

% find all of the discrete wavelet transforms from
% coefficients generated by the stationary wavelet transform
% input:
%	f	new avgs, lo-pass filtered values (1 column)
%	mcoefs	differences, all hi-pass filtered values
% output:
%	DWTshifts	matrix, each column is a different
%			discrete wavelet transform
% Note: function also calculates and saves the appropriately
%	shifted mcoefs in smc -- sometimes useful for debugging
 

[n,s] = size(mcoefs);
je = log2(n);

nshifts = pow2(s);
nrows = nshifts;
ncols = pow2(je-s);

dwts = reshape(f,nrows,ncols);
m = zeros(size(mcoefs));

for i = 1:s ;
  base = (pow2(s-i)) - 1 ;
  m(:,i) = upshift(mcoefs(:,i),base);

  rm = reshape(m(:,i),nrows,ncols);
  rms = rm ;

  nreps = (nshifts/nrows)-1;
  for ireps = 1:nreps ;
    rms = [rms; rm];
  end;

  dwts = [dwts rms];
  ncols = ncols*2;
  nrows = nrows/2;
end;

smc = m ;			% smc contains the shifted mcoefs
				% occasionally useful for debugging
DWTshifts = dwts';
