function dec = DecimateOrder(ndwts,ntimes);

% generates a matrix with the first row corresponding to the first
% dwt generated by DWTshifts, the second row with the second dwt,...
% a row is composed of 0's and 1's which tell the type of 
% decimation that occurred at each stage   0 = even, 1 = odd  
% -- this is important info for reconstruction
% input:
%	ndwts		# of dwts
% 	ntimes  	# of times decimation occurred
% output:
%	dec 	decimation matrix
 
dec = zeros(ndwts,ntimes);

for j = 0:(ntimes-1) ;
  k = pow2(j) ;
  unit = [zeros(k,1); ones(k,1)];
  reps = ndwts/(2*k);

  deccol = [ ];
  for ireps = 1:reps
    deccol = [deccol; unit];
  end;

  dec(:,(j+1)) = deccol;
end;
