function [mcoeffs,fcoeffs] = swtd(clo,y,jo)

% does "decomposition step" for a shifted wavelet transform
% (i.e. no decimation)
% y is vector of y values, where the number of entries is 
% assumed to be a power of 2 -- i.e. data will be treated 
% as periodic  (for a simple boundary adjustment, augment 
% the data by reflecting half at each end, and applying
% function to the resulting 2n vector)
% input:
%  clo = vector containing the lo-pass coeffs -- found with
%	  MakeFilter.m
%    y = vector of y values
%   jo = row number of lowest frequency "difs" if this were a 
%	standard wavelet transform.
%	(i.e. "hi pass filtered values" or "discrepancies")
% output:  two matrices -- one containing the non-decimated mother 
%		coeffs. and one containing the non-decimated
% 		father coeffs.

n = length(y);
je = nextpow2(n);
nfil = length(clo);		% length of filter


% Check -- is y vector a power of 2?

if (2^je - n) ~= 0
  error('Cannot evaluate -- Y vector is not a power of 2.')
end;


% Check -- is jo large enough?   

if jo == -1;
  jou = ceil(log2(nfil))-1;
elseif 2^(jo+1) < nfil;
  error('jo too small for this filter')
else jou = jo;
end;


% Want to make convolution work like a filter -- must reverse order
% of rows and chop off the first and last elements of the result of
% the convolution


% Find hi-pass filter
chi = -( (-1).^(1:length(clo)) ).*clo;
clo = clo(:);
clo = flipud(clo);		


% initializations
mi = [ ];
fi = [ ];
oldavg = y';
j = je - 1;


% loop through levels -- taking out highest freq. first

while j >= jou;

  % pad out to get periodicity -- pre and post padding
  nko = length(oldavg);
  oapre = [oldavg((nko-nfil+2):nko) oldavg oldavg(1)];
  oapost = [oldavg oldavg(1:nfil)];

  % filter
  avg = filter(clo,1,oapost);
  avg = avg(nfil:(nko+nfil-1));

  dif = filter(chi,1,oapre);
  dif = dif((nfil+1):(nko+nfil));

  % save coeffs (no decimation) for each level of j
  mi = [dif' mi];
  fi = [avg' fi];  

  % update for next pass
  oldavg = avg;
  clo = ZeroInsert(clo);
  chi = ZeroInsert(chi);
  nfil = length(clo);
  j = j-1 ;
end;

mcoeffs = mi;
fcoeffs = fi;


