function cbig = HiLiteDWT(n,p,dwt,ndwt,thresh,c);

% hi-lites the line corresponding to the chosen DWT in color "c"
% on the Log(Squared Coeffs) plot and draws a vertical line
% at the chosen location on the Cumulative Squared Coefs plot

% Locate on Cumulative Squared Coefs plot
figure(4);
subplot(1,1,1);
hold on;
vline(ndwt,[0 1],c);
hold off;


% Locate on Log(Squared Coeffs) plot
x = 1:p;
dwt = dwt(:);
dwtc2 = dwt.^2;
dwtc2 = flipud(sort(dwtc2));

figure(3);
subplot(1,1,1);
hold on;
plot(x,log2(dwtc2(1:p)),c);
hold off;


