function f = MConnectDWT(n,ndwt,mcoefs,fcoefs,nj);

% draws vertical lines at the coeffs of a particular DWT (selected by
% mouse or keyboard) on all levels of mcoefs and fcoefs -- takes into 
% account the shifting mcoefs on the plots


gap = pow2(nj:-1:1) ;			% decimation gap for each level
first = rem(ndwt,gap) ;			% location of first coef at
					% each level (if no shifting)

base = pow2((nj-1):-1:0) - 1 ;		% shifting of mcoefs in graph
mfirst = rem((first+base),gap);

nrp = floor(nj/2) + 1 ;			% # of rows of subplots per page
tnp = 2*nj + 1 ;			% total # of coef subplots
tnp1 = 2*nrp ;				% # of coef subplots on figure 1
tnp2 = tnp - tnp1 ;			% # of coef subplots on figure 2

i = 0 ;
t = '-';
for iplot = tnp: -2: 3 ;

  % find locations of vertical lines
  i = i + 1 ;

  % change 0's to gap's 
  if first(i) == 0;
    first(i) = gap(i);
  end;

  if mfirst(i) == 0;
    mfirst(i) = gap(i);
  end;

  xfc = first(i):gap(i):n;
  fc = fcoefs(:,i);
  xmc = mfirst(i): gap(i): n;
  mc = mcoefs(:,i);


  % draw vertical lines

  if iplot > (tnp1 + 1)
    nplot = iplot - tnp1 ;
    figure(2);

    % father coefs
    subplot(nrp,2,nplot);
    repVline(xfc,fc,t);

    % mother coefs
    subplot(nrp,2,nplot-1);
    repVline(xmc,mc,t);

  elseif iplot == (tnp1 + 1)
    figure(2);
    
    % father coefs
    subplot(nrp,2,1);
    repVline(xfc,fc,t);

    % mother coefs
    figure(1);
    subplot(nrp,2,tnp1);
    repVline(xmc,mc,t);

  else

    % father coefs
    subplot(nrp,2,iplot);
    repVline(xfc,fc,t);

    % mother coefs
    subplot(nrp,2,iplot-1);
    repVline(xmc,mc,t);

  end;		% if
end;		% for

  
