function f = MakeFilter(Type)

% Generate orthonormal filter for wavelet transform -- 
% Input:
%	Type   string --  'H1' for Haar, 'D4' for Daub4, or 
%				'S8' for Symmlet8
% Output:  
%	f = orthonormal filter (lo-pass coeffs)
%

f = 0;

if strcmp(Type,'H1'),
	f = [1 1];
elseif  Type(1) == 'D';
   if Type(2) == '4'
	f = [0.482962913145   0.836516303738 ...
	     0.224143868042  -0.129409522551];
   end;
elseif  Type(1) == 'S';
   if Type(2) == '8';
	f = [0.002672793393 -0.000428394300 -0.021145686528 ...
	     0.005386388754  0.069490465911 -0.038493521263 ...
	    -0.073462508761  0.515398670374  1.099106630537 ...
	     0.680745347190 -0.086653615406 -0.202648655286 ...
	     0.010758611751  0.044823623042 -0.000766690896 ...
	    -0.004783458512 ];
   end;
end;

if f == 0; 
  error('Not a valid filter type');
else
  f = f ./norm(f);
end;


