function [nbest,nworst] = SCompYhats(DWTs,nbig)

% reconstructs the transforms which have the fewest and the
% most coeffs larger than the hard threshold

% Find "best" and "worst" basis according to DWT coeff^2 plot
a = max(nbig);
b = min(nbig);

biggest = find(nbig == a);
nworst = biggest(:);
smallest = find(nbig == b);
nbest = smallest(:);

descDWTs = flipud(sort(abs(DWTs)));

if a == 0;
  nworst = length(nbig);
elseif size(nworst,1) > 1
  nworst = find(descDWTs(a,:) == max(descDWTs(a,:)));
  nworst = nworst(1);
end;

if b == 512;
  nbest = length(nbig);
elseif size(nbest,1) > 1
  small = find(descDWTs(b+1,nbest) == min(descDWTs(b+1,nbest)));
  nbest = nbest(small(1));
end;


