function f = SpCumSc2(n,DWTs,mcoefs,Targ,wvstr,tarstr);

% plots sum of first set of coefs^2 (vs position) followed by
% line of sum of first set of coefs^2 + second set of coefs^2
%  ... in all cases, the sum is divided by the sum of the 
% target fn. coefs^2  

% find # of coefs in smallest jo level of transform
% e.g. two coefs came from M3

s = size(mcoefs,2);
je = log2(n);
nc = 2^(je-s);
nshifts = size(DWTs,2);

Sc2Targ = sum(Targ.^2);		% squared coefs of original data
DWTs2 = DWTs.^2;
DWTs2 = [zeros(1,nshifts); DWTs2];
Lsums = zeros(s+1,nshifts);

Lsums(1,:) = sum(DWTs2(1:nc+1,:));
Lsums(2,:) = sum(DWTs2([1 (nc+2):(2*nc+1)],:));

for i = 2:s
  nc = 2*nc;
  Lsums(i+1,:) = sum(DWTs2((nc+2:2*nc+1),:));
end;

CumSc2 = cumsum(Lsums)/Sc2Targ;


x = 1:nshifts;
linetypes = ['ymcgbwymcg'];

figure(4);
clf;

subplot(1,1,1);
axis([1 nshifts min(CumSc2(1,:))-0.01  1]);
hold on;

if s < 4
  nlines = s+1 ;
else
  nlines = 7 ;
end;

for iline = 1:nlines;
  lt = linetypes(iline);
  plot(x,CumSc2(iline,:),lt);
end;

hold off;

xlabel('Regular DWT');
ylabel('F1^2,  F1^2 + M1^2, ...');

figname = ['Wavelets = ',wvstr,':  ',tarstr];
figlabel(figname);


