function [nbig,p] = SpDWTc2(DWTs,thresh,wvstr,tarstr,sigstr);

% plots the squared coefs of each of the n DWTs on one plot -- 
% also will calculate the # of coefs greater than a threshold 
% value when noise is added 

figure(3);
clf reset;

[n,nshifts] = size(DWTs);

DWTc2 = DWTs.^2 ;
DWTc2 = flipud(sort(DWTc2));

nbig = sum(DWTc2 > (thresh^2));
p = max(nbig) + 50 
if p > n
  p = n;
end;
x = [1 p] ; 


subplot(1,1,1);
hold on;

for ishift = 1:nshifts;
  plot(log2(DWTc2([1:p],ishift)));
end;

% Denoising threshold value:
lamsig = (thresh)^2;
hline(x,log2(lamsig),'--');

hold off;

xlabel('Sorted');
ylabel('Log2(Squared Coeffs)');

figname = ['Wavelets = ',wvstr,', Target Fn. = ',tarstr];
figlabel(figname);					 
  
