function f = SpRlargeC(dwt,dec,ndwt,thresh,clo,jo,c)

% threshholds, reconstructs, and plots the resulting yhat 
% based on the large coeffs, i.e. normal reconstruction 
% input:
%	dwt	dwt to reconstruct
%	dec	order of decimation matrix
%	ndwt	# of the dwt (in the DWTs matrix)
% 	thresh	threshold value
%	clo	lo-pass filter coeffs
%	jo	controls the number of passes
%	c	color in which to plot (string)
% output:
%	subplot of the reconstructed vector
%

% Find the order of decimation for "yhat"
cdec = dec(ndwt,:);

% Thresholding
n = length(dwt);
tcb = dwt((pow2(jo)+1):n) ;
tcb = tcb .* (abs(tcb) > thresh); 
dwt((pow2(jo)+1):n) = tcb ;

% Reconstruction
yhat = Rdwt(dwt,clo,jo,cdec);

% Plot the reconstruction
figure(5);
subplot(2,1,1);
hold on;
plot(yhat,c);
hold off;

