function f = SpRsmallC(dwt,dec,ndwt,thresh,clo,jo,c)

% threshholds, reconstructs, and plots the resulting yhat 
% based on the small coeffs, i.e. normal reconstruction 
% input:
%	dwt	dwt to reconstruct
%	dec	order of decimation matrix
%	ndwt	# of the dwt (in the DWTs matrix)
% 	thresh	threshold value
%	clo	lo-pass filter coeffs
%	jo	controls the number of passes
%	c	color in which to plot (string)
% output:
%	subplot of the reconstructed vector
%

% Find the order of decimation for "yhat"
cdec = dec(ndwt,:);

% Thresholding
Tdwt = dwt .* (abs(dwt) <= thresh);

% Reconstruction
yhatS = Rdwt(Tdwt,clo,jo,cdec);

figure(5);
subplot(2,1,2);
hold on;
plot(yhatS,c);
hold off;


