function SpWvCoefs(autop,Y,mcoefs,fcoefs,datastr,wvstr);

% plot the original data and the resulting coeffs (not decimated)
% from scale j = 2^(n-1) at top down to scale jo -- 
% two columns on a page with mcoeffs in right column and 
% fcoeffs in left column
%
% passed variables:
%	autop   flag, = 1 then print graphs
%	n	sample size = # of grid pts.
%			must be a power of 2
%	mcoefs  mother coeffs
%	fcoefs  father coeffs
%	datastr  string identifying the target function
%	wvstr	string identifying which wavelets were used
% outputs:
%	graphs and possibly files containing the graphs
%


figure(1);		% clear figure window and
clf;			% set to start with figure 1

n = length(Y);
nj = size(fcoefs,2);	% # of columns of coeffs of interest
nrp = floor(nj/2) + 1;	% # of rows of subplots per page
jp = nj - nrp + 1;	% plotting flag


subplot(nrp,2,1);	% plot original data
t = 1:length(Y);
plot(t,Y);
ylabel(['Target']);
axis([0 (n+2) min(Y)-10 max(Y)+10]);


% plot mother and father coefs

jplot = 2;		% subplot location
je = log2(n);		% labeling flag for coeffs

for iplot = nj:-1:1;	
  fi = fcoefs(:,iplot);
  mi = mcoefs(:,iplot);
  je = je - 1 ;

  if iplot > jp;
       
    subplot(nrp,2,jplot);
    p = plot(t,mi);
    axis([0 (n+2) min(mi)-10 max(mi)+10]);
    ylabel(['M',int2str(je)]);

    subplot(nrp,2,jplot+1);
    q = plot(t,fi);
    axis([0 (n+2) min(fi)-10 max(fi)+10]);
    ylabel(['F',int2str(je)]);


  elseif iplot == jp;
    
    subplot(nrp,2,jplot);
    p = plot(t,mi);
    axis([0 (n+2) min(mi)-10 max(mi)+10]);
    ylabel(['M',int2str(je)]);

    figure(2);
    clf;
    jplot = 1;
    subplot(nrp,2,jplot);
    plot(t,fi);
    axis([0 (n+2) min(fi)-10 max(fi)+10]);
    ylabel(['F',int2str(je)]);

    jplot = jplot - 1;

  else

    figure(2);
    subplot(nrp,2,jplot);
    plot(t,mi);
    axis([0 (n+2) min(mi)-10 max(mi)+10]);
    ylabel(['M',int2str(je)]);

    subplot(nrp,2,jplot+1);
    plot(t,fi);
    axis([0 (n+2) min(fi)-10 max(fi)+10]);
    ylabel(['F',int2str(je)]);

  end;  			% if

  jplot = jplot + 2;
end;				% for


% label graphs and print to file if requested

file = [wvstr,datastr([5:8])];
figname = ['Wavelets = ',wvstr,', Data = ',datastr];

figure(1);
figlabel(figname); 
ifprint(1,file,autop,0);

figure(2);
figlabel(figname);
ifprint(2,file,autop,1);

