function f = SpYhats(n,best,worst,yhat,nj);

% plots Yhats -- the best, worst, (according to CompareYhats.m) 
% and chosen reconstructed vectors on the same plot as the Coefs 
% but in the last subplot
% input:
%	n	length of data vector
%	best	best reconstruction
%	worst 	worst reconstruction
% 	yhat	reconstructed vector
%	nj 	# of levels of coefs of interest
% output:
%	subplot of the reconstructed vectors
%

nrp = floor(nj/2) + 1 ;		% # of rows of subplots per page
tnp = 2*nj + 1 ;		% total # of coef subplots
tnp1 = 2*nrp ;			% # of coef subplots on figure 1
tnp2 = tnp - tnp1 ;		% # of coef subplots on figure 2

figure(2);
subplot(nrp,2,tnp2+1);
cla;
allhats = [best worst yhat];
axis([0 (n+2)  min(min(allhats))-10  max(max(allhats))+10]);
set(gca,'Box','on');

hold on;
plot(worst,'b');
plot(best,'g');
plot(yhat,'r');
ylabel('Reconstructions');
hold off;


