function [flag,thresh] = ThreshSize(bthresh,Tmult)

% allows the user to select a multiple of the DJ threshold 
% for study and sets a flag which controls whether to continue 
% to the next data set

flag = 0;

disp('Choose a multiple of the DJ threshold to study.');
disp('Any positive number is acceptable, default = 1,');
disp(' 0 = quit this data set. ');
Tmult = input(' --> ');
disp('		');

if Tmult == 0;
  flag = 1;
  return;
elseif length(Tmult) == 0
  Tmult = 1;
end;

thresh = bthresh*Tmult;
