function [button,ndwt,dwt] = chooseDWT(jo,n,DWTs)

% requests and accepts a mouse selection of the discrete wavelet
% transform which one would like to see located on the plots

disp('Which DWT is of interest? ');
disp('Click on a pt. in figure 4 -- ');
disp(' the cumulative squared coeffs plot.');  
disp('Right mouse button = choose a different threshold first.');

figure(4);
subplot(1,1,1);
[rdwt,yv,button] = ginput(1);

nj = log2(n) - jo;

% find the dwt in the DWT matrix that was selected

gap = pow2(nj) ;
ndwt = rem(round(rdwt),gap);

if ndwt == 0 
  ndwt = ndwt + gap ;
end;

ndwt
dwt = DWTs(:,ndwt);

