function figlabel(figname)
% figlabel -- Add label at bottom with file (or other) name and date
%  Usage
%    figlabel(figname)
%  Inputs
%    figname    string. In principle this can be any string.
%               In customary use, one supplies the name of the script
%               file generating the current display.
%  Outputs  
%    Near the bottom of the current figure, a label is displayed
%    in a small font; the label contains the figname and current date.
%
axes('Position',[.01 .01 .98 .05],'Visible','off');
h1 = text(.05,.5,figname); 
h2 = text(.80,.5,date);
set(h1,'FontSize',9);
set(h2,'FontSize',9);
