function sighat = medSDhat(hfcoefs);

% estimates the standard deviation of the data (for thresholding)
% from the highest frequency coeffs of a stationary wavelet 
% transform 
% input:
%	hfcoefs	highest frequency coeffs
% output:
%	sighat = estimate of the standard deviation
%

n = length(hfcoefs);
est = zeros(2,1);

for i = 1:2;
  x = hfcoefs(i:2:n);
  m = median(x);
  devs = abs(x - m);
  est(i) = (median(devs))/0.6545 ;
end;

sighat = mean(est);
