disp('MATLAB Script File:  SpaSiZer1t.m') ;
%
%   For Spatial Smoothing version of SiZer,
%   This is the test program for SpaSiZer1.m,
%


itest = 1 ;      %  1 - check out parameterizations
                 %  2 - simple examples from SpaSmoFid3
                 %  3 - experiment with alpha, and zero signal


if itest == 1 ;     %  Check out parametrizations

  testblock = 7 ;      %  1 - fiddle with data inputs
                       %  2 - fiddle with lambdas and thetas
                       %  3 - fiddle with control parameters
                       %  4 - fiddle with xgrid parameters
                       %  5 - fiddle with kernel string
                       %  6 - fiddle with input variance weights
                       %  7 - fiddle with output string
                       %  8 - fiddle with labels



  if testblock == 1 ;    % then fiddle with data inputs

    nxgrid = 100  ;
    left = 0 ;
    right = 1 ;
    xgrid = linspace(left,right,nxgrid)' ;

    xdat = xgrid ;

    fdat = 0.5 * exp(-(xdat - 0.3).^2 / 0.04) - ...
            0.5 * exp(-(xdat - 0.85).^2 / 0.005);
          %  target 4 from below

    seed = 12471197 ;
    randn('seed',seed) ;
    sig = 0.1 ;
    ydat = fdat + sig * randn(ndat,1) ;

    theta = .1 ;

    llmin = -3 ;
    llmax = 1 ;
    vlambda = logspace(-3,1,13) ;


    disp(' ') ;
    disp('Check standard nx2 data matrix') ;
      SpaSiZer1([xdat,ydat],vlambda,theta)  ;
    gppause ;


    disp(' ') ;
    disp('Check time series nx1 data matrix') ;
      SpaSiZer1(ydat,vlambda,theta)  ;
    gppause ;


    disp(' ') ;
    disp('Check transpose 2xn data matrix') ;
      SpaSiZer1([xdat,ydat]',vlambda,theta)  ;
    gppause ;


    disp(' ') ;
    disp('Check 3 column input') ;
      SpaSiZer1([xdat,ydat,ydat]',vlambda,theta)  ;
    gppause ;


    disp(' ') ;
    disp('Check empty input') ;
      SpaSiZer1([]',vlambda,theta)  ;


  elseif testblock == 2 ;    %  then fiddle with lambdas and thetas


    nxgrid = 100  ;
    left = 0 ;
    right = 1 ;
    xgrid = linspace(left,right,nxgrid)' ;

    xdat = xgrid ;

    fdat = 0.5 * exp(-(xdat - 0.3).^2 / 0.04) - ...
            0.5 * exp(-(xdat - 0.85).^2 / 0.005);
          %  target 4 from below

    seed = 12471197 ;
    randn('seed',seed) ;
    sig = 0.1 ;
    ydat = fdat + sig * randn(ndat,1) ;

    vtheta = [.01; .03; .1; .3; 1] ;

    llmin = -3 ;
    llmax = 1 ;
    vlambda = logspace(-3,1,13) ;


    disp(' ') ;
    disp('Check no lambda or theta') ;
      SpaSiZer1([xdat,ydat])  ;
    gppause ;


    disp(' ') ;
    disp('Check no theta') ;
      SpaSiZer1([xdat,ydat],vlambda)  ;
    gppause ;


    disp(' ') ;
    disp('Check standard input') ;
      SpaSiZer1([xdat,ydat],vlambda,vtheta)  ;
    gppause ;


    disp(' ') ;
    disp('Check single theta') ;
      SpaSiZer1([xdat,ydat],vlambda,vtheta(1))  ;
    gppause ;


    disp(' ') ;
    disp('Check single lamba') ;
      SpaSiZer1([xdat,ydat],vlambda(1),vtheta)  ;
    gppause ;



  elseif testblock == 3 ;    %  then fiddle with control parameters


    nxgrid = 100  ;
    left = 0 ;
    right = 1 ;
    xgrid = linspace(left,right,nxgrid)' ;

    xdat = xgrid ;
    ndat = nxgrid ;

    fdat = 0.5 * exp(-(xdat - 0.3).^2 / 0.04) - ...
            0.5 * exp(-(xdat - 0.85).^2 / 0.005);
          %  target 4 from below

    seed = 12471197 ;
    randn('seed',seed) ;
    sig = 0.1 ;
    ydat = fdat + sig * randn(ndat,1) ;

    vtheta = [.01; .03; .1; .3; 1] ;
    theta = .1 ;

    llmin = -3 ;
    llmax = 1 ;
    vlambda = logspace(-3,1,13) ;


    disp(' ') ;
    disp('Check defaults for all') ;
      SpaSiZer1([xdat,ydat],vlambda,theta)  ;
    gppause ;


    disp(' ') ;
    disp('Check defaults for last 4') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1)  ;
    gppause ;


    disp(' ') ;
    disp('Check defaults for last 3') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,[1,1])  ;
    gppause ;


    disp(' ') ;
    disp('Check defaults for last 2') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,[1,1,1])  ;
    gppause ;


    disp(' ') ;
    disp('Check defaults for last 1') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,[1,1,1,1])  ;
    gppause ;


    disp(' ') ;
    disp('Check defaults for none') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,[1,1,1,1,0.05])  ;
    gppause ;

    disp(' ') ;
    disp('Check swapping lamda and theta') ;
      SpaSiZer1([xdat,ydat],vlambda,vtheta,[2,1,1,1,0.05])  ;
    gppause ;

    disp(' ') ;
    disp('Check swapping lamda and theta, single lambda') ;
      SpaSiZer1([xdat,ydat],vlambda(1),vtheta,[2,1,1,1,0.05])  ;
    gppause ;


    disp(' ') ;
    disp('Check swapping lamda and theta, single theta') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,[2,1,1,1,0.05])  ;
    gppause ;


    disp(' ') ;
    disp('Check swapping lamda and theta, single lambda and theta') ;
      SpaSiZer1([xdat,ydat],vlambda(1),theta,[2,1,1,1,0.05])  ;
    gppause ;


    disp(' ') ;
    disp('Check movie version') ;
      SpaSiZer1([xdat,ydat],vlambda,vtheta,[1,2,1,1,0.05])  ;
    gppause ;


    disp(' ') ;
    disp('Check no pauses in series of still plots') ;
      SpaSiZer1([xdat,ydat],vlambda,vtheta,[1,1,0,1,0.05])  ;
    gppause ;


    disp(' ') ;
    disp('Check pauses in movie version') ;
      SpaSiZer1([xdat,ydat],vlambda,vtheta,[1,2,0,1,0.05])  ;
    gppause ;


    disp(' ') ;
    disp('Check linear operator variance') ;
      SpaSiZer1([xdat,ydat],vlambda,vtheta,[1,1,1,2,0.05])  ;
    gppause ;


    disp(' ') ;
    disp('Check small alpha = 0.01') ;
      SpaSiZer1([xdat,ydat],vlambda,vtheta,[1,1,1,2,0.01])  ;
    gppause ;


    disp(' ') ;
    disp('Check large alpha = 0.2') ;
      SpaSiZer1([xdat,ydat],vlambda,vtheta,[1,1,1,2,0.2])  ;
    gppause ;



  elseif testblock == 4 ;    %  then fiddle with xgrid parameters


    nxgrid = 100  ;
    left = 0 ;
    right = 1 ;
    xgrid = linspace(left,right,nxgrid)' ;

    xdat = xgrid ;
    ndat = nxgrid ;

    fdat = 0.5 * exp(-(xdat - 0.3).^2 / 0.04) - ...
            0.5 * exp(-(xdat - 0.85).^2 / 0.005);
          %  target 4 from below

    seed = 12471197 ;
    randn('seed',seed) ;
    sig = 0.1 ;
    ydat = fdat + sig * randn(ndat,1) ;

    vtheta = [.01; .03; .1; .3; 1] ;
    theta = .1 ;

    llmin = -3 ;
    llmax = 1 ;
    vlambda = logspace(-3,1,13) ;


    disp(' ') ;
    disp('Check defaults') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1)  ;
    gppause ;


    disp(' ') ;
    disp('Check simple single entry') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,1)  ;
    gppause ;


    disp(' ') ;
    disp('Check simple two entries') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,[0,1])  ;
    gppause ;


    disp(' ') ;
    disp('Check simple three entries') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,[0,1,100])  ;
    gppause ;


    disp(' ') ;
    disp('Check explicit grid entered') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,xdat)  ;
    gppause ;


    disp(' ') ;
    disp('Check extra dense grid') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,[0,1,400])  ;
    gppause ;


    disp(' ') ;
    disp('Check extra sparse grid') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,[0,1,25])  ;
    gppause ;



  elseif testblock == 5 ;    %  then fiddle with kernel string


    nxgrid = 100  ;
    left = 0 ;
    right = 1 ;
    xgrid = linspace(left,right,nxgrid)' ;

    xdat = xgrid ;
    ndat = nxgrid ;

    fdat = 0.5 * exp(-(xdat - 0.3).^2 / 0.04) - ...
            0.5 * exp(-(xdat - 0.85).^2 / 0.005);
          %  target 4 from below

    seed = 12471197 ;
    randn('seed',seed) ;
    sig = 0.1 ;
    ydat = fdat + sig * randn(ndat,1) ;

    vtheta = [.01; .03; .1; .3; 1] ;
    theta = .1 ;

    llmin = -3 ;
    llmax = 1 ;
    vlambda = logspace(-3,1,13) ;


    disp(' ') ;
    disp('Check defaults') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,1) ;
    gppause ;


    disp(' ') ;
    disp('Check explicit string') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,1,'kergauss') ;
    gppause ;


    disp(' ') ;
    disp('Check empty string') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,1,'') ;
    gppause ;


    disp(' ') ;
    disp('Check non string') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,1,3) ;
    gppause ;


    disp(' ') ;
    disp('Check wrong string') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,1,'kernotyet') ;
    gppause ;



  elseif testblock == 6 ;    %  then fiddle with input variance weights


    nxgrid = 100  ;
    left = 0 ;
    right = 1 ;
    xgrid = linspace(left,right,nxgrid)' ;

    xdat = xgrid ;
    ndat = nxgrid ;

    fdat = 0.5 * exp(-(xdat - 0.3).^2 / 0.04) - ...
            0.5 * exp(-(xdat - 0.85).^2 / 0.005);
          %  target 4 from below

    seed = 12471197 ;
    randn('seed',seed) ;
    sig = 0.1 ;
    ydat = fdat + sig * randn(ndat,1) ;

    vtheta = [.01; .03; .1; .3; 1] ;
    theta = .1 ;

    llmin = -3 ;
    llmax = 1 ;
    vlambda = logspace(-3,1,13) ;


    disp(' ') ;
    disp('Check defaults') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,1,'') ;
    gppause ;



  elseif testblock == 7 ;    %  then fiddle with output string


    nxgrid = 100  ;
    left = 0 ;
    right = 1 ;
    xgrid = linspace(left,right,nxgrid)' ;

    xdat = xgrid ;
    ndat = nxgrid ;

    fdat = 0.5 * exp(-(xdat - 0.3).^2 / 0.04) - ...
            0.5 * exp(-(xdat - 0.85).^2 / 0.005);
          %  target 4 from below

    seed = 12471197 ;
    randn('seed',seed) ;
    sig = 0.1 ;
    ydat = fdat + sig * randn(ndat,1) ;

    vtheta = [.01; .03; .1; .3; 1] ;
    theta = .1 ;

    llmin = -3 ;
    llmax = 1 ;
    vlambda = logspace(-3,1,13) ;


    disp(' ') ;
    disp('Check no writing for empty string') ;
      SpaSiZer1([xdat,ydat],vlambda,vtheta,[1,1,0],1,'',1,'') ;
    disp('Should write no files') ;
    gppause ;


    disp(' ') ;
    disp('Check defaults') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,[1,1,0],1,'',1) ;
    disp('Should put file "SpaSiZer11.ps" in current directory') ;
    gppause ;


    disp(' ') ;
    disp('Check different name for fixed plots') ;
      SpaSiZer1([xdat,ydat],vlambda,vtheta,[1,1,0],1,'',1,'temptest') ;
    disp('Should put files "temptest1-5.ps" in current directory') ;
    gppause ;


    disp(' ') ;
    disp('Check different name for fixed plots') ;
      SpaSiZer1([xdat,ydat],vlambda,vtheta,[1,1,0],1,'',1,...
                                        '\matlab\steve\ps\temptest') ;
    disp('Should put files "temptest1-5.ps" in the ps directory') ;
    gppause ;



  elseif testblock == 8 ;    %  then fiddle with labels


    nxgrid = 100  ;
    left = 0 ;
    right = 1 ;
    xgrid = linspace(left,right,nxgrid)' ;

    xdat = xgrid ;
    ndat = nxgrid ;

    fdat = 0.5 * exp(-(xdat - 0.3).^2 / 0.04) - ...
            0.5 * exp(-(xdat - 0.85).^2 / 0.005);
          %  target 4 from below

    seed = 12471197 ;
    randn('seed',seed) ;
    sig = 0.1 ;
    ydat = fdat + sig * randn(ndat,1) ;

    vtheta = [.01; .03; .1; .3; 1] ;
    theta = .1 ;

    llmin = -3 ;
    llmax = 1 ;
    vlambda = logspace(-3,1,13) ;


    disp(' ') ;
    disp('Check defaults') ;
      SpaSiZer1([xdat,ydat],vlambda,theta,1,1,'',1,'') ;
    disp('Should put file "SpaSiZer11.ps" in current directory') ;
    gppause ;




  end ;    %  of testblock if block


elseif itest == 2 ;     %  test different variances


  itar = 4 ;    %  1 - Zero
                %  2 - Line
                %  3 - Gasser Blip
                %  4 - Up - Down


  nxgrid = 100  ;
  left = 0 ;
  right = 1 ;
  xgrid = linspace(left,right,nxgrid)' ;

  ndat = nxgrid ;
  xdat = xgrid ;

  if itar == 1 ;
    fgrid = zeros(nxgrid,1) ;
    fdat = zeros(ndat,1) ;
  elseif itar == 2 ;
    fgrid = xgrid ;
    fdat = xdat ;
  elseif itar == 3 ;
    fgrid = xgrid + 0.4 * exp(-(xgrid - 0.5).^2 / 0.02) ;
    fdat = xdat + 0.4 * exp(-(xdat - 0.5).^2 / 0.02) ;
  elseif itar == 4 ;
    fgrid = 0.5 * exp(-(xgrid - 0.3).^2 / 0.04) - ...
            0.5 * exp(-(xgrid - 0.85).^2 / 0.005);
    fdat = 0.5 * exp(-(xdat - 0.3).^2 / 0.04) - ...
            0.5 * exp(-(xdat - 0.85).^2 / 0.005);
  end ;

  seed = 12471197 ;
  randn('seed',seed) ;
  sig = 0.1 ;
  ydat = fdat + sig * randn(ndat,1) ;


  vtheta = [.01; .03; .1; .3; 1] ;

  llmin = -3 ;
  llmax = 1 ;
  vlambda = logspace(-3,1,13) ;



  SpaSiZer1([xdat,ydat],vlambda,vtheta)  ;




elseif itest == 3 ;     %  explore alpha and zero signal





end ;

