disp('Running MATLAB script file FLoCyt1.m') ;
%
%    For analyzing Matt Wand's Flow Cytometry Data
%



idat = 3 ;     %  1 - ELU
               %  2 - LNU
               %  3 - TH


ipart = 1 ;    %  1 - Standard SiZer - SiCon for each column



if idat == 1 ; 
  infilestr = 'FloCytELU.txt' ;
  savestr = 'ELU' ;
elseif idat == 2 ; 
  infilestr = 'FloCytLNU.txt' ;
  savestr = 'LNU' ;
elseif idat == 3 ; 
  infilestr = 'FloCytTH.txt' ;
  savestr = 'TH' ;
end ;



xstr = 'channel' ;
ystr = 'sqrt(counts)' ;


fid = fopen(infilestr,'rt');
mdata = fscanf(fid,'%f') ;
mdata = reshape(mdata,14,256)' ;
          %  since reshape works column wise
mdata = sqrt(mdata) ;



figure(1) ;
clf ;



if ipart == 1 ;     %  Standard SiZer - SiCon


  %  loop through columns
  %
  for icol = 1:14 ;

    colstr = num2str(icol) ;
    titstr = ['Flow Cytometry, ' savestr ', col. ' colstr] ;

    vdata = mdata(:,icol) ;


    paramstruct = struct('iout',2, ...
                         'imovie',0, ...
                         'savestr',['FloCyt' savestr 'SiZerC' colstr], ...
                         'famoltitle',titstr, ...
                         'xlabelstr',xstr, ...
                         'ylabelstr',ystr, ...
                         'iscreenwrite',1) ;

    sizer2([(1:256)',vdata],paramstruct) ;


  end ;


elseif ipart == 2 ;   




end ;



