 
ndata = 150;
nplot = 150;
xplot = linspace(-2,2,nplot)';
xdata = linspace(-2, 2, ndata)';
mdata = 1 + xdata/2 + exp(-4*xdata.^2);
mplot = 1 + xplot/2 + exp(-4*xplot.^2);
						
xc = linspace(-2,2,50) ;		
p = 3;
mframes = 50;

movie1 = figure('Name', 'Scedasticity Comparison',...
	 'NumberTitle', 'off', 'Position', [230, 120, 700, 700]);

M1 = moviein(50, movie1);
		

for j=1:mframes ;			
	xmdata=ones(ndata,1) ;			
	xmplot = ones(nplot, 1);	
	x2data = xdata - xc(j) ;		
	x2plot = xplot - xc(j);
	if p > 0 ;		
        	for jj = 1:p ;		
        	   xmdata = [xmdata,(x2data.^jj)];
		   xmplot = [xmplot,(x2plot.^jj)];
        	   jj = jj + 1;		
       		end ;
	end ;
	band = .2; 
	kerndata =sqrt(2*pi)*pdfn(x2data./(band)) ;
	kernplot = sqrt(2*pi)*pdfn(x2plot./(band));
	randn('seed',92048) ;	
	sigma = (xdata + 2)/4;
	ydata = mdata + sigma.*randn(150,1) ;	
	xwdata = xmdata.*(kerndata*ones(1,p+1));	
	hat2 = inv(xwdata'*xmdata)*xwdata';		
	hatplot = xmplot*hat2 ;
	hat2= hat2(1,:) ;
	yhatplot = hatplot*ydata ;
	x_snake1 = xplot(abs(x2plot)<band) ;
	y_snake1 = yhatplot(abs(x2plot)<band) ;
	mhat1(j) = hat2*ydata ;

	
	subplot(2,2,1);
	plot(xplot,mplot,'w:',xplot,kernplot,'m-',x_snake1,y_snake1,'y-', xdata, ydata, 'b+') ;
	title('Increasing Hetreoscedasticity');	
	hold on;	
	a = plot(xc(1:j), mhat1(1:j), '-');	
	set (a, 'Color', [1 .7 0]);
	hold off;	
	set(gca,'Ylim',[0,2.5]);
	set(gca,'Xlim',[-2,2]);	
	h = line([xc(j),xc(j)],[0,2.5]);
	set(h, 'Color', [0 1 1]);
		



%222222222222222222222222222222222222

	xmdata=ones(ndata,1) ;			
	xmplot = ones(nplot, 1);	
	x2data = xdata - xc(j) ;		
	x2plot = xplot - xc(j);
	if p > 0 ;		
        	for jj = 1:p ;		
        	   xmdata = [xmdata,(x2data.^jj)];
		   xmplot = [xmplot,(x2plot.^jj)];
        	   jj = jj + 1;		
       		end ;
	end ;
	band = .2;
	kerndata =sqrt(2*pi)*pdfn(x2data./(band)) ;
	kernplot = sqrt(2*pi)*pdfn(x2plot./(band));
	randn('seed',92048) ;	
	ydata = mdata + (.5)*randn(150,1) ;
	xwdata = xmdata.*(kerndata*ones(1,p+1));	
	hat2 = inv(xwdata'*xmdata)*xwdata';		
	hatplot = xmplot*hat2 ;
	hat2= hat2(1,:) ;
	yhatplot = hatplot*ydata ;
	x_snake3 = xplot(abs(x2plot)<band) ;
	y_snake3 = yhatplot(abs(x2plot)<band) ;
	mhat3(j) = hat2*ydata ;

	
	subplot(2,2,2);
	plot(xplot,mplot,'w:',xplot,kernplot,'m-',x_snake3, y_snake3, 'r-', xdata, ydata, 'b+') ;
	title ('Homoscedastic');	
	hold on;	
	c = plot(xc(1:j), mhat3(1:j), '-');
	set (c, 'Color', [.6 0 0]);
	hold off;	
	set(gca,'Ylim',[0,2.5]) ;
	set(gca,'Xlim',[-2,2]);	
	h = line([xc(j),xc(j)],[0,2.5]);
	set(h, 'Color', [0 1 1]);
		
%333333333333333333333333333333333333333333

	xmdata=ones(ndata,1) ;			
	xmplot = ones(nplot, 1);	
	x2data = xdata - xc(j) ;		
	x2plot = xplot - xc(j);
	if p > 0 ;		
        	for jj = 1:p ;		
        	   xmdata = [xmdata,(x2data.^jj)];
		   xmplot = [xmplot,(x2plot.^jj)];
        	   jj = jj + 1;		
       		end ;
	end ;
	band = .2; 
	kerndata =sqrt(2*pi)*pdfn(x2data./(band)) ;
	kernplot = sqrt(2*pi)*pdfn(x2plot./(band));
	randn('seed',92048) ;		
	sigma = (2-xdata)/4;	
	ydata = mdata + sigma.*randn(150,1) ;
	xwdata = xmdata.*(kerndata*ones(1,p+1));	
	hat2 = inv(xwdata'*xmdata)*xwdata';		
	hatplot = xmplot*hat2 ;
	hat2= hat2(1,:) ;
	yhatplot = hatplot*ydata ;
	x_snake2 = xplot(abs(x2plot)<band) ;
	y_snake2 = yhatplot(abs(x2plot)<band) ;
	mhat2(j) = hat2*ydata ;

	
	subplot(2, 2, 3);
	plot(xplot,mplot,'w:',xplot,kernplot,'m-',x_snake2, y_snake2, 'g-', xdata, ydata, 'b+') ;
	title ('Decreasing Heteroscedasticity')	
	hold on;	
	b = plot(xc(1:j), mhat2(1:j), '-');
	set (b, 'Color', [0 .7 0]);
	hold off;	
	set(gca,'Ylim',[0,2.5]) ;
	set(gca,'Xlim',[-2,2]);	
	h = line([xc(j),xc(j)],[0,2.5]);
	set(h, 'Color', [0 1 1]);


%4444444444444444444444444444444444

	subplot(2,2,4);
	plot(xplot,mplot, 'w:',x_snake1, y_snake1, 'y-', x_snake2, y_snake2,'r-', x_snake3, y_snake3, 'g-');
	title ('Comparison Window');	
	hold on;
	a1 = plot(xc(1:j), mhat1(1:j), '-');	
	set (a1, 'Color', [1 .7 0]);
	b2 = plot(xc(1:j), mhat2(1:j), '-');
	set (b2, 'Color', [.6 0 0]);
	c3 = plot(xc(1:j), mhat3(1:j), '-');
	set (c3, 'Color', [0 .7 0]);
	hold off;


	set(gca, 'Ylim', [0, 2.5]);
	set(gca, 'Xlim', [-2,2]);
	h = line([xc(j),xc(j)],[0,2.5]);
	set(h, 'Color',[0 1 1]);
figure(movie1);	
M1(:,j) = getframe(movie1);
end ;

clf;
h = axes('Visible', 'off');
h = axes('Position', [0 0 1 1]);
movie(M1, 6);


       		
