
ndata = 150;
nplot = 150;
xplot = linspace(-2,2,nplot)';
xdata = linspace(-2, 2, ndata)';
mdata = 1 + xdata/2 + exp(-4*xdata.^2);
mplot = 1 + xplot/2 + exp(-4*xplot.^2);
ydata = mdata + (.2)*randn(150,1) ;						
xc = linspace(-2,2,50) ;		
band = .6;
mframes = 50;
mbar1_prev = 0;
yhatplot1_prev = 0;
mhatplot1_prev = 0;
mbar2_prev = 0;
yhatplot2_prev = 0;
mhatplot2_prev = 0;
mbar3_prev = 0;
yhatplot3_prev = 0;
mhatplot3_prev = 0;

movie1 = figure('Name', 'Large p Comparison',...
	 'NumberTitle', 'off', 'Position', [230, 120, 700, 700]);
figure(movie1);
M1 = moviein(50, movie1);

for j=1:mframes ;
	clf;
	p = 3;			
	xmdata=ones(ndata,1) ;			
	xmplot = ones(nplot, 1);	
	x2data = xdata - xc(j) ;		
	x2plot = xplot - xc(j);
	if p > 0 ;		
        	for jj = 1:p ;		
        	   xmdata = [xmdata,(x2data.^jj)];
		   xmplot = [xmplot,(x2plot.^jj)];
        	   jj = jj + 1;		
       		end ;
	end ;
	
	kerndata =sqrt(2*pi)*pdfn(x2data./(band)) ;
	kernplot = sqrt(2*pi)*pdfn(x2plot./(band));

		

	xwdata = xmdata.*(kerndata*ones(1,p+1));	
	hat2 = inv(xwdata'*xmdata)*xwdata';		
	hatplot = xmplot*hat2 ;
	hat2= hat2(1,:) ;
	yhatplot1 = hatplot*ydata ;
	mhatplot1 = hatplot*mdata ;
	x_snake1 = xplot(abs(x2plot)<band) ;
	y_snake1 = yhatplot1(abs(x2plot)<band) ;
	y_no_noise_snake1 = mhatplot1(abs(x2plot)<band) ;
	mhat1(j) = hat2*ydata ;
	mbar1 = mean(mdata(abs(x2plot)<band));
	

	noise1 = (sum((yhatplot1 - mhatplot1).^2))/(sum((yhatplot1-mbar1).^2));
	if noise1 > 1;
		noise1 = 1;
	end;

	bias1 = (sum((mhatplot1-mdata).^2))/(sum((mdata-mbar1).^2));	
	if bias1 > 1;
		bias1 = 1;
	end;



	noise_vol1_top = sum(((yhatplot1-mbar1) - (yhatplot1_prev-mbar1_prev)).^2);
	noise_vol1_bot = .5*(sum((yhatplot1 - mbar1).^2) + sum((yhatplot1_prev-mbar1_prev).^2));
	noise_vol1 = noise_vol1_top/noise_vol1_bot;		
	if noise_vol1 > 1;
		noise_vol1 = 1;
	end;

		
	bias_vol1_top = sum(((mhatplot1-mbar1)-(mhatplot1_prev-mbar1_prev)).^2);
	bias_vol1_bot = .5*(sum((mhatplot1-mbar1).^2) + sum((mhatplot1_prev-mbar1_prev).^2));
	bias_vol1 = (bias_vol1_top/bias_vol1_bot);

	if bias_vol1 >1;
		bias_vol1 = 1;
	end;
	y_snake1_prev = y_snake1;
	mbar1_prev = mbar1;
	y_no_noise_snake1_prev = y_no_noise_snake1;
	x_snake1_prev = x_snake1;
	yhatplot1_prev = yhatplot1;
	mhatplot1_prev = mhatplot1;

	subplot(2,2,1);
	plot(xplot,mplot,'w:',xplot,kernplot,'m-',x_snake1,y_snake1,'y-', xdata, ydata, 'b+') ;
	title('p = 3');	
	hold on;	
	a = plot(xc(1:j), mhat1(1:j), '-');	
	set (a, 'Color', [.8 .8 0]);
	hold off;	
	set(gca,'Ylim',[0,2.5]);
	set(gca,'Xlim',[-2,2]);	
	h = line([xc(j),xc(j)],[0,2.5]);
	set(h, 'Color', [0 1 1]);
		

%2222222222222222222222222222222222
	p=4;
	xmdata=ones(ndata,1) ;			
	xmplot = ones(nplot, 1);	
	x2data = xdata - xc(j) ;		
	x2plot = xplot - xc(j);
	if p > 0 ;		
        	for jj = 1:p ;		
        	   xmdata = [xmdata,(x2data.^jj)];
		   xmplot = [xmplot,(x2plot.^jj)];
        	   jj = jj + 1;		
       		end ;
	end ;
	
	kerndata =sqrt(2*pi)*pdfn(x2data./(band)) ;
	kernplot = sqrt(2*pi)*pdfn(x2plot./(band));

		

	xwdata = xmdata.*(kerndata*ones(1,p+1));	
	hat2 = inv(xwdata'*xmdata)*xwdata';		
	hatplot = xmplot*hat2 ;
	hat2= hat2(1,:) ;
	yhatplot2 = hatplot*ydata ;
	mhatplot2 = hatplot*mdata ;
	x_snake2 = xplot(abs(x2plot)<band) ;
	y_snake2 = yhatplot2(abs(x2plot)<band) ;
	y_no_noise_snake2 = mhatplot2(abs(x2plot)<band) ;
	mhat2(j) = hat2*ydata ;
	mbar2 = mean(mdata(abs(x2plot)<band));
	

	noise2 = (sum((yhatplot2 - mhatplot2).^2))/(sum((yhatplot2-mbar2).^2))	;
	if noise2 > 1;
		noise2 = 1;
	end;

	bias2 = (sum((mhatplot2-mdata).^2))/(sum((mdata-mbar2).^2));
	if bias2 > 1;
		bias2 = 1;
	end;



	noise_vol2_top = sum(((yhatplot2-mbar2) - (yhatplot2_prev-mbar2_prev)).^2);
	noise_vol2_bot = .5*(sum((yhatplot2 - mbar2).^2) + sum((yhatplot2_prev-mbar2_prev).^2));
	noise_vol2 = noise_vol2_top/noise_vol2_bot;	
	if noise_vol2 > 1;
		noise_vol2 = 1;
	end;

		
	bias_vol2_top = sum(((mhatplot2-mbar2)-(mhatplot2_prev-mbar2_prev)).^2);
	bias_vol2_bot = .5*(sum((mhatplot2-mbar2).^2) + sum((mhatplot2_prev-mbar2_prev).^2));
	bias_vol2 = (bias_vol2_top/bias_vol2_bot);

	if bias_vol2 >1;
		bias_vol2 = 1;
	end;
	y_snake2_prev = y_snake2;
	mbar2_prev = mbar2;
	y_no_noise_snake2_prev = y_no_noise_snake2;
	x_snake2_prev = x_snake2;
	yhatplot2_prev = yhatplot2;
	mhatplot2_prev = mhatplot2;

	subplot(2,2,2);
	plot(xplot,mplot,'w:',xplot,kernplot,'m-',x_snake2,y_snake2,'g-', xdata, ydata, 'b+') ;
	title('p = 4');	
	hold on;	
	a = plot(xc(1:j), mhat2(1:j), '-');	
	set (a, 'Color', [.2 .6 0]);
	hold off;	
	set(gca,'Ylim',[0,2.5]);
	set(gca,'Xlim',[-2,2]);	
	h = line([xc(j),xc(j)],[0,2.5]);
	set(h, 'Color', [0 1 1]);

	
%3333333333333333333333333333333333333
	p=5;
	xmdata=ones(ndata,1) ;			
	xmplot = ones(nplot, 1);	
	x2data = xdata - xc(j) ;		
	x2plot = xplot - xc(j);
	if p > 0 ;		
        	for jj = 1:p ;		
        	   xmdata = [xmdata,(x2data.^jj)];
		   xmplot = [xmplot,(x2plot.^jj)];
        	   jj = jj + 1;		
       		end ;
	end ;
	
	kerndata =sqrt(2*pi)*pdfn(x2data./(band)) ;
	kernplot = sqrt(2*pi)*pdfn(x2plot./(band));

		

	xwdata = xmdata.*(kerndata*ones(1,p+1));	
	hat2 = inv(xwdata'*xmdata)*xwdata';		
	hatplot = xmplot*hat2 ;
	hat2= hat2(1,:) ;
	yhatplot3 = hatplot*ydata ;
	mhatplot3 = hatplot*mdata ;
	x_snake3 = xplot(abs(x2plot)<band) ;
	y_snake3 = yhatplot3(abs(x2plot)<band) ;
	y_no_noise_snake3 = mhatplot3(abs(x2plot)<band) ;
	mhat3(j) = hat2*ydata ;
	mbar3 = mean(mdata(abs(x2plot)<band));
	


	noise3 = (sum((yhatplot3 - mhatplot3).^2))/(sum((yhatplot3-mbar3).^2))	;
	if noise3 > 1;
		noise3 = 1;
	end;

	bias3 = (sum((mhatplot3-mdata).^2))/(sum((mdata-mbar3).^2));	
	if bias3 > 1;
		bias3 = 1;
	end;



	noise_vol3_top = sum(((yhatplot3-mbar3) - (yhatplot3_prev-mbar3_prev)).^2);
	noise_vol3_bot = .5*(sum((yhatplot3 - mbar3).^2) + sum((yhatplot3_prev-mbar3_prev).^2));
	noise_vol3 = noise_vol3_top/noise_vol3_bot;	
	if noise_vol3 > 1;
		noise_vol3 = 1;
	end;

		
	bias_vol3_top = sum(((mhatplot3-mbar3)-(mhatplot3_prev-mbar3_prev)).^2);
	bias_vol3_bot = .5*(sum((mhatplot3-mbar3).^2) + sum((mhatplot3_prev-mbar3_prev).^2));
	bias_vol3 = (bias_vol3_top/bias_vol3_bot);

	if bias_vol3 >1;
		bias_vol3 = 1;
	end;
	y_snake3_prev = y_snake3;
	mbar3_prev = mbar3;
	y_no_noise_snake3_prev = y_no_noise_snake3;
	x_snake3_prev = x_snake3;
	yhatplot3_prev = yhatplot3;
	mhatplot3_prev = mhatplot3;

	subplot(2,2,3);
	plot(xplot,mplot,'w:',xplot,kernplot,'m-',x_snake3,y_snake3,'r-', xdata, ydata, 'b+') ;
	title('p = 5');	
	hold on;	
	a = plot(xc(1:j), mhat3(1:j), '-');	
	set (a, 'Color', [.8 .8 0]);
	hold off;	
	set(gca,'Ylim',[0,2.5]);
	set(gca,'Xlim',[-2,2]);	
	h = line([xc(j),xc(j)],[0,2.5]);
	set(h, 'Color', [0 1 1]);
	

%4444444444444444444444444444444444

	subplot('position', [.75 .22 .2 .2]);
	cla;
	h = axis('off');
	xaxis = line ([0,0], [-1, 1]);
	yaxis = line ([-1, 1], [0,0]);
	set (xaxis, 'Color', [0 1 1]);
	set (yaxis, 'Color', [0 1 1]);	
		
	
	h1_noise = line ([-bias_vol1, bias1], [noise1, noise1]);
	h1_bias = line ([bias1, bias1], [-noise_vol1, noise1]);
	h1_noisevol = line ([-bias_vol1, bias1], [-noise_vol1, -noise_vol1]);
	h1_biasvol = line ([-bias_vol1, -bias_vol1], [-noise_vol1, noise1]);
	
	set(h1_noise, 'color', 'y');
	set(h1_bias, 'color', 'y');
	set(h1_noisevol, 'color', 'y');
	set(h1_biasvol, 'color', 'y');

	h2_noise = line ([-bias_vol2, bias2], [noise2, noise2]);
	h2_bias = line ([bias2, bias2], [-noise_vol2, noise2]);
	h2_noisevol = line ([-bias_vol2, bias2], [-noise_vol2, -noise_vol2]);
	h2_biasvol = line ([-bias_vol2, -bias_vol2], [-noise_vol2, noise2]);

	set(h2_noise, 'color', 'g');
	set(h2_bias, 'color', 'g');
	set(h2_noisevol, 'color', 'g');
	set(h2_biasvol, 'color', 'g');

	h3_noise = line ([-bias_vol3, bias3], [noise3, noise3]);
	h3_bias = line ([bias3, bias3], [-noise_vol3, noise3]);
	h3_noisevol = line ([-bias_vol3, bias3], [-noise_vol3, -noise_vol3]);
	h3_biasvol = line ([-bias_vol3, -bias_vol3], [-noise_vol3, noise3]);

	set(h3_noise, 'color', 'r');
	set(h3_bias, 'color', 'r');
	set(h3_noisevol, 'color', 'r');
	set(h3_biasvol, 'color', 'r');

	subplot('position',[.50 .2 .2 .25]);
	cla;
	
		
x_snakeA = linspace(x_snake1(1)-xc(j), x_snake1(length(x_snake1))-xc(j), length(y_snake1));
	x_snakeB = linspace(x_snake2(1)-xc(j), x_snake2(length(x_snake2))-xc(j), length(y_snake2));
	x_snakeC = linspace(x_snake3(1)-xc(j), x_snake3(length(x_snake3))-xc(j), length(y_snake3));
	
	plot(x_snakeA, y_snake1, 'y-', x_snakeB, y_snake2, 'g', x_snakeC, y_snake3, 'r');
	h = line([0,0], [-2.5, 2.5]);
	set(h, 'Color', [0 1 1]);
		
	q = axis('off');
	set(gca, 'xlim', [-2 2]);	
	
M1(:,j) = getframe(movie1);
end ;

clf;
h = axes('Visible', 'off');
h = axes('Position', [0 0 1 1]);
movie(M1, 6);
