
 gcf = figure('Color', [.2 0 .8], 'Name', 'Interactive Kernel Smoothing',...
	'NumberTitle', 'off');




% menu controls
if exist('band');
	sli_band = uicontrol (gcf,...
		'Style', 'slider',...
		'Position',[50 100 120 20],...
		'Min', -3, 'Max', 2, 'Value', log2(band),...
		'CallBack',  ['band = (2.^(get(sli_band, ''Val'')));',...
		'set(band_cur, ''String'', num2str(band))']);
else;
	band = .6;
	sli_band = uicontrol (gcf,...
		'Style', 'slider',...
		'Position',[50 100 120 20],...
		'Min', -3, 'Max', 2, 'Value', log2(band),...
		'CallBack',  ['band = (2.^(get(sli_band, ''Val'')));',...
		'set(band_cur, ''String'', num2str(band))']);
end

band_min = uicontrol (gcf, ...
	'Style', 'text', ...
	'Pos', [20 100 30 20],...
	'String', num2str (get(sli_band, 'Min')));

band_max = uicontrol (gcf,...
	'Style', 'text',...
	'Pos', [170 100 30 20],...
	'String', num2str(get(sli_band, 'Max')),...
	'Horiz', 'right');

band_label =  uicontrol (gcf,...
	'Style', 'text',...
	'Pos', [20 130 130 20],...
	'String', 'Bandwidth - log2');

band_cur = uicontrol (gcf, ...
	'Style', 'text',...
	'Pos', [155 130 45 20],...
	'String', num2str(band));


if exist('ndata');
	edit_ndata = uicontrol (gcf,...
		'Style', 'edit',...
		'String', ndata,...
		'Position', [50 330 120 30],...
		'CallBack', ['ndata = str2num(get(edit_ndata ,''String''));' 'set_x;' ]);
else;
	ndata = 161;
 	edit_ndata = uicontrol (gcf,...
		'Style', 'edit',...
		'String', ndata,...
		'Position', [50 330 120 30],...
		'CallBack', ['ndata = str2num(get(edit_ndata ,''String''));' 'set_x;' ]);
end;

editndata_label  = uicontrol (gcf,...
	'Style', 'text',...
	'String', 'Enter number of',...
	'Pos', [50, 385, 120, 20]);

editndata_label1 = uicontrol (gcf,...
	'Style', 'text',...
	'String', 'data points:',...
	'Pos', [50, 365, 120, 20]);

if exist ('ikern');
	popupkern = uicontrol (gcf,...
		'Style','popup',...
		'String','Normal|Epanechnikov|Uniform|Biweight|Triweight',...
		'Value', ikern+1,...	
		'Position', [10 250 120 40],...
		'CallBack', ['pkerncol = [0, 1, 2, 3, 4];',...
		'ikern = pkerncol(get(popupkern, ''Value''));']);
else;
	ikern = 0;
	popupkern = uicontrol (gcf,...
		'Style','popup',...
		'String','Normal|Epanechnikov|Uniform|Biweight|Triweight',...
		'Position', [10 250 120 40],...
		'Value', ikern,...
		'CallBack', ['pkerncol = [0, 1, 2, 3, 4];',...
		'ikern = pkerncol(get(popupkern, ''Value''));']);
end;

popupkern_label = uicontrol (gcf,...
	'Style', 'text',...
	'Pos', [10 295 120 20],...
	'String' ,' Select Kernel ');

radiokern_label = uicontrol (gcf,...
	'Style', 'text',...
	'Pos', [135, 295, 80, 20],...
	'String', 'Canonical?');

if exist ('can');
	if can == 1;
		radiokern_can = uicontrol (gcf,...
			'Style', 'radio',...
			'Pos', [135, 270, 80, 20],...
			'Value', can,...
			'String', 'Yes',...
			'CallBack',[...
			'set(radiokern_can, ''Value'', 1);'...
			'set(radiokern_noncan, ''Value'', 0),'...
			'can = 1;']);

		radiokern_noncan = uicontrol (gcf,...
			'Style', 'radio',...
			'Pos', [135, 250, 80, 20],...
			'Value', 0,...		
			'String', 'No',...
			'CallBack', [...
			'set(radiokern_noncan, ''Value'', 1),'...
			'set(radiokern_can, ''Value'', 0);'...
			'can = 0;']);

	else;
		radiokern_can = uicontrol (gcf,...
			'Style', 'radio',...
			'Pos', [135, 270, 80, 20],...
			'Value', can,...
			'String', 'Yes',...
			'CallBack',[...
			'set(radiokern_can, ''Value'', 1);'...
			'set(radiokern_noncan, ''Value'', 0),'...
			'can = 1;']);

		radiokern_noncan = uicontrol (gcf,...
			'Style', 'radio',...
			'Pos', [135, 250, 80, 20],...
			'Value', 1,...		
			'String', 'No',...
			'CallBack', [...
			'set(radiokern_noncan, ''Value'', 1),'...
			'set(radiokern_can, ''Value'', 0);'...
			'can = 0;']);
	end;

else;
	can = 1;
	radiokern_can = uicontrol (gcf,...
		'Style', 'radio',...
		'Pos', [135, 270, 80, 20],...
		'Value', can,...
		'String', 'Yes',...
		'CallBack',[...
		'set(radiokern_can, ''Value'', 1);'...
		'set(radiokern_noncan, ''Value'', 0),'...
		'can = 1;']);

	radiokern_noncan = uicontrol (gcf,...
		'Style', 'radio',...
		'Pos', [135, 250, 80, 20],...
		'String', 'No',...
		'CallBack', [...
		'set(radiokern_noncan, ''Value'', 1),'...
		'set(radiokern_can, ''Value'', 0);'...
		'can = 0;']);
end;
if exist ('xset');
	popupxs = uicontrol (gcf,...
		'Style', 'popup',...
		'String', 'Equally Spaced|Randomly Spaced|Normally Spaced|Unevenly Spaced',...
		'Value', xset+1,...
		'Position', [25, 170, 170, 40],...
		'CallBack', ['xscol = [0, 1, 2, 3];',...
		'xset = xscol(get(popupxs, ''Value''));']);
else;
	xset = 0;
	popupxs = uicontrol (gcf,...
		'Style', 'popup',...
		'String', 'Equally Spaced|Randomly Spaced|Normally Spaced|Unevenly Spaced',...
		'Value', [0],...
		'Position', [25, 170, 170, 40],...
		'CallBack', ['xscol = [0, 1, 2, 3];',...
		'xset = xscol(get(popupxs, ''Value''));']);
end;

popupxs_label = uicontrol (gcf,...
	'Style', 'text',...
	'Pos', [25, 215, 170, 20],...
	'String', 'Select x Spacing:');

if exist ('mframes');
	edit_M = uicontrol (gcf,...
		'Style', 'edit',...
		'String', mframes,...
		'Position', [200 330 120 30],...
		'CallBack', 'mframes = str2num(get(edit_M ,''String''));');
else;
	mframes = 50;
	edit_M = uicontrol (gcf,...
		'Style', 'edit',...
		'String', mframes,...
		'Position', [200 330 120 30],...
		'CallBack', 'mframes = str2num(get(edit_M ,''String''));');
end;

editM_label  = uicontrol (gcf,...
	'Style', 'text',...
	'String', 'Enter number of',...
	'Pos', [200, 385, 120, 20]);

editM_label1 = uicontrol (gcf,...
	'Style', 'text',...
	'String', 'movie frames:',...
	'Pos', [200, 365, 120, 20]);


if exist ('p');
	popupdegree = uicontrol (gcf,...
		'Style', 'popup',...
		'String', '0|1|2|3|4|5',...
		'Value', p+1,...
		'Position', [350 330 120 30],...
		'CallBack', ['pcol = [0, 1, 2, 3, 4, 5];',...
		'p = pcol(get(popupdegree, ''Value''));']);
else;
	p=3;
	popupdegree = uicontrol (gcf,...
		'Style', 'popup',...
		'String', '0|1|2|3|4|5',...
		'Value', p,...
		'Position', [350 330 120 30],...
		'CallBack', ['pcol = [0, 1, 2, 3, 4, 5];',...
		'p = pcol(get(popupdegree, ''Value''));']);
end;

popupdeg_label = uicontrol (gcf,...
	'Style', 'text',...
	'Pos', [350 375 120 20],...
	'String', 'Select p');

if exist ('color');
	popupdata = uicontrol (gcf,...
		'Style', 'popup',...
		'String', 'Varying Color Intensity|Varying Marker Size|Both|Neither',...
		'Value', color+1,...
		'Position', [275, 170, 170, 40],...
		'CallBack', ['colorcol = [0, 1, 2, 3];',...
		'color = colorcol(get(popupdata, ''Value''));']);
else;
	color = 0;
	popupdata = uicontrol (gcf,...
		'Style', 'popup',...
		'String', 'Varying Color Intensity|Varying Marker Size|Both|Neither',...
		'Value', color+1,...
		'Position', [275, 170, 170, 40],...
		'CallBack', ['colorcol = [0, 1, 2, 3];',...
		'color = colorcol(get(popupdata, ''Value''));']);
end;

popupdata_label = uicontrol (gcf,...
	'Style', 'text',...
	'Pos', [275, 215, 170, 20],...
	'String', 'Select Data Options');

if exist ('design');
	popupdesign = uicontrol (gcf,...
		'Style', 'popup',...
		'String', 'Blip|Linear|Sine Wave',...
		'Value', design+1,...
		'Position', [275 250 170 40],...
		'CallBack', ['designcol = [0, 1, 2];',...
		'design = designcol(get(popupdesign, ''Value''));']);
else;
	design = 0;
	popupdesign = uicontrol (gcf,...
		'Style', 'popup',...
		'String', 'Blip|Linear|Sine Wave',...
		'Value', design+1,...
		'Position', [275 250 170 40],...
		'CallBack', ['designcol = [0, 1, 2];',...
		'design = designcol(get(popupdesign, ''Value''));']);
end;

popupdesign_label = uicontrol (gcf,...
	'Style', 'text',...
	'Pos', [275 295 170 20],...
	'String', 'Select Curve Design');



if exist ('mrepeat');
	edit_Mrep = uicontrol (gcf,...
		'Style', 'edit',...
		'String', mrepeat,...
		'Position', [50 15 120 30],...
		'CallBack', 'mrepeat = str2num(get(edit_Mrep ,''String''));');
else;
	mrepeat = 7;
	edit_Mrep = uicontrol (gcf,...
		'Style', 'edit',...
		'String', mrepeat,...
		'Position', [50 15 120 30],...
		'CallBack', 'mrepeat = str2num(get(edit_Mrep ,''String''));');
end;

editMrep_label  = uicontrol (gcf,...
	'Style', 'text',...
	'String', 'Enter number of',...
	'Pos', [50, 70, 120, 20]);

editMrep_label1 = uicontrol (gcf,...
	'Style', 'text',...
	'String', 'movie repetitions:',...
	'Pos', [50, 50, 120, 20]);


popupsced_label = uicontrol (gcf,...
	'Style', 'text',...
	'String', 'Scedasticity',...
	'Pos', [220 60 170 20]);


sig0 = .2;
sli_noise = uicontrol (gcf,...
		'Style', 'slider',...
		'Position',[300 100 120 20],...
		'Min', -6, 'Max', 4, 'Value', log2(sig0),...
		'CallBack',  ['sig0 = (2.^(get(sli_noise, ''Val'')));',...
		'set(noise_cur, ''String'', num2str(sig0))']);
	
noise_min = uicontrol (gcf, ...
	'Style', 'text', ...
	'Pos', [270 100 30 20],...
	'String', num2str (get(sli_noise, 'Min')));

noise_max = uicontrol (gcf,...
	'Style', 'text',...
	'Pos', [420 100 30 20],...
	'String', num2str(get(sli_noise, 'Max')),...
	'Horiz', 'right');

noise_label =  uicontrol (gcf,...
	'Style', 'text',...
	'Pos', [270 130 130 20],...
	'String', 'Noise Level - log2');

noise_cur = uicontrol (gcf, ...
	'Style', 'text',...
	'Pos', [405 130 45 20],...
	'String', num2str(sig0));

sced = 2;
popup_sced = uicontrol (gcf,...
	'Style', 'popup',...
	'String', 'Hetero - increasing|Hetero - decreasing|Homoscedastic|Zero Noise',...
	'Value', sced+1,...
	'Position', [220 15 170 30],...
	'CallBack', ['scedcol = [0, 1, 2, 3];',...
	'sced = scedcol(get(popup_sced, ''Value''));',...
	'set_x;' 'sced_check']);

run_movie = uicontrol (gcf,...
	'Style', 'push',...
	'String', 'Run Movie',...
	'Position', [430 10 120 25],...
	'BackGroundColor', [1 0 0],...
	'ForeGroundColor', [1 1 1],...
	'CallBack', ['compsig;' 'close  (gcf);' 'set_x;'  'movie_run']);

backstart = uicontrol (gcf,...
	'Style', 'push',...
	'String', 'Return to Start',...
	'Position', [430 40 120 25],...
	'CallBack', ['close (gcf);' 'start']);
