
%randn('seed',92048) ;
			
reminder = figure('Name', 'Your Choices', 'NumberTitle', 'off',...
	'Position', [175 10 430 380]);

data_points_choice = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [10 350 200 20],...
	'String', 'Number of Data Points:');

data_points_view = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [220 350 200 20],...
	'String', num2str(ndata));

movie_frames_choice = uicontrol (reminder,...
	'Style', 'text',...
	'Position', [10 325 200 20],...
	'String', 'Number of Movie Frames:');

movie_frames_view = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [220 325 200 20],...
	'String', num2str(mframes));

p_choice = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [10 300 200 20],...
	'String', 'p:');

p_view = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [220 300 200 20],...
	'String', num2str(p));

Kernel_choice = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [10 275 200 20],...
	'String', 'Kernel Choice:');

if ikern == 0;	
	Kernel_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 275 200 20],...
		'String', 'Normal');
elseif ikern ==1;
	Kernel_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 275 200 20],...
		'String', 'Epanechnikov');
elseif ikern ==2;
	Kernel_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 275 200 20],...
		'String', 'Uniform');
elseif ikern ==3;
	Kernel_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 275 200 20],...
		'String', 'Biweight');
elseif ikern ==4;
	Kernel_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 275 200 20],...
		'String', 'Triweight');
end;

Canonical_choice = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [10 250 200 20],...
	'String', 'Canonical?:');

if can ==0;
	Canonical_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 250 200 20],...
		'String', 'No');
elseif can ==1;
	Canonical_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 250 200 20],...
		'String', 'Yes');
end;
	

X_spacing_choice = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [10 225 200 20],...
	'String', 'X Spacing:');

if xset ==0;
	X_spacing_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 225 200 20],...
		'String', 'Equally Spaced');
elseif xset ==1;
	X_spacing_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 225 200 20],...
		'String', 'Randomly Spaced');
elseif xset ==2;
	X_spacing_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 225 200 20],...
		'String', 'Normally Spaced');
else;
	X_spacing_view = uicontrol (reminder,...
		'Style', 'text',...
		'Position', [220 225 200 20],...
		'String', 'Unevenly Spaced');
end;

Bandwidth_choice = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [10 200 200 20],...
	'String', 'Bandwidth:');

Bandwidth_view = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [220 200 200 20],...
	'String', num2str(band));


Movie_Repetitions_choice = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [10 175 200 20],...
	'String', 'Movie Repetitions:');

Movie_Repetitions_view = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [220 175 200 20],...
	'String', num2str(mrepeat));

Curve_choice =uicontrol(reminder,...
	'Style', 'text',...
	'Position', [10 150 200 20],...
	'String', 'Curve Design:');

if design ==0;
	Curve_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 150 200 20],...
		'String', 'Blip');
elseif design ==1;
	Curve_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 150 200 20],...
		'String', 'Linear');
elseif design ==2;
	Curve_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 150 200 20],...
		'String', 'Sine Wave');
end;


Data_options_choice = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [10 125 200 20],...
	'String', 'Data Options:');

if color ==0;
	Data_options_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 125 200 20],...
		'String', 'Varying Color Intensity');
elseif color ==1;
	Data_options_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 125 200 20],...
		'String', 'Varying Marker Size');
elseif color ==2;
	Data_options_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 125 200 20],...
		'String', 'Varying Color & Size');
elseif color ==3;
	Data_options_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 125 200 20],...
		'String', 'No options');
end;


Scedasticity_choice = uicontrol(reminder,...
	'Style', 'text',...
	'Position', [10 100 200 20],...
	'String', 'Scedasticity:');

if sced ==0;
	Scedasticity_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 100 200 20],...
		'String', 'Increasing Heteroscedastic');
	Sced_Max_choice = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [10 75 200 20],...
		'String', 'Minimum Variation');
	Sced_Max_view = uicontrol (reminder,...
		'Style', 'text',...
		'Position', [220 75 200 20],...
		'String', num2str(sigma1));
	Sced_Min_choice = uicontrol (reminder,...
		'Style', 'text',...
		'Position', [10 50 200 20],...
		'String', 'Maximum Variation');
	Sced_Min_view = uicontrol (reminder,...
		'Style', 'text',...
		'Position', [220 50 200 20],...
		'String', num2str(sigma2));

elseif sced ==1;
	Scedasticity_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 100 200 20],...
		'String', 'Decreasing Heteroscedastic');
	Sced_Max_choice = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [10 75 200 20],...
		'String', 'Maximum Variation');
	Sced_Max_view = uicontrol (reminder,...
		'Style', 'text',...
		'Position', [220 75 200 20],...
		'String', num2str(sigma1));
	Sced_Min_choice = uicontrol (reminder,...
		'Style', 'text',...
		'Position', [10 50 200 20],...
		'String', 'Minimum Variation');
	Sced_Min_view = uicontrol (reminder,...
		'Style', 'text',...
		'Position', [220 50 200 20],...
		'String', num2str(sigma2));

elseif sced ==2;
	Scedasticity_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 100 200 20],...
		'String', 'Homoscedastic');
	Noise_level_choice = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [10 75 200 20],...
		'String', 'Noise Level:');

	Noise_level_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 75 200 20],...
		'String', num2str(sig0));

elseif sced ==3;
	Scedasticity_view = uicontrol(reminder,...
		'Style', 'text',...
		'Position', [220 100 200 20],...
		'String', 'Zero Noise');
end;




xplot = linspace(-2,2,ndata)';
nplot = length (xplot);




if design == 0;
	mplot = 1 + xplot/2 + exp(-4*xplot.^2) ;				
	mdata = 1 + xdata/2 + exp(-4*xdata.^2);
elseif design == 1;
	mplot = -.5.*xplot + 1.2;
	mdata = -.5.*xdata + 1.2;
elseif design == 2;
	mplot = .7*sin(3*pi.*xplot) + 1;
	mdata = .7*sin(3*pi.*xdata) + 1;
end;

ydata = mdata + sig0.*randn(ndata,1) ;						
xc = linspace(-2,2,mframes) ;		

Interact_Movie = figure('Name', 'Interactive Kernel Smoothing Movie',...
	 'NumberTitle', 'off');			

M = moviein (mframes) ;			
for j=1:mframes ;			
	xmdata=ones(ndata,1) ;			
	xmplot = ones(nplot, 1);	
	x2data = xdata - xc(j) ;		
	x2plot = xplot - xc(j);
	if p > 0 ;		
        	for jj = 1:p ;		
        	   xmdata = [xmdata,(x2data.^jj)];
		   xmplot = [xmplot,(x2plot.^jj)];
        	   jj = jj + 1;		
       		end ;
	end ;

	if can == 0;
		if ikern == 1 ;			
			kerndata = (epan(x2data./(band)));
			kernplot = (epan(x2plot./(band)));		
		elseif ikern == 0 ;	
			kerndata =sqrt(2*pi)*pdfn(x2data./(band)) ;
			kernplot = sqrt(2*pi)*pdfn(x2plot./(band));
		elseif ikern == 2;
			kerndata =  uniform(x2data./band);
			kernplot = uniform(x2plot./band);	
		elseif ikern == 3;
			kerndata =  biwt(x2data./band);
			kernplot = biwt(x2plot./band);
		elseif ikern == 4;
			kerndata = triwt(x2data./band);
			kernplot = triwt(x2plot./band);

		end ;
	else;
		if ikern == 1 ;			
			delta = 15^.2			
			kerndata = (epan(x2data./(delta*band)));
			kernplot = (epan(x2plot./(delta*band)));		
		elseif ikern == 0 ;	
			delta = (1/(4*pi))^.1;
			kerndata =sqrt(2*pi)*pdfn(x2data./(delta*band)) ;
			kernplot = sqrt(2*pi)*pdfn(x2plot./(delta*band));
		elseif ikern == 2;
			delta = (9/2)^.2;
			kerndata =  uniform(x2data./(delta*band));
			kernplot = uniform(x2plot./(delta*band));	
		elseif ikern == 3;
			delta = 35^.2
			kerndata =  biwt(x2data./(delta*band));
			kernplot = biwt(x2plot./(delta*band));
		elseif ikern == 4;
			delta = (9450/143)^.2
			kerndata = triwt(x2data./(delta*band));
			kernplot = triwt(x2plot./(delta*band));
		end;
	end;
	
	xwdata = xmdata.*(kerndata*ones(1,p+1));	
	hat2 = inv(xwdata'*xmdata)*xwdata';		
	hatplot = xmplot*hat2 ;
	hat2= hat2(1,:) ;
	yhatplot = hatplot*ydata ;
	x_snake = xplot(abs(x2plot)<band) ;
	y_snake = yhatplot(abs(x2plot)<band) ;
	mhat(j) = hat2*ydata ;
	if color ==0			
		for k = 1:ndata;
			if kerndata (k) < .0001;
				a = 0;
				b = 0;
				else;
				a = kerndata(k);
				b = kerndata(k);
			end;		
			col = [a.^2/2, b.^2, 1];
			q =  plot (xdata(k), ydata(k), '+');
			set (q, 'Color', col);
			k = k+1;
			hold on;
		end;	
	elseif color == 1;
		for k = 1:ndata;
			if kerndata (k) < .0001;
				c = 6;
				else;
				c = ((kerndata(k).^2).*15)+6;
			end;
			q = plot (xdata(k), ydata(k), 'b+');
			set (q, 'MarkerSize', c);
			k = k+1;
			hold on
		end;
	
	elseif color == 2;
		for k = 1:ndata;	
			if kerndata (k)< .0001;
				a = 0;
				b = 0;
				c = 6;				
				else;
				a = kerndata(k);
				b = kerndata(k);
				c = ((kerndata(k).^2).*15)+6;			
			end;		
			col = [a^2/2, b^2, 1];
			q =  plot (xdata(k), ydata(k), '+');
			set (q, 'Color', col);	
			set (q, 'MarkerSize', c);	
			k =k+1;
			hold on;
		end;
	else;
	plot (xdata, ydata, 'b+');
	end;	
	hold on;
	plot(xplot,mplot,'w:',xplot,kernplot,'m-',x_snake,y_snake,'y-', xc(1:j),mhat(1:j),'g-') ;
	set(gca,'Ylim',[0,2.5]) ;
	set(gca, 'Xlim', [-2,2]);	
	h = line([xc(j),xc(j)],[0,2.5]);
	set(h, 'Color', 'r');
	hold off;	
	M ( : , j ) = getframe ;		
end ;

movie ( M , (mrepeat-1)) ;

Back_start = uicontrol(reminder,...
	'Style', 'push',...
	'Position', [30 10 160 35],...
	'String', 'Return to Start',...
	'BackGroundColor', [1 0 0],...
	'ForeGroundColor', [1 1 1],...
	'CallBack', ['close (Interact_Movie);' 'close (reminder);'  'start;']);

Save_settings = uicontrol (reminder,...
	'Style', 'push',...
	'Position', [240 10 160 35],...
	'String', 'Save Settings',...
	'BackGroundColor', [1 0 0],...
	'ForeGroundColor', [1 1 1],...
	'CallBack', ['save_set;']);

