/*  GAUSS PROGRAM WV2D1.TST
2ND GENERATION WAVELET INVESTIGATION
FOR DEVELOPMENT AND TESTING OF WV2D1.G,
DECOMPOSITION ALGORITHM FOR GENERAL WAVELET BASES */

IBASIS = 0 ;       /*   1,...,7   */
                   /*   0 TO LOOP THROUGH ALL */

ITEST = 4 ;     /*   1,...,4   */

/*
J0 = -1 ;
*/

IF ITEST == 1 ;
  Y = ONES(8,1) ;
ELSEIF ITEST == 2 ;
  Y = SEQA(1,1,16) ;
ELSEIF ITEST == 3 ;
  Y = SEQA(-8,1,16)^2 ;
ELSEIF ITEST == 4 ;
    SEED = 759384734 ;
  Y = RNDNS(32,1,SEED) ;
ENDIF ;



/* =========================== START PROC WV2D1 ======================== */
PROC WV2D1(Y,ITYPE,IPAR,J0) ;
    /*  DOES "DECOMPOSITION STEP" FOR A GENERAL WAVELET ESTIMATOR   */
    /*  Y IS VECTOR OF Y VALUES, WHERE CORRESPONDING X'S   */
    /*  ARE ASSUMED TO BE:   0,1,2,...,(2^M - 1)     (FOR SOME M)   */
    /*    I.E. NUMBERS OF ENTRIES IN Y NEEDS TO BE A POWER OF 2  */
    /*  THIS ASSUMES A "CIRCULAR DESIGN",               */
    /*    I.E. DATA WILL BE TREATED AS PERIODIC.         */
    /*    FOR A SIMPLE BOUNDARY ADJUSTMENT, AUGMENT THE DATA      */
    /*    BY REFLECTING HALF AT EACH END, AND APPLYING THIS     */
    /*    TO THE RESULTING 2N VECTOR     */
    /*  INPUTS:                                       */
    /*     ITYPE = 1 - HAAR BASIS    (IPAR IGNORED)      */
    /*           = 2 - DAUBECHIES    (IPAR = 4, 6)     */
    /*           = 3 - SYMMLETS      (IPAR = 6, 8)       */
    /*           = 4 - COIFLETS      (IPAR = 2, 3)       */
    /*     IPAR = PARAMETER WITHIN FAMILIES       */
    /*     J0 = ROW NUMBER OF LOWEST FREQUENCY "DIFS"    */
    /*              I.E. "HI PASS FILTERED VALUES"      */
    /*              FORMERLY CALLED "DISCREPANCIES"   */
    /*        = -1 GIVES SMALLEST ALLOWABLE FOR CHOSEN BASIS  */
    /*  OUTPUT IS A VECTOR OF WAVELET COEFFICIENTS,    */
    /*      THE LAST HALF ARE THE HIGHEST FREQUENCY "DIFS"       */
    /*      THE SECOND QUARTER ARE NEXT HIGHEST, ETC.     */
    /*      THE FIRST 2^J0 ARE THE NEW "AVGS",      */
    /*              I.E. "LOW PASS FILTERED VALUES"     */
    /*              FORMERLY CALLED "PREDICTED VALUES"   */
    /*  GENERAL ALGORITHM STRUCTURE IS FROM DJ   */
    /*      WITH OUTPUT MATCHED TO IAIN'S JULY 1994     */
    /*  COEFFICIENTS FROM DJ, OUT OF DAUBECHIES BOOK "10 Lectures"  */
    /*  BUT MODIFIED TO INCLUDE VARIANCE PRESERVING PROPERTY    */

  LOCAL N,JE,CLO,NFIL,J0U,CHI,COEFFS,OLDAVG,
         J,NKO,OAPRE,OAPOST,AVG,DIF ;

  N = ROWS(Y) ;
  JE = LOG(N) ./ LOG(2) ;      /*  LOG BASE 2  */
  JE = ROUND(JE) ;

  IF ABS(2^JE - N) > 10^(-10) ;
    "******************************************************" ;
    "***   CAREFUL n IS NOT A POWER OF 2, RETURNING 0   ***" ;
    "******************************************************" ;
   RETP(0) ;
  ENDIF ;


  IF ITYPE == 1 ;      /*  HAAR BASIS  */
    CLO = ONES(2,1) ./ SQRT(2) ;
  ELSEIF ITYPE == 2 ;     /*  DAUBECHIES BASES  */
    IF IPAR == 4 ;
      CLO = .482962913145|.836516303738|.224143868042|-.129409522551 ;
    ELSEIF IPAR == 6 ;
      CLO = .332670552950|.806891509311|.459877502118|-.135011020010 ;
      CLO = CLO|-.085441273882|.035226291882 ;
    ENDIF ;
  ELSEIF ITYPE == 3 ;     /*  SYMMLET BASES  */
    IF IPAR == 6 ;
      CLO = .021784700327|.004936612372|-.166863215412 ;
      CLO = CLO|-.068323121587|.694457972958|1.113892783926 ;
      CLO = CLO|.477904371333|-.102724969862|-.029783751299 ;
      CLO = CLO|.063250562660|.002499922093|-.011031867509 ;
    ELSEIF IPAR == 8 ;
      CLO = .002672793393|-.000428394300|-.021145686528 ;
      CLO = CLO|.005386388754|.069490465911|-.038493521263 ;
      CLO = CLO|-.073462508761|.515398670374|1.099106630537 ;
      CLO = CLO|.680745347190|-.086653615406|-.202648655286 ;
      CLO = CLO|.010758611751|.044823623042|-.000766690896|-.004783458512 ;
    ENDIF ;
          /*  NEED TO READJUST DUE TO STRANGE NORMALIZATION   */
    CLO = CLO / SQRT(2) ;
  ELSEIF ITYPE == 4 ;     /*  COIFLET BASES  */
    IF IPAR == 2 ;
      CLO = .011587596739|-.029320137980|-.047639590310 ;
      CLO = CLO|.273021046535|.574682393857|.294867193696 ;
      CLO = CLO|-.054085607092|-.042026480461|.016744410163 ;
      CLO = CLO|.003967883613|-.001289203356|-.000509505399 ;
    ELSEIF IPAR == 3 ;
      CLO = -.002682418671|.005503126709|.016583560479 ;
      CLO = CLO|-.046507764479|-.043220763560|.286503335274 ;
      CLO = CLO|.561285256870|.302983571773|-.050770140755 ;
      CLO = CLO|-.058196250762|.024434094321|.011229240962 ;
      CLO = CLO|-.006369601011|-.001820458916|.000790205101 ;
      CLO = CLO|.000329665174|-.000050192775|-.000024465734 ;
    ENDIF ;
          /*  NEED TO READJUST DUE TO STRANGE NORMALIZATION   */
    CLO = CLO * SQRT(2) ;
  ENDIF ;

  NFIL = ROWS(CLO) ;           /*   FILTER LENGTH  */

  IF J0 == -1 ;
    J0U = CEIL(LOG(NFIL)/LOG(2)) - 1 ;
  ELSEIF 2^(J0+1) < NFIL ;
    "**************************************************************" ;
    "***   CAREFUL, J0 TOO SMALL FOR THIS FILTER, RETURNING 0   ***" ;
    "**************************************************************" ;
   RETP(0) ;
  ELSE ;
    J0U = J0 ;
  ENDIF ;


  CHI = REV(CLO) ;
  CHI = SEQM(-1,-1,NFIL) .* CHI ;

          /*  HAD ORTHONORMALITY CHECKING LINES HERE   */

          /*  REVERSE THE ROWS TO MAKE CONV WORK LIKE A "FILTER"   */
  CLO = REV(CLO) ;
  CHI = REV(CHI) ;

  COEFFS = ZEROS(N,1) ;

  OLDAVG = Y ;
  J = JE - 1 ;
  DO WHILE J >= J0U ;
                    /*  LOOP THROUGH LEVELS, STARTING AT HI FREQ  */

           /*  PAD OUT TO GET PERIODICITY   */
    NKO = ROWS(OLDAVG) ;     /*  NUMBER OF LOCATIONS, AT OLD FREQ   */
    OAPRE = OLDAVG[NKO-NFIL+2:NKO]|OLDAVG ;
                      /*  DJ'S PRE PADDING   */
    OAPOST = OLDAVG|OLDAVG[1:NFIL-1] ;
                      /*  DJ'S POST PADDING   */

           /*  DO FILTERING   */
    AVG = CONV(OAPOST,CLO,NFIL,NKO+NFIL-1) ;
    DIF = CONV(OAPRE,CHI,NFIL,NKO+NFIL-1) ;

           /*  DECIMATE TO EVERY OTHER VALUE  */
    AVG = RESHAPE(AVG,NKO/2,2) ;
    AVG = AVG[.,1] ;
    DIF = RESHAPE(DIF,NKO/2,2) ;
    DIF = DIF[.,2] ;

    COEFFS[(2^J)+1:2^(J+1)] = DIF ;

    OLDAVG = AVG ;

    J = J - 1 ;    /*  DECREASING J IS MOVING TO LOWER FREQS   */
  ENDO ;
  COEFFS[1:2^J0U] = AVG ;

  RETP(COEFFS) ;
ENDP ;
/* ============================ END PROC WV2D1 ========================= */


/*
/*    THESE LINES WERE USED INSIDE THE PROC
TO ORTHONORMALITY FOR BOTH TYPES OF COEFFS   */
"FOR THE "$+BASTR$+" BASIS" ;
"CLO = " ;  CLO' ;
"              SQRT(2) = " SQRT(2) ;
"           SUM OF CLO = " SUMC(CLO) ;
"SUM OF SQUARES OF CLO = " SUMC(CLO^2) ;
"           SUM OF CHI = " SUMC(CHI) ;
"SUM OF SQUARES OF CHI = " SUMC(CHI^2) ; ? ;
IF NFIL == 4 ;
  "   CHECK THESE ARE 0: " ;
  CLO[1:2]'*CLO[3:4] CHI[1:2]'*CLO[3:4]
  CLO[1:2]'*CHI[3:4] CHI[1:2]'*CHI[3:4] ;
ELSEIF NFIL == 6 ;
  "   CHECK THESE ARE 0: " ;
  CLO[1:2]'*CLO[5:6] CHI[1:2]'*CLO[5:6]
  CLO[1:2]'*CHI[5:6] CHI[1:2]'*CHI[5:6] ;
  CLO[1:4]'*CLO[3:6] CHI[1:4]'*CLO[3:6]
  CLO[1:4]'*CHI[3:6] CHI[1:4]'*CHI[3:6] ;
ELSEIF NFIL == 12 ;
  "   CHECK THESE ARE 0: " ;
  CLO[1:2]'*CLO[11:12] CHI[1:2]'*CLO[11:12]
  CLO[1:2]'*CHI[11:12] CHI[1:2]'*CHI[11:12] ;
  CLO[1:4]'*CLO[9:12] CHI[1:4]'*CLO[9:12]
  CLO[1:4]'*CHI[9:12] CHI[1:4]'*CHI[9:12] ;
  CLO[1:6]'*CLO[7:12] CHI[1:6]'*CLO[7:12]
  CLO[1:6]'*CHI[7:12] CHI[1:6]'*CHI[7:12] ;
  CLO[1:8]'*CLO[5:12] CHI[1:8]'*CLO[5:12]
  CLO[1:8]'*CHI[5:12] CHI[1:8]'*CHI[5:12] ;
  CLO[1:10]'*CLO[3:12] CHI[1:10]'*CLO[3:12]
  CLO[1:10]'*CHI[3:12] CHI[1:10]'*CHI[3:12] ;
ELSEIF NFIL == 16 ;
  "   CHECK THESE ARE 0: " ;
  CLO[1:2]'*CLO[15:16] CHI[1:2]'*CLO[15:16]
  CLO[1:2]'*CHI[15:16] CHI[1:2]'*CHI[15:16] ;
  CLO[1:4]'*CLO[13:16] CHI[1:4]'*CLO[13:16]
  CLO[1:4]'*CHI[13:16] CHI[1:4]'*CHI[13:16] ;
  CLO[1:6]'*CLO[11:16] CHI[1:6]'*CLO[11:16]
  CLO[1:6]'*CHI[11:16] CHI[1:6]'*CHI[11:16] ;
  CLO[1:8]'*CLO[9:16] CHI[1:8]'*CLO[9:16]
  CLO[1:8]'*CHI[9:16] CHI[1:8]'*CHI[9:16] ;
  CLO[1:10]'*CLO[7:16] CHI[1:10]'*CLO[7:16]
  CLO[1:10]'*CHI[7:16] CHI[1:10]'*CHI[7:16] ;
  CLO[1:12]'*CLO[5:16] CHI[1:12]'*CLO[5:16]
  CLO[1:12]'*CHI[5:16] CHI[1:12]'*CHI[5:16] ;
  CLO[1:14]'*CLO[3:16] CHI[1:14]'*CLO[3:16]
  CLO[1:14]'*CHI[3:16] CHI[1:14]'*CHI[3:16] ;
ELSEIF NFIL == 18 ;
  "   CHECK THESE ARE 0: " ;
  CLO[1:2]'*CLO[17:18] CHI[1:2]'*CLO[17:18]
  CLO[1:2]'*CHI[17:18] CHI[1:2]'*CHI[17:18] ;
  CLO[1:4]'*CLO[15:18] CHI[1:4]'*CLO[15:18]
  CLO[1:4]'*CHI[15:18] CHI[1:4]'*CHI[15:18] ;
  CLO[1:6]'*CLO[13:18] CHI[1:6]'*CLO[13:18]
  CLO[1:6]'*CHI[13:18] CHI[1:6]'*CHI[13:18] ;
  CLO[1:8]'*CLO[11:18] CHI[1:8]'*CLO[11:18]
  CLO[1:8]'*CHI[11:18] CHI[1:8]'*CHI[11:18] ;
  CLO[1:10]'*CLO[9:18] CHI[1:10]'*CLO[9:18]
  CLO[1:10]'*CHI[9:18] CHI[1:10]'*CHI[9:18] ;
  CLO[1:12]'*CLO[7:18] CHI[1:12]'*CLO[7:18]
  CLO[1:12]'*CHI[7:18] CHI[1:12]'*CHI[7:18] ;
  CLO[1:14]'*CLO[5:18] CHI[1:14]'*CLO[5:18]
  CLO[1:14]'*CHI[5:18] CHI[1:14]'*CHI[5:18] ;
  CLO[1:16]'*CLO[3:18] CHI[1:16]'*CLO[3:18]
  CLO[1:16]'*CHI[3:18] CHI[1:16]'*CHI[3:18] ;
ENDIF ;
*/



FORMAT /RD 20,16 ;


OUTPUT FILE = WV2D1.OUT RESET ;
  "FROM GAUSS PROGRAM WV2D1.TST     " DATESTR(0) ; ? ;

  "FOR THE DATA: " ;
  Y ; ? ;
OUTPUT OFF ;


IF IBASIS == 0 ;
  IBS = 1 ;
  IBE = 7 ;
ELSE ;
  IBS = IBASIS ;
  IBE = IBASIS ;
ENDIF ;

IB = IBS ;
DO WHILE IB <= IBE ;

  IF IB == 1 ;
    J0 = 0 ;
    ITYPE = 1 ;
    IPAR = 0 ;
    BASTR = "Haar" ;
  ELSEIF IB == 2 ;
    J0 = 1 ;
    ITYPE = 2 ;
    IPAR = 4 ;
    BASTR = "Daub4" ;
  ELSEIF IB == 3 ;
    J0 = 2 ;
    ITYPE = 2 ;
    IPAR = 6 ;
    BASTR = "Daub6" ;
  ELSEIF IB == 4 ;
    J0 = 3 ;
    ITYPE = 3 ;
    IPAR = 6 ;
    BASTR = "Symm6" ;
  ELSEIF IB == 5 ;
    J0 = 3 ;
    ITYPE = 3 ;
    IPAR = 8 ;
    BASTR = "Symm8" ;
  ELSEIF IB == 6 ;
    J0 = 3 ;
    ITYPE = 4 ;
    IPAR = 2 ;
    BASTR = "Coif2" ;
  ELSEIF IB == 7 ;
    J0 = 4 ;
    ITYPE = 4 ;
    IPAR = 3 ;
    BASTR = "Coif3" ;
  ENDIF ;


  WVOUT = WV2D1(Y,ITYPE,IPAR,J0) ;

  OUTPUT ON ;
    FORMAT /RD 14,4 ;

    ? ; ? ;
    "DECOMPOSTION FOR THE "$+BASTR$+" BASIS, J0 = " J0 " IS:" ;
    "        NUMBER         COEFFS " ;
    SEQA(1,1,ROWS(WVOUT))~WVOUT ; ? ;

    "FOR POWER PRESERVING, CHECK FIRST TWO ARE SAME (LAST IS DIFFERENCE)" ;
    SUMC(Y^2)  SUMC(WVOUT^2) SUMC(Y^2)-SUMC(WVOUT^2) ;

  OUTPUT OFF ;


  IB = IB + 1 ;
ENDO ;

END ;
