/*  GAUSS PROGRAM WV2EG3.PRG
2ND GENERATION WAVELET INVESTIGATION
FOR SHOWING TARGET FUNCTIONS AND NOISY DATA
PLUS SOME WAVELET SMOOTHS,
THIS ALLOWS COMPARISON OF DIFFERENT J0'S
BASED ON VISUAL DISTANCE   */

LIBRARY PGRAPH ;
GRAPHSET ;

AUTOP = 2 ;       /*  0 TO VIEW ON SCREEN   */
                  /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                  /*  2 TO WRITE AS POSTSCRIPT FILES  */

N = 1024 ;          /*   SAMPLE SIZE  = NUMBER OF GRID POINTS   */
                    /*   MUST BE A POWER OF 2  */

ITARGET = 0 ;       /*   0 - LOOP THROUGH ALL    */
                    /*   1 - STEP       */
                    /*   2 - WAVE       */
                    /*   3 - BLIP       */
                    /*   4 - BLOCKS     */
                    /*   5 - BUMPS      */
                    /*   6 - HEAVSI     */
                    /*   7 - DOPPL      */
                    /*   8 - ANGLES     */
                    /*   9 - PARABS     */
                    /*   10 - SHSIN     */


ISIGMA = 0 ;        /*   0 - LOOP THROUGH ALL    */
                    /*   1 - "LOW NOISE"       */
                    /*   2 - "HIGH NOISE"       */


VIBASIS = 1|2|5|8 ;       /*  LOOP THROUGH ENTRIES OF THIS VECTOR  */
                    /*  1 - HAAR    */
                    /*  2 - DAUBECHIES 4    */
                    /*  3 - DAUBECHIES 6    */
                    /*  4 - SYMMLET 6    */
                    /*  5 - SYMMLET 8    */
                    /*  6 - COIFLET 2    */
                    /*  7 - COIFLET 3    */
                    /*  8 - FOURIER    */



NSTR = FTOS(N,"%*.*lf",1,0) ;
DELX = 1 / N ;
XGRID = SEQA(DELX/2,DELX,N) ;

       /*  SE2 PARAMETERS   */
ISCALE = 2 ;
INORM = 2 ;

                  /*  SET GRAPHICS STUFF  */
_PLTYPE = 6|3 ;
_PLCTRL = 0 ;
_PSTYPE = 4 ;
_PSYMSIZ = .25 ;
_PDATE = "From WV2EG3.PRG     " ;
_PDATE = "" ;
  LEFT = 0 ;
  RIGHT = 1 ;
  XSTEP = .2 ;
  XMSD = 2 ;
XTICS(LEFT,RIGHT,XSTEP,XMSD) ;
  BOTTOM = 0 ;
  TOP = 1 ;
  YSTEP = .2 ;
  YMSD = 2 ;
YTICS(BOTTOM,TOP,YSTEP,YMSD) ;

                  /*  SET UP LOOPING STUFF  */
IF ITARGET == 0 ;
  ITS = 1 ;
  ITE = 10 ;
ELSE ;
  ITS = ITARGET ;
  ITE = ITARGET ;
ENDIF ;

IF ISIGMA == 0 ;
  ISS = 1 ;
  ISE = 2 ;
ELSE ;
  ISS = ISIGMA ;
  ISE = ISIGMA ;
ENDIF ;

NB = ROWS(VIBASIS) ;

J0S = 2 ;
J0E = ROUND(LOG(N) ./ LOG(2)) - 1 ;      /*  LOG BASE 2  */



IT = ITS ;      /*  LOOP THROUGH TARGET FUNCTIONS  */
DO WHILE IT <= ITE ;

  IF IT == 1 ;
    TARSTR = "Step" ;
    M = 0.2 ;      /*  BASE HEIGHT  */
    M = M + (1/3 .< XGRID) .* (XGRID .< .75) * .6 ;
                   /*  RAISE BY .4 ON THIS INTERVAL  */
    _PLEGCTL = 1|4|.37|0 ;
  ELSEIF IT == 2 ;
    TARSTR = "Wave" ;
    M = .2 * COS(XGRID * 2 * PI * 2) + .5 ;
    M = M + .1 * COS(XGRID * 2 * PI * 12) ;
    _PLEGCTL = 1|4|0.61|.8 ;
  ELSEIF IT == 3 ;
    TARSTR = "Blip" ;
    M = .6 * XGRID + .2 ;
    M = M + .3 * EXP(-100 * (XGRID - .5) .* (XGRID - .5)) ;
      RM = ROWS(M) ;
    M = M[(RM/5)+1:RM]|M[1:RM/5] ;
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 4 ;
    TARSTR = "Blocks" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|-5|3|-4|5|-4.2|2.1|4.3|-3.1|2.1|-4.2 ;
    M = XGRID' - T ;
      FLAG = M .> 0 ;
      FLAG0 = M .== 0 ;
    M = FLAG - (1 - FLAG - FLAG0) ;       /*  GIVES SGN(M)  */
    M = (1 + M) / 2 ;
    M = H .* M ;
    M = SUMC(M) ;                     /*  THIS IS NOW DJ'S BLOCKS   */
    M = (.6 / 9.2) * (M + 2) + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 5 ;
    TARSTR = "Bumps" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|5|3|4|5|4.2|2.1|4.3|3.1|5.1|4.2 ;
      W = .005|.005|.006|.01|.01|.03|.01|.01|.005|.008|.005 ;
    M = (XGRID' - T) ./ W ;
    M = 1 ./ (1 + ABS(M))^4 ;
    M = H .* M ;
    M = SUMC(M) ;                     /*  THIS IS NOW DJ'S BUMPS   */
    M = (.6/5.3437952) * M + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 6 ;
    TARSTR = "HeavSi" ;
    M = 4 * SIN(4 * PI * XGRID) ;
      FLAG = XGRID .> .3 ;
      FLAG0 = XGRID .== .3 ;
    M = M - (FLAG - (1 - FLAG - FLAG0)) ;
      FLAG = XGRID .> .72 ;
      FLAG0 = XGRID .== .72 ;
    M = M + (FLAG - (1 - FLAG - FLAG0)) ;     /*  DJ'S HEAVY SINE  */
    M = (.6 / 9) * (M + 5) + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 7 ;
    TARSTR = "Doppl" ;
    M = SQRT(XGRID .* (1 - XGRID)) ;
    M = M .* SIN(2 * PI * 1.05 ./ (XGRID + .05)) ;   /*  DJ'S DOPPLER   */
    M = (.6 / 1) * (M + .5) + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 8 ;
    TARSTR = "Angles" ;
    M = (XGRID .<= .15) .* (2 * XGRID + .5) ;
    M = M + (.15 .< XGRID) .* (XGRID .<= .2) .* (-12 * (XGRID -.15) + .8)  ;
    M = M + (.2 .< XGRID) .* (XGRID .<= .5) .* (.2)  ;
    M = M + (.5 .< XGRID) .* (XGRID .<= .6) .* (6 * (XGRID -.5) + .2)  ;
    M = M + (.6 .< XGRID) .* (XGRID .<= .65) .* (-10 * (XGRID -.6) + .8)  ;
    M = M + (.65 .< XGRID) .* (XGRID .<= .85) .* (-1/2 * (XGRID -.65) + .3) ;
    M = M + (.85 .< XGRID) .* (2 * (XGRID -.85) + .2)  ;
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 9 ;
    TARSTR = "Parabs" ;
    M = .8 .* ONES(N,1) ;
    M = M + (.1 .< XGRID) .* (-30 .* (XGRID - .1)^2) ;
    M = M + (.2 .< XGRID) .* (60 .* (XGRID - .2)^2) ;
    M = M + (.3 .< XGRID) .* (-30 .* (XGRID - .3)^2) ;
    M = M + (.35 .< XGRID) .* (500 .* (XGRID - .35)^2) ;
    M = M + (.37 .< XGRID) .* (-1000 .* (XGRID - .37)^2) ;
    M = M + (.41 .< XGRID) .* (1000 .* (XGRID - .41)^2) ;
    M = M + (.43 .< XGRID) .* (-500 .* (XGRID - .43)^2) ;
    M = M + (.5 .< XGRID) .* (7.5 .* (XGRID - .5)^2) ;
    M = M + (.7 .< XGRID) .* (-15 .* (XGRID - .7)^2) ;
    M = M + (.9 .< XGRID) .* (7.5 .* (XGRID - .9)^2) ;
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 10 ;
    TARSTR = "TShSin" ;
    TXGRID = (1 - COS(PI .* XGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 4 + XGRID / 2 ;
    M = .3 * SIN(6 .* PI .* TXGRID) + .5 ;
    _PLEGCTL = 1|4|.6|0 ;
  ENDIF ;


  IS = ISS ;      /*  LOOP THROUGH SIGMAS  */
  DO WHILE IS <= ISE ;

    IF IS == 1 ;
      SIGSTR = "Low Noise" ;
      SIG = .02 ;
    ELSEIF IS == 2 ;
      SIGSTR = "High Noise" ;
      SIG = .1 ;
    ENDIF ;

      SEED = 932485732 ;
    Y = M + SIG * RNDNS(N,1,SEED) ;


           /*  DENOISING THRESHOLD VALUE  */
    LAMSIG = SQRT(2 * LN(N)) * SIG ;


    BEGWIND ;
    WINDOW(2,2,0) ;

    IB = 1 ;      /*  LOOP THROUGH BASES  */
    DO WHILE IB <= NB ;
      IBAS = VIBASIS[IB] ;

      IF IBAS <= 7 ;
        IF IBAS == 1 ;
          ITYPE = 1 ;
          IPAR = 0 ;
          BASTR = "Haar" ;
        ELSEIF IBAS == 2 ;
          ITYPE = 2 ;
          IPAR = 4 ;
          BASTR = "Daub4" ;
        ELSEIF IBAS == 3 ;
          ITYPE = 2 ;
          IPAR = 6 ;
          BASTR = "Daub6" ;
        ELSEIF IBAS == 4 ;
          ITYPE = 3 ;
          IPAR = 6 ;
          BASTR = "Symm6" ;
        ELSEIF IBAS == 5 ;
          ITYPE = 3 ;
          IPAR = 8 ;
          BASTR = "Symm8" ;
        ELSEIF IBAS == 6 ;
          ITYPE = 4 ;
          IPAR = 2 ;
          BASTR = "Coif2" ;
        ELSEIF IBAS == 7 ;
          ITYPE = 4 ;
          IPAR = 3 ;
          BASTR = "Coif3" ;
        ENDIF ;

                /*  GET WAVELET COEFFS OF DATA  */
        COEFFS = WV2D1(Y,ITYPE,IPAR,-1) ;
                    /* J0  = -1 GIVES SMALLEST ALLOWABLE FOR CHOSEN BASIS  */

      ELSEIF IBAS == 8 ;
        BASTR = "Fourier" ;

        COEFFS = WVFFTD(Y) ;

      ENDIF ;



      J0 = J0S ;
      DO WHILE J0 <= J0E ;
        "GET EST FOR "$+SIGSTR$+"  "$+TARSTR$+"  "$+BASTR$+"  J0 = " J0 ;

              /*  DO HARD THRESHOLDING  */
        TCOEFFS = COEFFS[(2^J0)+1:N] ;      /* HIGHER FREQ THAN J0  */
        TCOEFFS = TCOEFFS .* (TCOEFFS .> LAMSIG) ;
        TCOEFFS = COEFFS[1:2^J0]|TCOEFFS ;   /*  COMBINE ALL COEFFS  */

        IF IBAS <= 7 ;
          MHAT = WV2R1(TCOEFFS,ITYPE,IPAR,-1) ;
                    /* J0  = -1 GIVES SMALLEST ALLOWABLE FOR CHOSEN BASIS  */
        ELSEIF IBAS == 8 ;
          MHAT = WVFFTR(TCOEFFS) ;
        ENDIF ;

        SE2 = VDSYM1S(XGRID,MHAT,M,ISCALE,INORM) ;

        IF J0 == J0S ;
          SE2MIN = SE2 ;
          MHATMIN = MHAT ;
          J0MIN = J0 ;
        ELSE ;
          IF SE2 <= SE2MIN ;
            SE2MIN = SE2 ;
            MHATMIN = MHAT ;
            J0MIN = J0 ;
          ENDIF ;
        ENDIF ;

        J0 = J0 + 1 ;
      ENDO ;


      SETWIND(IB) ;

      _PLEGCTL = 0 ;
          TITSTR = TARSTR$+" Regression" ;
          TITSTR = TITSTR$+" with "$+SIGSTR ;
          TITSTR = TITSTR$+" (sig = "$+FTOS(SIG,"%*.*lf",3,2) ;
          TITSTR = TITSTR$+") Gaussian Errors" ;
          TITSTR = TITSTR$+"\Ln =" ;
          TITSTR = TITSTR$+FTOS(N,"%*.*lf",1,0) ;
          TITSTR = TITSTR$+",    Denoising Hard Thresh "$+BASTR ;
          TITSTR = TITSTR$+" Est, SE2 Min j]0[ = " ;
          TITSTR = TITSTR$+FTOS(J0MIN,"%*.*lf",1,0) ;
        TITLE(TITSTR) ;
      XY(XGRID,M~MHATMIN) ; ? ;


      IB = IB + 1 ;
    ENDO ;


    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\WVEG" ;
        PRSTR = PRSTR$+FTOS(IT,"%*.*lf",1,0) ;
        PRSTR = PRSTR$+FTOS(IS,"%*.*lf",1,0) ;
        PRSTR = PRSTR$+".PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\WVEG" ;
        PRSTR = PRSTR$+FTOS(IT,"%*.*lf",1,0) ;
        PRSTR = PRSTR$+FTOS(IS,"%*.*lf",1,0) ;
        PRSTR = PRSTR$+".PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;

    ENDWIND ;


    IS = IS + 1 ;
  ENDO ;

  IT = IT + 1 ;
ENDO ;

END ;
