"GAUSS PROGRAM WV2ER1C.PRG" ;
/*  EXACT RISK MSE FOR 2ND GENERATION WAVELET ESTIMATORS
BASED ON THRESHOLDING AND LOW FREQUENCY IDEAS
THIS VERSION SHOWS SEVERAL THRESHOLD VALUES ON THE SAME PLOT
AND STUDIES DEPENDENCE ON J0  */

LIBRARY PGRAPH ;
GRAPHSET ;

AUTOP = 0 ;         /*  0 TO VIEW ON SCREEN   */
                    /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                    /*  2 TO WRITE AS POSTSCRIPT FILES  */

IBASIS = 5 ;        /*  0 - LOOP THROUGH THOSE IN IBASIS  */
VIBASIS = 1|5|8 ;
                    /*  1 - HAAR    */
                    /*  2 - DAUBECHIES 4    */
                    /*  3 - DAUBECHIES 6    */
                    /*  4 - SYMMLET 6    */
                    /*  5 - SYMMLET 8    */
                    /*  6 - COIFLET 2    */
                    /*  7 - COIFLET 3    */
                    /*  8 - FOURIER    */

ITHTYP = 2 ;       /*  -1 - LOOP THROUGH ALL    */
                    /*   0 - PROJECTION (LOW FREQUENCY RECONSTRUCT)   */
                    /*   1 - HARD THRESHOLDING   */
                    /*   2 - SOFT THRESHOLDING   */

/*
ITHVAL = 1 ;        /*   0 - LOOP THROUGH ALL   */
                    /*   1 - SQRT(2 * LN(N))     */
                    /*   2 - DJ MINIMAX MSE OPTIMAL   */
*/

ITARGET = 0 ;       /*   0 - LOOP THROUGH ALL    */
                    /*   1 - STEP       */
                    /*   2 - WAVE       */
                    /*   3 - BLIP       */
                    /*   4 - BLOCKS     */
                    /*   5 - BUMPS      */
                    /*   6 - HEAVSI     */
                    /*   7 - DOPPL      */
                    /*   8 - ANGLES     */
                    /*   9 - PARABS     */
                    /*   10 - SHSIN     */

ISIGMA = 0 ;        /*   0 - LOOP THROUGH ALL   */
                    /*   1 - LOW NOISE   (SIG = .02)   */
                    /*   2 - HIGH NOISE  (SIG = .1)    */


N = 256 ;           /*   SAMPLE SIZE = NUMBER OF GRID POINTS   */
                    /*   MUST BE A POWER OF 2  */


J0E = ROUND(LOG(N) / LOG(2)) ;
J0GRID = SEQA(1,1,J0E) ;
NSTR = FTOS(N,"%*.*lf",1,0) ;
DELX = 1 / N ;
XGRID = SEQA(DELX/2,DELX,N) ;




                  /*  SET UP LOOPING STUFF  */
IF IBASIS /= 0 ;
  VIBASIS = IBASIS ;
ENDIF ;

IF ITHTYP == -1 ;
  ITHTS = 0 ;
  ITHTE = 2 ;
ELSE ;
  ITHTS = ITHTYP ;
  ITHTE = ITHTYP ;
ENDIF ;

/*
IF ITHVAL == 0 ;
  ITHVS = 1 ;
  ITHVE = 2 ;
ELSE ;
  ITHVS = ITHVAL ;
  ITHVE = ITHVAL ;
ENDIF ;
*/

ITHVS = 1 ;
ITHVE = 2 ;


IF ITARGET == 0 ;
  ITS = 1 ;
  ITE = 10 ;
ELSE ;
  ITS = ITARGET ;
  ITE = ITARGET ;
ENDIF ;

IF ISIGMA == 0 ;
  ISS = 1 ;
  ISE = 2 ;
ELSE ;
  ISS = ISIGMA ;
  ISE = ISIGMA ;
ENDIF ;


NB = ROWS(VIBASIS) ;


ITHT = ITHTS ;       /*  LOOP THROUGH THRESHOLD TYPES  */
DO WHILE ITHT <= ITHTE ;

  IF ITHT == 0 ;
    THTSTR = "Proj" ;
  ELSEIF ITHT == 1 ;
    THTSTR = "Hard" ;
  ELSEIF ITHT == 2 ;
    THTSTR = "Soft" ;
  ENDIF ;


  IB = 1 ;      /*  LOOP THROUGH BASES  */
  DO WHILE IB <= NB ;
    IBAS = VIBASIS[IB] ;

    IF IBAS == 1 ;
      ITYPE = 1 ;
      IPAR = 0 ;
      BASTR = "Haar" ;
    ELSEIF IBAS == 2 ;
      ITYPE = 2 ;
      IPAR = 4 ;
      BASTR = "Daub4" ;
    ELSEIF IBAS == 3 ;
      ITYPE = 2 ;
      IPAR = 6 ;
      BASTR = "Daub6" ;
    ELSEIF IBAS == 4 ;
      ITYPE = 3 ;
      IPAR = 6 ;
      BASTR = "Symm6" ;
    ELSEIF IBAS == 5 ;
      ITYPE = 3 ;
      IPAR = 8 ;
      BASTR = "Symm8" ;
    ELSEIF IBAS == 6 ;
      ITYPE = 4 ;
      IPAR = 2 ;
      BASTR = "Coif2" ;
    ELSEIF IBAS == 7 ;
      ITYPE = 4 ;
      IPAR = 3 ;
      BASTR = "Coif3" ;
    ELSEIF IBAS == 8 ;
      BASTR = "Fourier" ;
    ENDIF ;


    IS = ISS ;
    DO WHILE IS <= ISE ;

      IF IS == 1 ;
        SIG = .02 ;
        SIGSTR = "Low" ;
        BOTTOM = -2.5 ;
        TOP = .5 ;
        YSTEP = 1 ;
        YMSD = 5 ;
      ELSEIF IS == 2 ;
        SIG = .1 ;
        SIGSTR = "High" ;
        BOTTOM = -1 ;
        TOP = 2 ;
        YSTEP = 1 ;
        YMSD = 5 ;
      ENDIF ;
      SIG2 = SIG^2 ;


      IT = ITS ;      /*  LOOP THROUGH TARGET FUNCTIONS  */
      DO WHILE IT <= ITE ;

        IF IT == 1 ;
          TARSTR = "Step" ;
          M = 0.2 ;      /*  BASE HEIGHT  */
          M = M + (1/3 .< XGRID) .* (XGRID .< .75) * .6 ;
                         /*  RAISE BY .4 ON THIS INTERVAL  */
        ELSEIF IT == 2 ;
          TARSTR = "Wave" ;
          M = .2 * COS(XGRID * 2 * PI * 2) + .5 ;
          M = M + .1 * COS(XGRID * 2 * PI * 12) ;
        ELSEIF IT == 3 ;
          TARSTR = "Blip" ;
          M = .6 * XGRID + .2 ;
          M = M + .3 * EXP(-100 * (XGRID - .5) .* (XGRID - .5)) ;
            RM = ROWS(M) ;
          M = M[(RM/5)+1:RM]|M[1:RM/5] ;
                         /*  ROTATE SO DISCONT NOT AT EDGE  */
        ELSEIF IT == 4 ;
          TARSTR = "Blocks" ;
            T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
            H = 4|-5|3|-4|5|-4.2|2.1|4.3|-3.1|2.1|-4.2 ;
          M = XGRID' - T ;
            FLAG = M .> 0 ;
            FLAG0 = M .== 0 ;
          M = FLAG - (1 - FLAG - FLAG0) ;       /*  GIVES SGN(M)  */
          M = (1 + M) / 2 ;
          M = H .* M ;
          M = SUMC(M) ;               /*  THIS IS NOW DJ'S BLOCKS   */
          M = (.6 / 9.2) * (M + 2) + .2 ;  /*  RESCALED TO [.2,.8]  */
        ELSEIF IT == 5 ;
          TARSTR = "Bumps" ;
            T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
            H = 4|5|3|4|5|4.2|2.1|4.3|3.1|5.1|4.2 ;
            W = .005|.005|.006|.01|.01|.03|.01|.01|.005|.008|.005 ;
          M = (XGRID' - T) ./ W ;
          M = 1 ./ (1 + ABS(M))^4 ;
          M = H .* M ;
          M = SUMC(M) ;                  /*  THIS IS NOW DJ'S BUMPS   */
          M = (.6/5.3437952) * M + .2 ;      /*  RESCALED TO [.2,.8]  */
        ELSEIF IT == 6 ;
          TARSTR = "HeavSi" ;
          M = 4 * SIN(4 * PI * XGRID) ;
            FLAG = XGRID .> .3 ;
            FLAG0 = XGRID .== .3 ;
          M = M - (FLAG - (1 - FLAG - FLAG0)) ;
            FLAG = XGRID .> .72 ;
            FLAG0 = XGRID .== .72 ;
          M = M + (FLAG - (1 - FLAG - FLAG0)) ;  /*  DJ'S HEAVY SINE  */
          M = (.6 / 9) * (M + 5) + .2 ;      /*  RESCALED TO [.2,.8]  */
        ELSEIF IT == 7 ;
          TARSTR = "Doppl" ;
          M = SQRT(XGRID .* (1 - XGRID)) ;
          M = M .* SIN(2 * PI * 1.05 ./ (XGRID + .05)) ; /* DJ'S DOPPLER */
          M = (.6 / 1) * (M + .5) + .2 ;      /*  RESCALED TO [.2,.8]  */
        ELSEIF IT == 8 ;
          TARSTR = "Angles" ;
          M = (XGRID .<= .15) .* (2 * XGRID + .5) ;
      M = M + (.15 .< XGRID) .* (XGRID .<= .2) .* (-12 * (XGRID-.15) + .8) ;
      M = M + (.2 .< XGRID) .* (XGRID .<= .5) .* (.2)  ;
      M = M + (.5 .< XGRID) .* (XGRID .<= .6) .* (6 * (XGRID-.5) + .2) ;
      M = M + (.6 .< XGRID) .* (XGRID .<= .65) .* (-10 * (XGRID-.6) + .8) ;
      M = M + (.65 .< XGRID) .* (XGRID .<= .85) .* (-1/2 * (XGRID-.65)+.3) ;
      M = M + (.85 .< XGRID) .* (2 * (XGRID -.85) + .2)  ;
        ELSEIF IT == 9 ;
          TARSTR = "Parabs" ;
          M = .8 .* ONES(N,1) ;
          M = M + (.1 .< XGRID) .* (-30 .* (XGRID - .1)^2) ;
          M = M + (.2 .< XGRID) .* (60 .* (XGRID - .2)^2) ;
          M = M + (.3 .< XGRID) .* (-30 .* (XGRID - .3)^2) ;
          M = M + (.35 .< XGRID) .* (500 .* (XGRID - .35)^2) ;
          M = M + (.37 .< XGRID) .* (-1000 .* (XGRID - .37)^2) ;
          M = M + (.41 .< XGRID) .* (1000 .* (XGRID - .41)^2) ;
          M = M + (.43 .< XGRID) .* (-500 .* (XGRID - .43)^2) ;
          M = M + (.5 .< XGRID) .* (7.5 .* (XGRID - .5)^2) ;
          M = M + (.7 .< XGRID) .* (-15 .* (XGRID - .7)^2) ;
          M = M + (.9 .< XGRID) .* (7.5 .* (XGRID - .9)^2) ;
        ELSEIF IT == 10 ;
          TARSTR = "TShSin" ;
          TXGRID = (1 - COS(PI .* XGRID)) / 2 ;
          TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
          TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
          TXGRID = (1 - COS(PI .* TXGRID)) / 4 + XGRID / 2 ;
          M = .3 * SIN(6 .* PI .* TXGRID) + .5 ;
        ENDIF ;


        MMSE = ZEROS(J0E,ITHVE-ITHVS+2) ;
        MREM = ZEROS(N,ITHVE-ITHVS+1) ;
                      /*  MATRIX FOR SHOWING REMAINING POWER  */


        IF IBAS <= 7 ;
                  /*  GET WAVELET COEFFS OF TARGET  */
          COEFFS = WV2D1(M,ITYPE,IPAR,-1) ;
                        /*  RECALL -1 GIVES LOWEST LEVEL POSSIBLE  */
        ELSEIF IBAS == 8 ;
          COEFFS = WVFFTD(M) ;
        ENDIF ;



        ITHV = ITHVS ;       /*  LOOP THROUGH THRESHOLD VALUES  */
        DO WHILE ITHV <= ITHVE ;

          IF ITHV == 1 ;
            THVSTR = "Sqrt(2 ln(N))" ;
            LAMBDA = SQRT(2 * LN(N)) ;
          ELSEIF ITHV == 2 ;
            THVSTR = "DJ Minmax Opt" ;
            IF N == 64 ;
              LAMBDA = 1.47391 ;
            ELSEIF N == 128 ;
              LAMBDA = 1.66865 ;
            ELSEIF N == 256 ;
              LAMBDA = 1.85982 ;
            ELSEIF N == 512 ;
              LAMBDA = 2.04748 ;
            ELSEIF N == 1024 ;
              LAMBDA = 2.23203 ;
            ELSEIF N == 2048 ;
              LAMBDA = 2.41405 ;
            ELSEIF N == 4096 ;
              LAMBDA = 2.59427 ;
            ELSEIF N == 8192 ;
              LAMBDA = 2.77343 ;
            ELSEIF N == 16384 ;
              LAMBDA = 2.95218 ;
            ELSEIF N == 32768 ;
              LAMBDA = 3.13093 ;
            ELSEIF N == 65536 ;
              LAMBDA = 3.30975 ;
            ENDIF ;
          ENDIF ;



          "CALCULATING RISK FOR "$+THVSTR ;
          MSE = WV2MSE1(COEFFS,LAMBDA,SIG2,J0GRID,ITHT) ;

          MMSE[.,ITHV] = MSE ;

/*
          REM = SORTC(COEFFS^2,1) ;
          REM = CUMSUMC(REM) ;
          REM = REV(REM) ;    /*  PUT IN DECREASING ORDER  */
*/

          J = 3 ;
          REMRW = COEFFS[1:2^J]^2 ;
          REMRW = SORTC(REMRW,1) ;
          REMRW = REV(REMRW) ;
          DO WHILE J <= J0E - 1 ;
            RRW = COEFFS[(2^J)+1:2^(J+1)]^2 ;
            RRW = SORTC(RRW,1) ;
            RRW = CUMSUMC(RRW) ;
            RRW = REV(RRW) ;
            REMRW = REMRW|RRW ;
            J = J + 1 ;
          ENDO ;


          MREM[.,ITHV] = REMRW ;


          IF ITHV == 1 ;
            _PLEGSTR = THVSTR ;
          ELSE ;
            _PLEGSTR = _PLEGSTR$+"\000"$+THVSTR ;
          ENDIF ;

          ITHV = ITHV + 1 ;
        ENDO ;


        MMSE[.,ITHVE-ITHVS+2] = MMSE[J0E,1] * ONES(J0E,1) ;
        _PLEGSTR = _PLEGSTR$+"\000Raw Y" ;



                 /*  TRUNCATE AND PUT ON LOG SCALE   */
        FLAG = MMSE .> 10^(-12) ;    /*  ONES WHERE NOT TOO SMALL  */
        MMSE = FLAG .* MMSE + (1 - FLAG) .* 10^(-12) ;
                  /*  REPLACES SMALLER VALUES BY 10^(-12)  */
        MMSE = LOG(MMSE) ;


        FLAG = MREM .> 10^(-12) ;    /*  ONES WHERE NOT TOO SMALL  */
        MREM = FLAG .* MREM + (1 - FLAG) .* 10^(-12) ;
                  /*  REPLACES SMALLER VALUES BY 10^(-12)  */
        MREM = LOG(MREM) ;



                          /*  SET GRAPHICS STUFF  */
          _PLTYPE = 6|3|4 ;
          LEFT = 1 ;
          RIGHT = J0E ;
          XSTEP = 1 ;
          XMSD = 5 ;


                 "START GRAPHICS" ;
        BEGWIND ;
        MAKEWIND(9.5,7,0,0,0) ;
        MAKEWIND(3,2.5,.9,3.1,1) ;
        SETWIND(1) ;


          _PDATE = "From WV2ER1C.PRG     " ;
            TITSTR = "Exact MSE as a Function of j]0[" ;
            TITSTR = TITSTR$+"\LBased on n = "$+NSTR ;
            TITSTR = TITSTR$+" Data with Gaussian Errors" ;
            _PMSGSTR = "Thresh Type = "$+THTSTR ;
            _PMSGSTR = _PMSGSTR$+"\000Basis = "$+BASTR ;
            _PMSGSTR = _PMSGSTR$+"\000Noise Level = "$+SIGSTR ;
            _PMSGSTR = _PMSGSTR$+"\000Target = "$+TARSTR ;
              MX1 = LEFT + .05 * (RIGHT - LEFT) ;
              MX2 = LEFT + .5 * (RIGHT - LEFT) ;
              MY1 = BOTTOM + .92 * (TOP - BOTTOM) ;
              MY2 = BOTTOM + .84 * (TOP - BOTTOM) ;
              MY3 = BOTTOM + .76 * (TOP - BOTTOM) ;
              MY4 = BOTTOM + .68 * (TOP - BOTTOM) ;
            _PMSGCTL = MX2~MY1~.15~0~1~9~0 ;
            _PMSGCTL = _PMSGCTL|(MX2~MY2~.15~0~1~9~0) ;
            _PMSGCTL = _PMSGCTL|(MX2~MY3~.15~0~1~9~0) ;
            _PMSGCTL = _PMSGCTL|(MX2~MY4~.15~0~1~9~0) ;
            _PLEGCTL = 1 ;
            XLABEL("j]0[") ;
            YLABEL("log]10[(MSE)") ;
            XTICS(LEFT,RIGHT,XSTEP,XMSD) ;
            YTICS(BOTTOM,TOP,YSTEP,YMSD) ;
          TITLE(TITSTR) ;
        XY(J0GRID,MMSE) ;


        NEXTWIND ;
          _PDATE = 0 ;
          _PMSGCTL = 0 ;
          _PLEGCTL = 0 ;
          _PLINE = 0 ;
          XTICS(0,1,.25,4) ;
          YTICS(-5,2,1,1) ;
          XLABEL("Proportion of Coeffs") ;
          YLABEL("log]10[(Power)") ;
            TITSTR = "Row-wise `Power Remaining' in Smaller Coeffs" ;
          TITLE(TITSTR) ;
        XY(SEQA(1/(2*N),1/N,N),MREM[.,1]) ;


        IF AUTOP == 1 ;
            PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\R1C" ;
            PRSTR = PRSTR$+FTOS(IB,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+FTOS(ITHT,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+FTOS(IS,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+FTOS(IT,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+".PLT" ;
          GRAPHPRT(PRSTR) ;
        ELSEIF AUTOP == 2 ;
            PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\R1C" ;
            PRSTR = PRSTR$+FTOS(IB,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+FTOS(ITHT,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+FTOS(IS,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+FTOS(IT,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+".PS" ;
          GRAPHPRT(PRSTR) ;
        ENDIF ;

        ENDWIND ;

        IT = IT + 1 ;
      ENDO ;

      IS = IS + 1 ;
    ENDO ;

    IB = IB + 1 ;
  ENDO ;

  ITHT = ITHT + 1 ;
ENDO ;


END ;
