/*  GAUSS PROGRAM WV2ER3B.PRG
EXACT RISK MSE FOR 2ND GENERATION WAVELET ESTIMATORS
BASED ON THRESHOLDING AND LOW FREQUENCY IDEAS
THIS VERSION SHOWS SEVERAL BASES ON THE SAME PLOT
AND STUDIES DEPENDENCE ON N, WITH J0 AT MIN  */

LIBRARY PGRAPH ;
GRAPHSET ;

AUTOP = 2 ;         /*  0 TO VIEW ON SCREEN   */
                    /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                    /*  2 TO WRITE AS POSTSCRIPT FILES  */

IBASIS = 5 ;        /*  0 - LOOP THROUGH THOSE IN IBASIS  */
VIBASIS = 1|5|8 ;
                    /*  1 - HAAR    */
                    /*  2 - DAUBECHIES 4    */
                    /*  3 - DAUBECHIES 6    */
                    /*  4 - SYMMLET 6    */
                    /*  5 - SYMMLET 8    */
                    /*  6 - COIFLET 2    */
                    /*  7 - COIFLET 3    */
                    /*  8 - FOURIER    */

/*
ITHTYP = 1 ;        /*  -1 - LOOP THROUGH ALL    */
                    /*   0 - PROJECTION (LOW FREQUENCY RECONSTRUCT)   */
                    /*   1 - HARD THRESHOLDING   */
                    /*   2 - SOFT THRESHOLDING   */
*/

ITHVAL = 1 ;        /*   0 - LOOP THROUGH ALL   */
                    /*   1 - SQRT(2 * LN(N)     */
                    /*   2 - DJ MINIMAX MSE OPTIMAL   */

ITARGET = 0 ;       /*   0 - LOOP THROUGH ALL    */
                    /*   1 - STEP       */
                    /*   2 - WAVE       */
                    /*   3 - BLIP       */
                    /*   4 - BLOCKS     */
                    /*   5 - BUMPS      */
                    /*   6 - HEAVSI     */
                    /*   7 - DOPPL      */
                    /*   8 - ANGLES     */
                    /*   9 - PARABS     */
                    /*   10 - SHSIN     */

ISIGMA = 0 ;        /*   0 - LOOP THROUGH ALL   */
                    /*   1 - LOW NOISE   (SIG = .02)   */
                    /*   2 - HIGH NOISE  (SIG = .1)    */


ILINE = 1 ;         /*  1 - FOR MULTIPLE LINE TYPES (GOOD FOR PRINTING)  */
                    /*  2 - FOR ALL SOLID (GOOD FOR LOOKING AT MONITOR)  */


VN = SEQM(64,2,9) ;
                    /*   VECTOR OF SAMPLE SIZES = NUMBERS OF GRID POINTS   */
                    /*   EACH MUST BE A POWER OF 2  */
                    /*       5 OF THESE GOES UP TO 1024   */
                    /*       9 OF THESE GOES UP TO 16348   */


NVN = ROWS(VN) ;
NMAX = VN[NVN] ;
DELX = 1 / (2 * NMAX) ;


                  /*  SET GRAPHICS STUFF  */
IF ILINE == 1 ;
  _PLTYPE = 6|1|3|5|4 ;
ELSEIF ILINE == 2 ;
  _PLTYPE = 6 ;
ENDIF ;
  LEFT = 6 ;
  RIGHT = 6 + NVN - 1 ;
  XSTEP = 1 ;
  XMSD = 5 ;



                  /*  SET UP LOOPING STUFF  */
IF IBASIS /= 0 ;
  VIBASIS = IBASIS ;
ENDIF ;

/*
IF ITHTYP == -1 ;
  ITHTS = 0 ;
  ITHTE = 2 ;
ELSE ;
  ITHTS = ITHTYP ;
  ITHTE = ITHTYP ;
ENDIF ;
*/

ITHTS = 0 ;
ITHTE = 2 ;


IF ITHVAL == 0 ;
  ITHVS = 1 ;
  ITHVE = 2 ;
ELSE ;
  ITHVS = ITHVAL ;
  ITHVE = ITHVAL ;
ENDIF ;

IF ISIGMA == 0 ;
  ISS = 1 ;
  ISE = 2 ;
ELSE ;
  ISS = ISIGMA ;
  ISE = ISIGMA ;
ENDIF ;

IF ITARGET == 0 ;
  ITS = 1 ;
  ITE = 10 ;
ELSE ;
  ITS = ITARGET ;
  ITE = ITARGET ;
ENDIF ;

NB = ROWS(VIBASIS) ;



IB = 1 ;      /*  LOOP THROUGH BASES  */
DO WHILE IB <= NB ;
  IBAS = VIBASIS[IB] ;

  IF IBAS == 1 ;
    ITYPE = 1 ;
    IPAR = 0 ;
    BASTR = "Haar" ;
  ELSEIF IBAS == 2 ;
    ITYPE = 2 ;
    IPAR = 4 ;
    BASTR = "Daub4" ;
  ELSEIF IBAS == 3 ;
    ITYPE = 2 ;
    IPAR = 6 ;
    BASTR = "Daub6" ;
  ELSEIF IBAS == 4 ;
    ITYPE = 3 ;
    IPAR = 6 ;
    BASTR = "Symm6" ;
  ELSEIF IBAS == 5 ;
    ITYPE = 3 ;
    IPAR = 8 ;
    BASTR = "Symm8" ;
  ELSEIF IBAS == 6 ;
    ITYPE = 4 ;
    IPAR = 2 ;
    BASTR = "Coif2" ;
  ELSEIF IBAS == 7 ;
    ITYPE = 4 ;
    IPAR = 3 ;
    BASTR = "Coif3" ;
  ELSEIF IBAS == 8 ;
    BASTR = "Fourier" ;
  ENDIF ;


  ITHV = ITHVS ;       /*  LOOP THROUGH THRESHOLD VALUES  */
  DO WHILE ITHV <= ITHVE ;


    IS = ISS ;      /*  LOOP THROUGH SIGMAS   */
    DO WHILE IS <= ISE ;

      IF IS == 1 ;
        SIGSTR = "Low Noise (sig = .02)" ;
        SIG = .02 ;
        IF NVN == 5 ;
          BOTTOM = -16 ;
        ELSE ;
          BOTTOM = -20 ;
        ENDIF ;
        TOP = -10 ;
        YSTEP = 1 ;
        YMSD = 5 ;
      ELSEIF IS == 2 ;
        SIGSTR = "High Noise (sig = .1)" ;
        SIG = .1 ;
        IF NVN == 5 ;
          BOTTOM = -12 ;
        ELSE ;
          BOTTOM = -16 ;
        ENDIF ;
        TOP = -6 ;
        YSTEP = 1 ;
        YMSD = 5 ;
      ENDIF ;
      SIG2 = SIG^2 ;



      IT = ITS ;      /*  LOOP THROUGH TARGET FUNCTIONS  */
      DO WHILE IT <= ITE ;

      BXG = SEQA(DELX,DELX,2*NMAX-1) ;
             /*   GET OTHER GRIDS BY APPROPRIATELY DECIMATING THIS ONE  */


      IF IT == 1 ;
        TARSTR = "Step" ;
        BM = 0.2 ;      /*  BASE HEIGHT  */
        BM = BM + (1/3 .< BXG) .* (BXG .< .75) * .6 ;
                       /*  RAISE BY .4 ON THIS INTERVAL  */
      ELSEIF IT == 2 ;
        TARSTR = "Wave" ;
        BM = .2 * COS(BXG * 2 * PI * 2) + .5 ;
        BM = BM + .1 * COS(BXG * 2 * PI * 12) ;
      ELSEIF IT == 3 ;
        TARSTR = "Blip" ;
        BM = .6 * BXG + .2 ;
        BM = BM + .3 * EXP(-100 * (BXG - .5) .* (BXG - .5)) ;
          RM = ROWS(BM) ;
        BM = BM[(RM/5)+1:RM]|BM[1:RM/5] ;
                       /*  ROTATE SO DISCONT NOT AT EDGE  */
      ELSEIF IT == 4 ;
        TARSTR = "Blocks" ;
          VT = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
          VH = 4|-5|3|-4|5|-4.2|2.1|4.3|-3.1|2.1|-4.2 ;
        BM = ZEROS(ROWS(BXG),1) ;
        I = 1 ;
        DO WHILE I <= ROWS(VT) ;
          T = VT[I] ;
          H = VH[I] ;
          ARG = BXG' - T ;
            FLAG = ARG .> 0 ;
            FLAG0 = ARG .== 0 ;
          ARG = FLAG - (1 - FLAG - FLAG0) ;       /*  GIVES SGN(ARG)  */
          ARG = (1 + ARG) / 2 ;
          ARG = H .* ARG ;
          BM = BM + SUMC(ARG) ;
          I = I + 1 ;
        ENDO ;              /*  BM IS NOW DJ'S BLOCKS    */
        BM = (.6 / 9.2) * (BM + 2) + .2 ;  /*  RESCALED TO [.2,.8]  */
      ELSEIF IT == 5 ;
        TARSTR = "Bumps" ;
          VT = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
          VH = 4|5|3|4|5|4.2|2.1|4.3|3.1|5.1|4.2 ;
          VW = .005|.005|.006|.01|.01|.03|.01|.01|.005|.008|.005 ;
        BM = ZEROS(ROWS(BXG),1) ;
        I = 1 ;
        DO WHILE I <= ROWS(VT) ;
          T = VT[I] ;
          H = VH[I] ;
          W = VW[I] ;
          ARG = (BXG' - T) ./ W ;
          ARG = 1 ./ (1 + ABS(ARG))^4 ;
          ARG = H .* ARG ;
          BM = BM + SUMC(ARG) ;
          I = I + 1 ;
        ENDO ;              /*  BM IS NOW DJ'S BUMPS    */
        BM = (.6/5.3437952) * BM + .2 ;      /*  RESCALED TO [.2,.8]  */
      ELSEIF IT == 6 ;
        TARSTR = "HeavSi" ;
        BM = 4 * SIN(4 * PI * BXG) ;
          FLAG = BXG .> .3 ;
          FLAG0 = BXG .== .3 ;
        BM = BM - (FLAG - (1 - FLAG - FLAG0)) ;
          FLAG = BXG .> .72 ;
          FLAG0 = BXG .== .72 ;
        BM = BM + (FLAG - (1 - FLAG - FLAG0)) ;  /*  DJ'S HEAVY SINE  */
        BM = (.6 / 9) * (BM + 5) + .2 ;      /*  RESCALED TO [.2,.8]  */
      ELSEIF IT == 7 ;
        TARSTR = "Doppl" ;
        BM = SQRT(BXG .* (1 - BXG)) ;
        BM = BM .* SIN(2 * PI * 1.05 ./ (BXG + .05)) ; /* DJ'S DOPPLER */
        BM = (.6 / 1) * (BM + .5) + .2 ;      /*  RESCALED TO [.2,.8]  */
      ELSEIF IT == 8 ;
        TARSTR = "Angles" ;
        BM = (BXG .<= .15) .* (2 * BXG + .5) ;
    BM = BM + (.15 .< BXG) .* (BXG .<= .2) .* (-12 * (BXG-.15) + .8) ;
    BM = BM + (.2 .< BXG) .* (BXG .<= .5) .* (.2)  ;
    BM = BM + (.5 .< BXG) .* (BXG .<= .6) .* (6 * (BXG-.5) + .2) ;
    BM = BM + (.6 .< BXG) .* (BXG .<= .65) .* (-10 * (BXG-.6) + .8) ;
    BM = BM + (.65 .< BXG) .* (BXG .<= .85) .* (-1/2 * (BXG-.65)+.3) ;
    BM = BM + (.85 .< BXG) .* (2 * (BXG -.85) + .2)  ;
      ELSEIF IT == 9 ;
        TARSTR = "Parabs" ;
        BM = .8 .* ONES(2*NMAX-1,1) ;
        BM = BM + (.1 .< BXG) .* (-30 .* (BXG - .1)^2) ;
        BM = BM + (.2 .< BXG) .* (60 .* (BXG - .2)^2) ;
        BM = BM + (.3 .< BXG) .* (-30 .* (BXG - .3)^2) ;
        BM = BM + (.35 .< BXG) .* (500 .* (BXG - .35)^2) ;
        BM = BM + (.37 .< BXG) .* (-1000 .* (BXG - .37)^2) ;
        BM = BM + (.41 .< BXG) .* (1000 .* (BXG - .41)^2) ;
        BM = BM + (.43 .< BXG) .* (-500 .* (BXG - .43)^2) ;
        BM = BM + (.5 .< BXG) .* (7.5 .* (BXG - .5)^2) ;
        BM = BM + (.7 .< BXG) .* (-15 .* (BXG - .7)^2) ;
        BM = BM + (.9 .< BXG) .* (7.5 .* (BXG - .9)^2) ;
      ELSEIF IT == 10 ;
        TARSTR = "TShSin" ;
        TBXG = (1 - COS(PI .* BXG)) / 2 ;
        TBXG = (1 - COS(PI .* TBXG)) / 2 ;
        TBXG = (1 - COS(PI .* TBXG)) / 2 ;
        TBXG = (1 - COS(PI .* TBXG)) / 4 + BXG / 2 ;
        BM = .3 * SIN(6 .* PI .* TBXG) + .5 ;
      ENDIF ;
      BXG = 0 ;   FLAG0 = 0 ;   ARG = 0 ;     /*  TO SAVE SPACE  */


      MMSE = ZEROS(NVN,ITHTE-ITHTS+1) ;
      MREM = ZEROS(NMAX,1) ;
                  /*  MATRIX FOR SHOWING REMAINING POWER  */


      IN = 1 ;
      DO WHILE IN <= NVN ;
        N = VN[IN] ;
        "FOR THE "$+TARSTR$+"      N = " N ;


        IF ITHV == 1 ;
          THVSTR = "Sqrt(2 ln(N))" ;
          LAMBDA = SQRT(2 * LN(N)) ;
        ELSEIF ITHV == 2 ;
          THVSTR = "DJ Minmax Opt" ;
          IF N == 64 ;
            LAMBDA = 1.47391 ;
          ELSEIF N == 128 ;
            LAMBDA = 1.66865 ;
          ELSEIF N == 256 ;
            LAMBDA = 1.85982 ;
          ELSEIF N == 512 ;
            LAMBDA = 2.04748 ;
          ELSEIF N == 1024 ;
            LAMBDA = 2.23203 ;
          ELSEIF N == 2048 ;
            LAMBDA = 2.41405 ;
          ELSEIF N == 4096 ;
            LAMBDA = 2.59427 ;
          ELSEIF N == 8192 ;
            LAMBDA = 2.77343 ;
          ELSEIF N == 16384 ;
            LAMBDA = 2.95218 ;
          ELSEIF N == 32768 ;
            LAMBDA = 3.13093 ;
          ELSEIF N == 65536 ;
            LAMBDA = 3.30975 ;
          ENDIF ;
        ENDIF ;


        J0E = ROUND(LOG(N) / LOG(2)) ;
        J0GRID = SEQA(1,1,J0E) ;

                 /*  GET DECIMATED VERSION  */
        M = RESHAPE(BM,N,2*NMAX/N) ;
        M = M[.,NMAX/N] ;


                  /*  GET WAVELET COEFFS OF TARGET  */
        IF IBAS <= 7 ;
          COEFFS = WV2D1(M,ITYPE,IPAR,-1) ;
                        /*  RECALL -1 GIVES LOWEST LEVEL POSSIBLE  */
        ELSEIF IBAS == 8 ;
          COEFFS = WVFFTD(M) ;
        ENDIF ;


        ITHT = ITHTS ;       /*  LOOP THROUGH THRESHOLD TYPES  */
        DO WHILE ITHT <= ITHTE ;

          IF ITHT == 0 ;
            THTSTR = "Proj" ;
          ELSEIF ITHT == 1 ;
            THTSTR = "Hard" ;
          ELSEIF ITHT == 2 ;
            THTSTR = "Soft" ;
          ENDIF ;


          "CALCULATING RISK FOR "$+THTSTR$+" THREHSOLDING " ;
          MSE = WV2MSE1(COEFFS,LAMBDA,SIG2,J0GRID,ITHT) ;


          MMSE[IN,ITHT+1] = MINC(MSE) ;          /*  MIN OVER J0  */


          IF IN == NVN ;
            MREM[.,IB] = SORTC(COEFFS^2,1) ;
          ENDIF ;

          IF ITHT == 0 ;
            _PLEGSTR = THTSTR ;
          ELSE ;
            _PLEGSTR = _PLEGSTR$+"\000"$+THTSTR ;
          ENDIF ;


          ITHT = ITHT + 1 ;
        ENDO ;


        IN = IN + 1 ;
      ENDO ;

      BM = 0 ;   M = 0 ;   COEFFS = 0 ;   /*  TO SAVE SPACE  */



               /*  PUT ON SCALE OF ISE  */
      MMSE = MMSE ./ VN ;


               /*  TRUNCATE AND PUT ON LOG SCALE   */
      FLAG = MMSE .> 10^(-12) ;    /*  ONES WHERE NOT TOO SMALL  */
      MMSE = FLAG .* MMSE + (1 - FLAG) .* 10^(-12) ;
                /*  REPLACES SMALLER VALUES BY 10^(-12)  */
      MMSE = LOG(MMSE) ;
      MMSE = MMSE / LOG(2) ;


      MREM = CUMSUMC(MREM) ;
      MREM = REV(MREM) ;    /*  PUT IN DECREASING ORDER  */

      FLAG = MREM .> 10^(-12) ;    /*  ONES WHERE NOT TOO SMALL  */
      MREM = FLAG .* MREM + (1 - FLAG) .* 10^(-12) ;
                /*  REPLACES SMALLER VALUES BY 10^(-12)  */
      MREM = LOG(MREM) ;

      FLAG = 0 ;      /*  TO SAVE SPACE  */


               "START GRAPHICS" ;
      BEGWIND ;
      MAKEWIND(9.5,7,0,0,0) ;
      MAKEWIND(3,2,.9,0.9,1) ;
      SETWIND(1) ;

          _PLINE = 1~6~LOG(.02)~BOTTOM~LOG(.02)~TOP~1~1~0 ;
          _PLINE = _PLINE|(1~6~LOG(.1)~BOTTOM~LOG(.1)~TOP~1~1~0) ;

        _PDATE = "From WV2ER3B.PRG     " ;
          TITSTR = "Exact MSE as a Function of n = " ;
          TITSTR = TITSTR$+FTOS(VN[1],"%*.*lf",1,0) ;
          TITSTR = TITSTR$+",...," ;
          TITSTR = TITSTR$+FTOS(VN[NVN],"%*.*lf",1,0) ;
          TITSTR = TITSTR$+"\LBased on" ;
          TITSTR = TITSTR$+" Data with Gaussian Errors" ;
          _PMSGSTR = "Thresh Value = "$+THVSTR ;
          _PMSGSTR = _PMSGSTR$+"\000Basis = "$+BASTR ;
          _PMSGSTR = _PMSGSTR$+"\000Noise Level = "$+SIGSTR ;
          _PMSGSTR = _PMSGSTR$+"\000Target = "$+TARSTR ;
            MX1 = LEFT + .05 * (RIGHT - LEFT) ;
            MY1 = BOTTOM + .9 * (TOP - BOTTOM) ;
            MY2 = BOTTOM + .8 * (TOP - BOTTOM) ;
            MY3 = BOTTOM + .7 * (TOP - BOTTOM) ;
            MY4 = BOTTOM + .6 * (TOP - BOTTOM) ;
          _PMSGCTL = MX1~MY1~.15~0~1~9~0 ;
          _PMSGCTL = _PMSGCTL|(MX1~MY2~.15~0~1~9~0) ;
          _PMSGCTL = _PMSGCTL|(MX1~MY3~.15~0~1~9~0) ;
          _PMSGCTL = _PMSGCTL|(MX1~MY4~.15~0~1~9~0) ;
            LX = LEFT + .82 * (RIGHT - LEFT) ;
            LY = BOTTOM + .82 * (TOP - BOTTOM) ;
          _PLEGCTL = 1~3~LX~LY ;
          XLABEL("log]2[(n)") ;
          YLABEL("log]2[(MSE)") ;
          XTICS(LEFT,RIGHT,XSTEP,XMSD) ;
          YTICS(BOTTOM,TOP,YSTEP,YMSD) ;
        TITLE(TITSTR) ;
      XY(LOG(VN)/LOG(2),MMSE) ;

      NEXTWIND ;
          _PDATE = 0 ;
          _PMSGCTL = 0 ;
          _PLEGCTL = 0 ;
        XTICS(0,1,.25,5) ;
        YTICS(-10,2,2,1) ;
        XLABEL("Proportion of Coeffs") ;
        YLABEL("log]10[(Power)") ;
          TITSTR = "`Power Remaining' in Smaller Coefficients" ;
        TITLE(TITSTR) ;
      XY(SEQA(1/(2*NMAX),1/NMAX,NMAX),MREM) ;



      IF AUTOP == 1 ;
          PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\R3B" ;
          PRSTR = PRSTR$+FTOS(IT,"%*.*lf",1,0) ;
          PRSTR = PRSTR$+FTOS(IS,"%*.*lf",1,0) ;
          PRSTR = PRSTR$+FTOS(IB,"%*.*lf",1,0) ;
          PRSTR = PRSTR$+FTOS(ITHV,"%*.*lf",1,0) ;
          PRSTR = PRSTR$+".PLT" ;
        GRAPHPRT(PRSTR) ;
      ELSEIF AUTOP == 2 ;
          PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\R3B" ;
          PRSTR = PRSTR$+FTOS(IT,"%*.*lf",1,0) ;
          PRSTR = PRSTR$+FTOS(IS,"%*.*lf",1,0) ;
          PRSTR = PRSTR$+FTOS(IB,"%*.*lf",1,0) ;
          PRSTR = PRSTR$+FTOS(ITHV,"%*.*lf",1,0) ;
          PRSTR = PRSTR$+".PS" ;
        GRAPHPRT(PRSTR) ;
      ENDIF ;

      ENDWIND ;

      IT = IT + 1 ;
    ENDO ;

      IS = IS + 1 ;
    ENDO ;

    ITHV = ITHV + 1 ;
  ENDO ;

  IB = IB + 1 ;
ENDO ;


END ;
