"GAUSS PROGRAM WV2ER5A.PRG" ;
/*  EXACT RISK MSE FOR 2ND GENERATION WAVELET ESTIMATORS
BASED ON THRESHOLDING AND LOW FREQUENCY IDEAS
THIS VERSION STUDIES 2D DEPENDENCE ON J0 AND LAMBDA */

LIBRARY PGRAPH ;
GRAPHSET ;

AUTOP = 2 ;         /*  0 TO VIEW ON SCREEN   */
                    /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                    /*  2 TO WRITE AS POSTSCRIPT FILES  */

VIBASIS = 5 ;       /*  LOOP THROUGH ENTRIES OF THIS VECTOR  */
                    /*  1 - HAAR    */
                    /*  2 - DAUBECHIES 4    */
                    /*  3 - DAUBECHIES 6    */
                    /*  4 - SYMMLET 6    */
                    /*  5 - SYMMLET 8    */
                    /*  6 - COIFLET 2    */
                    /*  7 - COIFLET 3    */
                    /*  8 - FOURIER    */

ITHTYP = 2 ;       /*  -1 - LOOP THROUGH ALL    */
                    /*   0 - PROJECTION (LOW FREQUENCY RECONSTRUCT)   */
                    /*   1 - HARD THRESHOLDING   */
                    /*   2 - SOFT THRESHOLDING   */

/*
ITHVAL = 1 ;        /*   0 - LOOP THROUGH ALL   */
                    /*   1 - SQRT(2 * LN(N))     */
                    /*   2 - DJ MINIMAX MSE OPTIMAL   */
*/
/*  NOW HAVE GRID OF LAMBDA'S   */


ITARGET = 0 ;       /*   0 - LOOP THROUGH ALL    */
                    /*   1 - STEP       */
                    /*   2 - WAVE       */
                    /*   3 - BLIP       */
                    /*   4 - BLOCKS     */
                    /*   5 - BUMPS      */
                    /*   6 - HEAVSI     */
                    /*   7 - DOPPL      */
                    /*   8 - ANGLES     */
                    /*   9 - PARABS     */
                    /*   10 - SHSIN     */

ISIGMA = 0 ;        /*   0 - LOOP THROUGH ALL   */
                    /*   1 - LOW NOISE   (SIG = .02)   */
                    /*   2 - HIGH NOISE  (SIG = .1)    */


N = 256 ;           /*   SAMPLE SIZE = NUMBER OF GRID POINTS   */
                    /*   MUST BE A POWER OF 2  */


J0E = ROUND(LOG(N) / LOG(2)) ;
J0GRID = SEQA(1,1,J0E) ;
NSTR = FTOS(N,"%*.*lf",1,0) ;
DELX = 1 / N ;
XGRID = SEQA(DELX/2,DELX,N) ;




                  /*  SET UP LOOPING STUFF  */
IF ITHTYP == -1 ;
  ITHTS = 0 ;
  ITHTE = 2 ;
ELSE ;
  ITHTS = ITHTYP ;
  ITHTE = ITHTYP ;
ENDIF ;

/*  LOG2(COEFFICIENTS) FOR LAMBDA VALUES  */
NL = 13 ;     /*  NUMBER OF LAMBDAS IN GRID  */
LCS = -2 ;    /*  LOG2(STARTING COEFFICIENT)  */
LCE = 1 ;     /*  LOG2(ENDING COEFFICIENT)  */
LCGRID = SEQA(-2,(LCE - LCS)/(NL - 1),NL) ;
CGRID = 2^LCGRID ;


IF ITARGET == 0 ;
  ITS = 1 ;
  ITE = 10 ;
ELSE ;
  ITS = ITARGET ;
  ITE = ITARGET ;
ENDIF ;

IF ISIGMA == 0 ;
  ISS = 1 ;
  ISE = 2 ;
ELSE ;
  ISS = ISIGMA ;
  ISE = ISIGMA ;
ENDIF ;


NB = ROWS(VIBASIS) ;


THVSTR1 = "Sqrt(2 ln(N))" ;
LAMBDA1 = SQRT(2 * LN(N)) ;
THVSTR2 = "DJ Minmax Opt" ;
IF N == 64 ;
  LAMBDA2 = 1.47391 ;
ELSEIF N == 128 ;
  LAMBDA2 = 1.66865 ;
ELSEIF N == 256 ;
  LAMBDA2 = 1.85982 ;
ELSEIF N == 512 ;
  LAMBDA2 = 2.04748 ;
ELSEIF N == 1024 ;
  LAMBDA2 = 2.23203 ;
ELSEIF N == 2048 ;
  LAMBDA2 = 2.41405 ;
ELSEIF N == 4096 ;
  LAMBDA2 = 2.59427 ;
ELSEIF N == 8192 ;
  LAMBDA2 = 2.77343 ;
ELSEIF N == 16384 ;
  LAMBDA2 = 2.95218 ;
ELSEIF N == 32768 ;
  LAMBDA2 = 3.13093 ;
ELSEIF N == 65536 ;
  LAMBDA2 = 3.30975 ;
ENDIF ;

VLAMBDA = CGRID * LAMBDA1 ;    /*  VECTOR OF LAMBDAS  */



                  /*  SET GRAPHICS STUFF  */
VX = -5000 ;
VY = -10000 ;
VZ = 7000 ;
VIEW(VX,VY,VZ) ;
VOLX = 1 ;
VOLY = 1 ;
VOLZ = 1 ;
VOLUME(VOLX,VOLY,VOLZ) ;   /*  RATIOS ARE IMPORTANT  */



ITHT = ITHTS ;       /*  LOOP THROUGH THRESHOLD TYPES  */
DO WHILE ITHT <= ITHTE ;

  IF ITHT == 0 ;
    THTSTR = "Proj" ;
  ELSEIF ITHT == 1 ;
    THTSTR = "Hard" ;
  ELSEIF ITHT == 2 ;
    THTSTR = "Soft" ;
  ENDIF ;




  IS = ISS ;
  DO WHILE IS <= ISE ;

    IF IS == 1 ;
      SIG = .02 ;
      SIGSTR = "Low" ;
      BOTTOM = -1.5 ;
      TOP = -.5 ;
      ZSTEP = .5 ;
      ZMSD = 5 ;
    ELSEIF IS == 2 ;
      SIG = .1 ;
      SIGSTR = "High" ;
      BOTTOM = -.5 ;
      TOP = .5 ;
      ZSTEP = .5 ;
      ZMSD = 5 ;
    ENDIF ;
    SIG2 = SIG^2 ;


    IT = ITS ;      /*  LOOP THROUGH TARGET FUNCTIONS  */
    DO WHILE IT <= ITE ;

      IF IT == 1 ;
        TARSTR = "Step" ;
        M = 0.2 ;      /*  BASE HEIGHT  */
        M = M + (1/3 .< XGRID) .* (XGRID .< .75) * .6 ;
                       /*  RAISE BY .4 ON THIS INTERVAL  */
      ELSEIF IT == 2 ;
        TARSTR = "Wave" ;
        M = .2 * COS(XGRID * 2 * PI * 2) + .5 ;
        M = M + .1 * COS(XGRID * 2 * PI * 12) ;
      ELSEIF IT == 3 ;
        TARSTR = "Blip" ;
        M = .6 * XGRID + .2 ;
        M = M + .3 * EXP(-100 * (XGRID - .5) .* (XGRID - .5)) ;
          RM = ROWS(M) ;
        M = M[(RM/5)+1:RM]|M[1:RM/5] ;
                       /*  ROTATE SO DISCONT NOT AT EDGE  */
      ELSEIF IT == 4 ;
        TARSTR = "Blocks" ;
          T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
          H = 4|-5|3|-4|5|-4.2|2.1|4.3|-3.1|2.1|-4.2 ;
        M = XGRID' - T ;
          FLAG = M .> 0 ;
          FLAG0 = M .== 0 ;
        M = FLAG - (1 - FLAG - FLAG0) ;       /*  GIVES SGN(M)  */
        M = (1 + M) / 2 ;
        M = H .* M ;
        M = SUMC(M) ;               /*  THIS IS NOW DJ'S BLOCKS   */
        M = (.6 / 9.2) * (M + 2) + .2 ;  /*  RESCALED TO [.2,.8]  */
      ELSEIF IT == 5 ;
        TARSTR = "Bumps" ;
          T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
          H = 4|5|3|4|5|4.2|2.1|4.3|3.1|5.1|4.2 ;
          W = .005|.005|.006|.01|.01|.03|.01|.01|.005|.008|.005 ;
        M = (XGRID' - T) ./ W ;
        M = 1 ./ (1 + ABS(M))^4 ;
        M = H .* M ;
        M = SUMC(M) ;                  /*  THIS IS NOW DJ'S BUMPS   */
        M = (.6/5.3437952) * M + .2 ;      /*  RESCALED TO [.2,.8]  */
      ELSEIF IT == 6 ;
        TARSTR = "HeavSi" ;
        M = 4 * SIN(4 * PI * XGRID) ;
          FLAG = XGRID .> .3 ;
          FLAG0 = XGRID .== .3 ;
        M = M - (FLAG - (1 - FLAG - FLAG0)) ;
          FLAG = XGRID .> .72 ;
          FLAG0 = XGRID .== .72 ;
        M = M + (FLAG - (1 - FLAG - FLAG0)) ;  /*  DJ'S HEAVY SINE  */
        M = (.6 / 9) * (M + 5) + .2 ;      /*  RESCALED TO [.2,.8]  */
      ELSEIF IT == 7 ;
        TARSTR = "Doppl" ;
        M = SQRT(XGRID .* (1 - XGRID)) ;
        M = M .* SIN(2 * PI * 1.05 ./ (XGRID + .05)) ; /* DJ'S DOPPLER */
        M = (.6 / 1) * (M + .5) + .2 ;      /*  RESCALED TO [.2,.8]  */
      ELSEIF IT == 8 ;
        TARSTR = "Angles" ;
        M = (XGRID .<= .15) .* (2 * XGRID + .5) ;
    M = M + (.15 .< XGRID) .* (XGRID .<= .2) .* (-12 * (XGRID-.15) + .8) ;
    M = M + (.2 .< XGRID) .* (XGRID .<= .5) .* (.2)  ;
    M = M + (.5 .< XGRID) .* (XGRID .<= .6) .* (6 * (XGRID-.5) + .2) ;
    M = M + (.6 .< XGRID) .* (XGRID .<= .65) .* (-10 * (XGRID-.6) + .8) ;
    M = M + (.65 .< XGRID) .* (XGRID .<= .85) .* (-1/2 * (XGRID-.65)+.3) ;
    M = M + (.85 .< XGRID) .* (2 * (XGRID -.85) + .2)  ;
      ELSEIF IT == 9 ;
        TARSTR = "Parabs" ;
        M = .8 .* ONES(N,1) ;
        M = M + (.1 .< XGRID) .* (-30 .* (XGRID - .1)^2) ;
        M = M + (.2 .< XGRID) .* (60 .* (XGRID - .2)^2) ;
        M = M + (.3 .< XGRID) .* (-30 .* (XGRID - .3)^2) ;
        M = M + (.35 .< XGRID) .* (500 .* (XGRID - .35)^2) ;
        M = M + (.37 .< XGRID) .* (-1000 .* (XGRID - .37)^2) ;
        M = M + (.41 .< XGRID) .* (1000 .* (XGRID - .41)^2) ;
        M = M + (.43 .< XGRID) .* (-500 .* (XGRID - .43)^2) ;
        M = M + (.5 .< XGRID) .* (7.5 .* (XGRID - .5)^2) ;
        M = M + (.7 .< XGRID) .* (-15 .* (XGRID - .7)^2) ;
        M = M + (.9 .< XGRID) .* (7.5 .* (XGRID - .9)^2) ;
      ELSEIF IT == 10 ;
        TARSTR = "TShSin" ;
        TXGRID = (1 - COS(PI .* XGRID)) / 2 ;
        TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
        TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
        TXGRID = (1 - COS(PI .* TXGRID)) / 4 + XGRID / 2 ;
        M = .3 * SIN(6 .* PI .* TXGRID) + .5 ;
      ENDIF ;


      IB = 1 ;      /*  LOOP THROUGH BASES  */
      DO WHILE IB <= NB ;
        IBAS = VIBASIS[IB] ;

        IF IBAS <= 7 ;
          IF IBAS == 1 ;
            ITYPE = 1 ;
            IPAR = 0 ;
            BASTR = "Haar" ;
          ELSEIF IBAS == 2 ;
            ITYPE = 2 ;
            IPAR = 4 ;
            BASTR = "Daub4" ;
          ELSEIF IBAS == 3 ;
            ITYPE = 2 ;
            IPAR = 6 ;
            BASTR = "Daub6" ;
          ELSEIF IBAS == 4 ;
            ITYPE = 3 ;
            IPAR = 6 ;
            BASTR = "Symm6" ;
          ELSEIF IBAS == 5 ;
            ITYPE = 3 ;
            IPAR = 8 ;
            BASTR = "Symm8" ;
          ELSEIF IBAS == 6 ;
            ITYPE = 4 ;
            IPAR = 2 ;
            BASTR = "Coif2" ;
          ELSEIF IBAS == 7 ;
            ITYPE = 4 ;
            IPAR = 3 ;
            BASTR = "Coif3" ;
          ENDIF ;

                  /*  GET WAVELET COEFFS OF TARGET  */
          COEFFS = WV2D1(M,ITYPE,IPAR,-1) ;
                        /*  RECALL -1 GIVES LOWEST LEVEL POSSIBLE  */

        ELSEIF IBAS == 8 ;
          BASTR = "Fourier" ;

          COEFFS = WVFFTD(M) ;

        ENDIF ;

        "FOR THE "$+THTSTR$+"  "$+SIGSTR$+"  "$+TARSTR$+"  "$+BASTR ;

        IL = 1 ;
        MMSE = ZEROS(J0E,NL) ;
        DO WHILE IL <= NL ;
          LAMBDA = VLAMBDA[IL] ;
          "    CALCULATING RISK FOR LAMBDA = "$+FTOS(LAMBDA,"%*.*lf",5,3) ;
          MSE = WV2MSE1(COEFFS,LAMBDA,SIG2,J0GRID,ITHT) ;

          MMSE[.,IL] = MSE ;

          IL = IL + 1 ;
        ENDO ;


        MSEJ0MIN = MINC(MMSE) ;    /*   MIN MSE, FOR EACH LAMBDA    */
        ILMIN = MININDC(MSEJ0MIN) ;    /*  INDEX OF LAMBDA TO MIN OVERALL  */
        J0MIN = MININDC(MMSE[.,ILMIN]) ;   /*  INDEX OF J0 TO MIN OVERALL  */
        LMIN = VLAMBDA[ILMIN] ;
        MSEMIN = MINC(MSEJ0MIN) ;
        MSEMIN = LOG(MSEMIN) ;



                 /*  TRUNCATE AND PUT ON LOG SCALE   */
        FLAG = MMSE .> 10^(-12) ;    /*  ONES WHERE NOT TOO SMALL  */
        MMSE = FLAG .* MMSE + (1 - FLAG) .* 10^(-12) ;
                  /*  REPLACES SMALLER VALUES BY 10^(-12)  */
        MMSE = LOG(MMSE) ;




                          /*  SET GRAPHICS STUFF  */
          _PLTYPE = 6|1|3|4 ;
          LEFT = 1 ;
          RIGHT = J0E ;
          XSTEP = 1 ;
          XMSD = 1 ;


                 "START GRAPHICS" ;
        IF AUTOP == 1 ;
            PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\R5A" ;
            PRSTR = PRSTR$+FTOS(ITHT,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+FTOS(IS,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+FTOS(IT,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+".PLT" ;
          GRAPHPRT(PRSTR) ;
        ELSEIF AUTOP == 2 ;
            PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\R5A" ;
            PRSTR = PRSTR$+FTOS(ITHT,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+FTOS(IS,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+FTOS(IT,"%*.*lf",1,0) ;
            PRSTR = PRSTR$+".PS" ;
          GRAPHPRT(PRSTR) ;
        ENDIF ;

            CO = 9 ;   /*  COLOR  */
            TY = 4 ;   /*  LINE TYPE  */
            TH = 2 ;   /*  THICKNESS  */
            HL = 0 ;   /*  HIDE BEHIND SURFACE  */
            LPAR = CO~TY~TH~HL ;
            LL1 = LOG(LAMBDA1 / LAMBDA1) / LOG(2) ;
        _PLINE3D = LL1~J0E~BOTTOM~LL1~J0E~TOP~LPAR ;
        _PLINE3D = _PLINE3D|(LL1~1~BOTTOM~LL1~1~TOP~LPAR) ;
        _PLINE3D = _PLINE3D|(LL1~1~BOTTOM~LL1~J0E~BOTTOM~LPAR) ;
        _PLINE3D = _PLINE3D|(LL1~1~TOP~LL1~J0E~TOP~LPAR) ;
            TY = 4 ;   /*  LINE TYPE  */
            LPAR = CO~TY~TH~HL ;
            LL2 = LOG(LAMBDA2 / LAMBDA1) / LOG(2) ;
        _PLINE3D = _PLINE3D|(LL2~J0E~BOTTOM~LL2~J0E~TOP~LPAR) ;
        _PLINE3D = _PLINE3D|(LL2~1~BOTTOM~LL2~1~TOP~LPAR) ;
        _PLINE3D = _PLINE3D|(LL2~1~BOTTOM~LL2~J0E~BOTTOM~LPAR) ;
        _PLINE3D = _PLINE3D|(LL2~1~TOP~LL2~J0E~TOP~LPAR) ;
            TY = 1 ;   /*  LINE TYPE  */
            LPAR = CO~TY~TH~HL ;
            LLM = LOG(LMIN / LAMBDA1) / LOG(2) ;
        _PLINE3D = _PLINE3D|(LLM~J0MIN~MSEMIN~LLM~J0MIN~TOP~LPAR) ;


          _PDATE = "From WV2ER5A.PRG     " ;
            TITSTR = "Exact MSE as a Function of j]0[ and Lambda" ;
            TITSTR = TITSTR$+"\LBased on n = "$+NSTR ;
            TITSTR = TITSTR$+" Data with Gaussian Errors" ;
            TITSTR = TITSTR$+"\LThresh = "$+THTSTR ;
            TITSTR = TITSTR$+"   Noise = "$+SIGSTR ;
            TITSTR = TITSTR$+"   Target = "$+TARSTR ;
              MX1 = .5 ;
              MY1 = 5 ;
              MY2 = 4.5 ;
              MY3 = 4 ;
            _PMSGCTL = 0 ;
            _PLEGCTL = 0 ;
            XLABEL("log2(LAMBDA/R2LN)") ;
            YLABEL("j]0[") ;
            ZLABEL("log]10[(MSE)") ;
            XTICS(LCS,LCE,1,4) ;
            YTICS(LEFT,RIGHT,XSTEP,XMSD) ;
            ZTICS(BOTTOM,TOP,ZSTEP,ZMSD) ;
          TITLE(TITSTR) ;
        SURFACE(LCGRID',J0GRID,MMSE) ; ? ;



        IB = IB + 1 ;
      ENDO ;

      IT = IT + 1 ;
    ENDO ;

    IS = IS + 1 ;
  ENDO ;


  ITHT = ITHT + 1 ;
ENDO ;


END ;
