/* =========================== START PROC WV2IR1 ======================== */
PROC WV2IR1(MU,LAMBDA,ITHRE) ;
    /*   FOR EXACT RISK ANALYSIS IN 2ND GENERATION WAVELET WORK     */
    /*   THIS CALCULATES IAIN JOHNSTONE'S R FUNCTION     */
    /*   INPUTS ARE:     */
    /*     MU = SOME MATRIX OF MEANS    */
    /*     LAMBDA = THRESHOLD VALUE   (E.G. SQRT(2LOGN))   */
    /*           CAN BE SCALAR, VECTOR OR MATRIX CONFORMING TO MU   */
    /*     ITHRE = 0   FOR PROJECTION (I.E. LO FREQ RECON.)   */
    /*           = 1   FOR HARD THRESHOLDING   */
    /*           = 2   FOR SOFT THRESHOLDING    */
    /*   OUTPUT IS  IAIN'S FUNCTION R(MU,LAMBDA) AS A MATRIX   */
    /*       TO GET R~(THETA,LAMBDA*SIG),     */
    /*               USE SIG^2 * R(THETA/SIG,LAMBDA)    */

  LOCAL ROUT ;

    IF ITHRE == 0 ;      /*  PROJECTION, IE. LO FREQ RECONSTRUCT   */
      ROUT = MU^2 ;
    ELSEIF ITHRE == 1 ;  /*  HARD THRESHOLDING   */
      ROUT = MU^2 .* (CDFN(LAMBDA - MU) - CDFN(-LAMBDA - MU)) ;
      ROUT = ROUT + CDFNC(LAMBDA - MU) + CDFNC(LAMBDA + MU) ;
      ROUT = ROUT + (LAMBDA - MU) .* PDFN(LAMBDA - MU) ;
      ROUT = ROUT + (LAMBDA + MU) .* PDFN(LAMBDA + MU) ;
    ELSEIF ITHRE == 2 ;  /*  SOFT THRESHOLDING   */
      ROUT = CDFN(LAMBDA - MU) - CDFN(-LAMBDA - MU) ;
      ROUT = (MU^2 - LAMBDA^2 - 1) .* ROUT ;
      ROUT = ROUT - (LAMBDA - MU) .* PDFN(LAMBDA + MU) ;
      ROUT = ROUT - (LAMBDA + MU) .* PDFN(LAMBDA - MU) ;
      ROUT = 1 + LAMBDA^2 + ROUT ;
    ENDIF ;

  RETP(ROUT) ;
ENDP ;
/* ============================ END PROC WV2IR1 ========================= */
