/* =========================== START PROC WV2MSE1 ======================== */
PROC WV2MSE1(THETA,LAMBDA,VSIG2,VJ0,ITHRE) ;
    /*   FOR EXACT RISK ANALYSIS IN 2ND GENERATION WAVELETS     */
    /*   THIS CALCULATES MY VERSION OF IAIN JOHNSTONE'S    */
    /*   EXACT MEAN SQUARED ERROR FOR AN    */
    /*   ORTHOGONAL SERIES REGRESSION ESTIMATOR    */
    /*   DIFFERENCE WITH OTHER VERSIONS COMES FROM MY WAVELET   */
    /*   TRANSFORM EXACTLY PRESERVING POWER (NO 1/N FACTOR)  */
    /*   INPUTS ARE:     */
    /*     THETA = THE WAVELET COEFFS OF TARGET CURVE    */
    /*                   (COLUMN VECTOR OF LENGTH N=2^JE)  */
    /*                   (IN FORM FROM WV2D1.G)   */
    /*     LAMBDA = THRESHOLD VALUE   (E.G. SQRT(2LOGN))   */
    /*           CAN BE SCALAR, OR N VECTOR (CONFORMABLE WITH THETA)  */
    /*     VSIG2 = ROW VECTOR OF VARIANCES OF    */
    /*           ASSUMED IID N(0,1) NOISES    */
    /*     VJ0 = COLUMN VECTOR OF INDICES   */
    /*                 OF LOWEST FREQUENCY THRESHOLDED   */
    /*     ITHRE = 0   FOR 0 THRESHHOLDING (I.E. LO FREQ RECON.)   */
    /*           = 1   FOR HARD THRESHOLDING   */
    /*           = 2   FOR SOFT THRESHOLDING    */
    /*   OUTPUT IS MEAN SQUARE ERROR (SUMMED OVER LOCATIONS)    */
    /*       ROWS INDEXED AS VJ0, COLS INDEXED AS VSIG2   */

  LOCAL N,JE,NSIG,NJ0,MU,R,IJ0,J0,MSE ;

  N = ROWS(THETA) ;
  JE = ROUND(LOG(N) / LOG(2)) ;
  NSIG = COLS(VSIG2) ;
  NJ0 = ROWS(VJ0) ;

  MU = THETA ./ SQRT(VSIG2) ;            /*  MATRIX OF VALUES  */
  R = WV2IR1(MU,LAMBDA,ITHRE) ;               /*  IAIN'S R FUNCTION  */

  MSE = ONES(NJ0,NSIG) .* 2^VJ0 ;
  IJ0 = 1 ;
  DO WHILE IJ0 <= NJ0 ;
    J0 = VJ0[IJ0] ;
    IF J0 < JE ;
      MSE[IJ0,.] = MSE[IJ0,.] + SUMC(R[(2^J0)+1:N,.])' ;
    ENDIF ;
           /*  OTHERWISE, WANT ONLY 2^J0, VAR PART   */

    IJ0 = IJ0 + 1 ;
  ENDO ;

  MSE = MSE .* VSIG2 ;


  RETP(MSE) ;
ENDP ;
/* ============================ END PROC WV2MSE1 ========================= */
