/*  GAUSS PROGRAM WV2MSE1.TST
FOR DEVELOPMENT AND TESTING OF WV2MSE1.G,
FOR EXACT RISK IN WAVELETS, THIS
CALCULATES MY VERSION OF IAIN JOHNSTONE'S EXACT MSE  */


ITEST = 1 ;

IF ITEST == 1 ;
  THETA = .75 * ONES(64,1) ;
  SIG2 = 1.2 ;
  LAMBDA = .8 ;
  J0 = 6 ;
  ITHRE = 2 ;
  VSIG2 = SIG2 ;
  VJ0 = J0 ;
ELSEIF ITEST == 2 ;
  THETA = .75*ONES(16,1) ;
  LAMBDA = .8 ;
        /*  CAN'T DO MORE THAN THESE WITHOUT A LOT OF WORK,
               SINCE WAVELET COEFFICIENTS NOW INDEXED DIFFERENTLY   */
  VJ0 = 1|2|3 ;
  ITHRE = 0 ;
  VSIG2 = .8~.4 ;
ENDIF ;



/* =========================== START PROC WV2MSE1 ======================== */
PROC WV2MSE1(THETA,LAMBDA,VSIG2,VJ0,ITHRE) ;
    /*   FOR EXACT RISK ANALYSIS IN 2ND GENERATION WAVELETS     */
    /*   THIS CALCULATES MY VERSION OF IAIN JOHNSTONE'S    */
    /*   EXACT MEAN SQUARED ERROR FOR AN    */
    /*   ORTHOGONAL SERIES REGRESSION ESTIMATOR    */
    /*   DIFFERENCE WITH OTHER VERSIONS COMES FROM MY WAVELET   */
    /*   TRANSFORM EXACTLY PRESERVING POWER (NO 1/N FACTOR)  */
    /*   INPUTS ARE:     */
    /*     THETA = THE WAVELET COEFFS OF TARGET CURVE    */
    /*                   (COLUMN VECTOR OF LENGTH N=2^JE)  */
    /*                   (IN FORM FROM WV2D1.G)   */
    /*     LAMBDA = THRESHOLD VALUE   (E.G. SQRT(2LOGN))   */
    /*           CAN BE SCALAR, OR N VECTOR (CONFORMABLE WITH THETA)  */
    /*     VSIG2 = ROW VECTOR OF VARIANCES OF    */
    /*           ASSUMED IID N(0,1) NOISES    */
    /*     VJ0 = COLUMN VECTOR OF INDICES   */
    /*                 OF LOWEST FREQUENCY THRESHOLDED   */
    /*     ITHRE = 0   FOR 0 THRESHHOLDING (I.E. LO FREQ RECON.)   */
    /*           = 1   FOR HARD THRESHOLDING   */
    /*           = 2   FOR SOFT THRESHOLDING    */
    /*   OUTPUT IS MEAN SQUARE ERROR (SUMMED OVER LOCATIONS)    */
    /*       ROWS INDEXED AS VJ0, COLS INDEXED AS VSIG2   */

  LOCAL N,JE,NSIG,NJ0,MU,R,IJ0,J0,MSE ;

  N = ROWS(THETA) ;
  JE = ROUND(LOG(N) / LOG(2)) ;
  NSIG = COLS(VSIG2) ;
  NJ0 = ROWS(VJ0) ;

  MU = THETA ./ SQRT(VSIG2) ;            /*  MATRIX OF VALUES  */
  R = WV2IR1(MU,LAMBDA,ITHRE) ;               /*  IAIN'S R FUNCTION  */

  MSE = ONES(NJ0,NSIG) .* 2^VJ0 ;
  IJ0 = 1 ;
  DO WHILE IJ0 <= NJ0 ;
    J0 = VJ0[IJ0] ;
    IF J0 < JE ;
      MSE[IJ0,.] = MSE[IJ0,.] + SUMC(R[(2^J0)+1:N,.])' ;
    ENDIF ;
           /*  OTHERWISE, WANT ONLY 2^J0, VAR PART   */

    IJ0 = IJ0 + 1 ;
  ENDO ;

  MSE = MSE .* VSIG2 ;


  RETP(MSE) ;
ENDP ;
/* ============================ END PROC WV2MSE1 ========================= */



IF ITEST == 1 ;
  OUTOLD = WVERMSE1(THETA,SIG2,LAMBDA,J0,ITHRE) ;

ELSEIF ITEST == 2 ;
  OUTOLD = ZEROS(ROWS(VJ0),COLS(VSIG2)) ;
  IJ0 = 1 ;
  DO WHILE IJ0 <= ROWS(VJ0) ;
    J0 = VJ0[IJ0] ;

    ISIG = 1 ;
    DO WHILE ISIG <= COLS(VSIG2) ;
      SIG2 = VSIG2[ISIG] ;
      OUTOLD[IJ0,ISIG] = WVERMSE1(THETA,SIG2,LAMBDA,J0,ITHRE) ;

      ISIG = ISIG + 1 ;
    ENDO ;

    IJ0 = IJ0 + 1 ;
  ENDO ;
ENDIF ;


OUT = WV2MSE1(THETA,LAMBDA,VSIG2,VJ0,ITHRE) ;


OUTOLD ; OUT ;



END ;

