/*  GAUSS PROGRAM WV2SNR.PRG
2ND GENERATION WAVELET INVESTIGATION
FOR CHECKING IAIN'S "SIGNAL TO NOISE RATIOS"  */



N = 256 ;          /*   SAMPLE SIZE  = NUMBER OF GRID POINTS   */
                    /*   MUST BE A POWER OF 2  */

ITARGET = 0 ;       /*   0 - LOOP THROUGH ALL    */
                    /*   1 - STEP       */
                    /*   2 - WAVE       */
                    /*   3 - BLIP       */
                    /*   4 - BLOCKS     */
                    /*   5 - BUMPS      */
                    /*   6 - HEAVSI     */
                    /*   7 - DOPPL      */
                    /*   8 - ANGLES     */
                    /*   9 - PARABS     */
                    /*   10 - SHSIN     */


ISIGMA = 0 ;        /*   0 - LOOP THROUGH ALL    */
                    /*   1 - "LOW NOISE"       */
                    /*   2 - "HIGH NOISE"       */



NSTR = FTOS(N,"%*.*lf",1,0) ;
DELX = 1 / N ;
XGRID = SEQA(DELX/2,DELX,N) ;


                  /*  SET UP LOOPING STUFF  */
IF ITARGET == 0 ;
  ITS = 1 ;
  ITE = 10 ;
ELSE ;
  ITS = ITARGET ;
  ITE = ITARGET ;
ENDIF ;


VSIGF = ZEROS(ITE - ITS + 1,1) ;
VSNRLO = ZEROS(ITE - ITS + 1,1) ;
VSNRHI = ZEROS(ITE - ITS + 1,1) ;

IT = ITS ;      /*  LOOP THROUGH TARGET FUNCTIONS  */
DO WHILE IT <= ITE ;

  IF IT == 1 ;
    TARSTR = "Step" ;
    M = 0.2 ;      /*  BASE HEIGHT  */
    M = M + (1/3 .< XGRID) .* (XGRID .< .75) * .6 ;
                   /*  RAISE BY .4 ON THIS INTERVAL  */
    _PLEGCTL = 1|4|.37|0 ;
  ELSEIF IT == 2 ;
    TARSTR = "Wave" ;
    M = .2 * COS(XGRID * 2 * PI * 2) + .5 ;
    M = M + .1 * COS(XGRID * 2 * PI * 12) ;
    _PLEGCTL = 1|4|0.61|.8 ;
  ELSEIF IT == 3 ;
    TARSTR = "Blip" ;
    M = .6 * XGRID + .2 ;
    M = M + .3 * EXP(-100 * (XGRID - .5) .* (XGRID - .5)) ;
      RM = ROWS(M) ;
    M = M[(RM/5)+1:RM]|M[1:RM/5] ;
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 4 ;
    TARSTR = "Blocks" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|-5|3|-4|5|-4.2|2.1|4.3|-3.1|2.1|-4.2 ;
    M = XGRID' - T ;
      FLAG = M .> 0 ;
      FLAG0 = M .== 0 ;
    M = FLAG - (1 - FLAG - FLAG0) ;       /*  GIVES SGN(M)  */
    M = (1 + M) / 2 ;
    M = H .* M ;
    M = SUMC(M) ;                     /*  THIS IS NOW DJ'S BLOCKS   */
    M = (.6 / 9.2) * (M + 2) + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 5 ;
    TARSTR = "Bumps" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|5|3|4|5|4.2|2.1|4.3|3.1|5.1|4.2 ;
      W = .005|.005|.006|.01|.01|.03|.01|.01|.005|.008|.005 ;
    M = (XGRID' - T) ./ W ;
    M = 1 ./ (1 + ABS(M))^4 ;
    M = H .* M ;
    M = SUMC(M) ;                     /*  THIS IS NOW DJ'S BUMPS   */
    M = (.6/5.3437952) * M + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 6 ;
    TARSTR = "HeavSi" ;
    M = 4 * SIN(4 * PI * XGRID) ;
      FLAG = XGRID .> .3 ;
      FLAG0 = XGRID .== .3 ;
    M = M - (FLAG - (1 - FLAG - FLAG0)) ;
      FLAG = XGRID .> .72 ;
      FLAG0 = XGRID .== .72 ;
    M = M + (FLAG - (1 - FLAG - FLAG0)) ;     /*  DJ'S HEAVY SINE  */
    M = (.6 / 9) * (M + 5) + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 7 ;
    TARSTR = "Doppl" ;
    M = SQRT(XGRID .* (1 - XGRID)) ;
    M = M .* SIN(2 * PI * 1.05 ./ (XGRID + .05)) ;   /*  DJ'S DOPPLER   */
    M = (.6 / 1) * (M + .5) + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 8 ;
    TARSTR = "Angles" ;
    M = (XGRID .<= .15) .* (2 * XGRID + .5) ;
    M = M + (.15 .< XGRID) .* (XGRID .<= .2) .* (-12 * (XGRID -.15) + .8)  ;
    M = M + (.2 .< XGRID) .* (XGRID .<= .5) .* (.2)  ;
    M = M + (.5 .< XGRID) .* (XGRID .<= .6) .* (6 * (XGRID -.5) + .2)  ;
    M = M + (.6 .< XGRID) .* (XGRID .<= .65) .* (-10 * (XGRID -.6) + .8)  ;
    M = M + (.65 .< XGRID) .* (XGRID .<= .85) .* (-1/2 * (XGRID -.65) + .3) ;
    M = M + (.85 .< XGRID) .* (2 * (XGRID -.85) + .2)  ;
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 9 ;
    TARSTR = "Parabs" ;
    M = .8 .* ONES(N,1) ;
    M = M + (.1 .< XGRID) .* (-30 .* (XGRID - .1)^2) ;
    M = M + (.2 .< XGRID) .* (60 .* (XGRID - .2)^2) ;
    M = M + (.3 .< XGRID) .* (-30 .* (XGRID - .3)^2) ;
    M = M + (.35 .< XGRID) .* (500 .* (XGRID - .35)^2) ;
    M = M + (.37 .< XGRID) .* (-1000 .* (XGRID - .37)^2) ;
    M = M + (.41 .< XGRID) .* (1000 .* (XGRID - .41)^2) ;
    M = M + (.43 .< XGRID) .* (-500 .* (XGRID - .43)^2) ;
    M = M + (.5 .< XGRID) .* (7.5 .* (XGRID - .5)^2) ;
    M = M + (.7 .< XGRID) .* (-15 .* (XGRID - .7)^2) ;
    M = M + (.9 .< XGRID) .* (7.5 .* (XGRID - .9)^2) ;
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 10 ;
    TARSTR = "TShSin" ;
    TXGRID = (1 - COS(PI .* XGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 4 + XGRID / 2 ;
    M = .3 * SIN(6 .* PI .* TXGRID) + .5 ;
    _PLEGCTL = 1|4|.6|0 ;
  ENDIF ;

  SIGF = STDC(M) ;
  VSIGF[IT] = SIGF ;
  VSNRLO[IT] = SIGF / .02 ;
  VSNRHI[IT] = SIGF / .1 ;

  IT = IT + 1 ;
ENDO ;

OUTPUT FILE = WV2SNR.OUT RESET ;

  FORMAT /RD 15,3 ;
  "         Target          sig(f)         SNR, Lo          SNR, Hi" ;
  SEQA(ITS,1,ITE)~VSIGF~VSNRLO~VSNRHI ;
OUTPUT OFF ;


END ;
