"GAUSS PROGRAM WV2SPE1.PRG" ;
/*  FOR THE SECOND GENERATION WAVELET STUDY,
THIS WINDOWS PLOTS OF VARIOUS WAYS OF STUDYING SPECTRA  */


LIBRARY PGRAPH ;
GRAPHSET ;

AUTOP = 2 ;         /*  0 TO VIEW ON SCREEN   */
                    /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                    /*  2 TO WRITE AS POSTSCRIPT FILES  */

VIBASIS = 1|5|7|8 ;
VIBASIS = 2|3|4|6 ;
                    /*  1 - HAAR    */
                    /*  2 - DAUBECHIES 4    */
                    /*  3 - DAUBECHIES 6    */
                    /*  4 - SYMMLET 6    */
                    /*  5 - SYMMLET 8    */
                    /*  6 - COIFLET 2    */
                    /*  7 - COIFLET 3    */
                    /*  8 - FOURIER    */

N = 256 ;           /*   SAMPLE SIZE  = NUMBER OF GRID POINTS   */
                    /*   MUST BE A POWER OF 2  */

ITARGET = 0 ;       /*   0 - LOOP THROUGH ALL    */
                    /*   1 - STEP       */
                    /*   2 - WAVE       */
                    /*   3 - BLIP       */
                    /*   4 - BLOCKS     */
                    /*   5 - BUMPS      */
                    /*   6 - HEAVSI     */
                    /*   7 - DOPPL      */
                    /*   8 - ANGLES     */
                    /*   9 - PARABS     */
                    /*   10 - SHSIN     */

IPLOT = 2 ;         /*  1 - RAW SCALE  */
                    /*  2 - LOG SCALE  */
                    /*  3 - SQRT SCALE  */


NSTR = FTOS(N,"%*.*lf",1,0) ;
DELX = 1 / N ;
XGRID = SEQA(DELX/2,DELX,N) ;

                  /*  SET GRAPHICS STUFF  */
VX = 20000 ;
VY = 10000 ;
VZ = 10000 ;
VIEW(VX,VY,VZ) ;

                  /*  SET UP LOOPING STUFF  */
IF ITARGET == 0 ;
  ITS = 1 ;
  ITE = 10 ;
ELSE ;
  ITS = ITARGET ;
  ITE = ITARGET ;
ENDIF ;

NB = ROWS(VIBASIS) ;



IT = ITS ;      /*  LOOP THROUGH TARGET FUNCTIONS  */
DO WHILE IT <= ITE ;

  IF IT == 1 ;
    TARSTR = "Step" ;
    M = 0.2 ;      /*  BASE HEIGHT  */
    M = M + (1/3 .< XGRID) .* (XGRID .< .75) * .6 ;
                   /*  RAISE BY .4 ON THIS INTERVAL  */
  ELSEIF IT == 2 ;
    TARSTR = "Wave" ;
    M = .2 * COS(XGRID * 2 * PI * 2) + .5 ;
    M = M + .1 * COS(XGRID * 2 * PI * 12) ;
  ELSEIF IT == 3 ;
    TARSTR = "Blip" ;
    M = .6 * XGRID + .2 ;
    M = M + .3 * EXP(-100 * (XGRID - .5) .* (XGRID - .5)) ;
      RM = ROWS(M) ;
    M = M[(RM/5)+1:RM]|M[1:RM/5] ;
                   /*  ROTATE SO DISCONT NOT AT EDGE  */
  ELSEIF IT == 4 ;
    TARSTR = "Blocks" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|-5|3|-4|5|-4.2|2.1|4.3|-3.1|2.1|-4.2 ;
    M = XGRID' - T ;
      FLAG = M .> 0 ;
      FLAG0 = M .== 0 ;
    M = FLAG - (1 - FLAG - FLAG0) ;       /*  GIVES SGN(M)  */
    M = (1 + M) / 2 ;
    M = H .* M ;
    M = SUMC(M) ;               /*  THIS IS NOW DJ'S BLOCKS   */
    M = (.6 / 9.2) * (M + 2) + .2 ;  /*  RESCALED TO [.2,.8]  */
  ELSEIF IT == 5 ;
    TARSTR = "Bumps" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|5|3|4|5|4.2|2.1|4.3|3.1|5.1|4.2 ;
      W = .005|.005|.006|.01|.01|.03|.01|.01|.005|.008|.005 ;
    M = (XGRID' - T) ./ W ;
    M = 1 ./ (1 + ABS(M))^4 ;
    M = H .* M ;
    M = SUMC(M) ;                  /*  THIS IS NOW DJ'S BUMPS   */
    M = (.6/5.3437952) * M + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF IT == 6 ;
    TARSTR = "HeavSi" ;
    M = 4 * SIN(4 * PI * XGRID) ;
      FLAG = XGRID .> .3 ;
      FLAG0 = XGRID .== .3 ;
    M = M - (FLAG - (1 - FLAG - FLAG0)) ;
      FLAG = XGRID .> .72 ;
      FLAG0 = XGRID .== .72 ;
    M = M + (FLAG - (1 - FLAG - FLAG0)) ;  /*  DJ'S HEAVY SINE  */
    M = (.6 / 9) * (M + 5) + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF IT == 7 ;
    TARSTR = "Doppl" ;
    M = SQRT(XGRID .* (1 - XGRID)) ;
    M = M .* SIN(2 * PI * 1.05 ./ (XGRID + .05)) ; /* DJ'S DOPPLER */
    M = (.6 / 1) * (M + .5) + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF IT == 8 ;
    TARSTR = "Angles" ;
    M = (XGRID .<= .15) .* (2 * XGRID + .5) ;
    M = M + (.15 .< XGRID) .* (XGRID .<= .2) .* (-12 * (XGRID-.15) + .8) ;
    M = M + (.2 .< XGRID) .* (XGRID .<= .5) .* (.2)  ;
    M = M + (.5 .< XGRID) .* (XGRID .<= .6) .* (6 * (XGRID-.5) + .2) ;
    M = M + (.6 .< XGRID) .* (XGRID .<= .65) .* (-10 * (XGRID-.6) + .8) ;
    M = M + (.65 .< XGRID) .* (XGRID .<= .85) .* (-1/2 * (XGRID-.65)+.3) ;
    M = M + (.85 .< XGRID) .* (2 * (XGRID -.85) + .2)  ;
  ELSEIF IT == 9 ;
    TARSTR = "Parabs" ;
    M = .8 .* ONES(N,1) ;
    M = M + (.1 .< XGRID) .* (-30 .* (XGRID - .1)^2) ;
    M = M + (.2 .< XGRID) .* (60 .* (XGRID - .2)^2) ;
    M = M + (.3 .< XGRID) .* (-30 .* (XGRID - .3)^2) ;
    M = M + (.35 .< XGRID) .* (500 .* (XGRID - .35)^2) ;
    M = M + (.37 .< XGRID) .* (-1000 .* (XGRID - .37)^2) ;
    M = M + (.41 .< XGRID) .* (1000 .* (XGRID - .41)^2) ;
    M = M + (.43 .< XGRID) .* (-500 .* (XGRID - .43)^2) ;
    M = M + (.5 .< XGRID) .* (7.5 .* (XGRID - .5)^2) ;
    M = M + (.7 .< XGRID) .* (-15 .* (XGRID - .7)^2) ;
    M = M + (.9 .< XGRID) .* (7.5 .* (XGRID - .9)^2) ;
  ELSEIF IT == 10 ;
    TARSTR = "TShSin" ;
    TXGRID = (1 - COS(PI .* XGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 4 + XGRID / 2 ;
    M = .3 * SIN(6 .* PI .* TXGRID) + .5 ;
  ENDIF ;

  MOUT = ZEROS(N,NB) ;
  MREM = ZEROS(N,NB) ;

  BEGWIND ;
  WINDOW(2,3,0) ;

  IB = 1 ;      /*  LOOP THROUGH BASES  */
  DO WHILE IB <= NB ;
    IBAS = VIBASIS[IB] ;

    IF IB == 1 ;
      SETWIND(1) ;
    ELSEIF IB == 2 ;
      SETWIND(2) ;
    ELSEIF IB == 3 ;
      SETWIND(4) ;
    ELSEIF IB == 4 ;
      SETWIND(5) ;
    ENDIF ;


    IF IBAS <= 7 ;
      IF IBAS == 1 ;
        ITYPE = 1 ;
        IPAR = 0 ;
        BASTR = "Haar" ;
      ELSEIF IBAS == 2 ;
        ITYPE = 2 ;
        IPAR = 4 ;
        BASTR = "Daub4" ;
      ELSEIF IBAS == 3 ;
        ITYPE = 2 ;
        IPAR = 6 ;
        BASTR = "Daub6" ;
      ELSEIF IBAS == 4 ;
        ITYPE = 3 ;
        IPAR = 6 ;
        BASTR = "Symm6" ;
      ELSEIF IBAS == 5 ;
        ITYPE = 3 ;
        IPAR = 8 ;
        BASTR = "Symm8" ;
      ELSEIF IBAS == 6 ;
        ITYPE = 4 ;
        IPAR = 2 ;
        BASTR = "Coif2" ;
      ELSEIF IBAS == 7 ;
        ITYPE = 4 ;
        IPAR = 3 ;
        BASTR = "Coif3" ;
      ENDIF ;

              /*  GET WAVELET COEFFS OF TARGET  */
      COEFFS = WV2D1(M,ITYPE,IPAR,-1) ;
                    /*  RECALL -1 GIVES LOWEST LEVEL POSSIBLE  */
      COEFFS = ABS(COEFFS) ;

      IF IPLOT == 1 ;
        PSTR = "Abs(Coeffs)" ;
        OUT = COEFFS ;
      ELSEIF IPLOT == 2 ;
        PSTR = "Log]10[(Abs(Coeffs))" ;
        FLAG = (COEFFS .> 10^(-5)) ;
        COEFFS = COEFFS .* FLAG + (1 - FLAG) .* 10^(-5) ;
        OUT = LOG(COEFFS) ;
      ELSEIF IPLOT == 3 ;
        PSTR = "Sqrt(Abs(Coeffs))" ;
        PSTR = "Square Root" ;
        OUT = SQRT(COEFFS) ;
      ENDIF ;


            /*  CREATE MATRIX FOR DISPLAYING SPECTRUM IN 3 SPACE  */
      MSPECT = OUT[(N/2)+1:N] ;    /*  HIGHEST FREQ */
      L2N = ROUND(LOG(N) / LOG(2)) ;
      J = L2N - 2 ;
      DO WHILE J >= 0 ;
        MSPECT = (OUT[(2^J)+1:2^(J+1)] .*. ONES(2^(L2N-J-1),1))~MSPECT ;
        J = J - 1 ;
      ENDO ;

          _PLEGCTL = 0 ;
          XLABEL("") ;
          YLABEL("") ;
          ZLABEL(PSTR) ;
          TITSTR = BASTR ;
          TITSTR = TITSTR$+" Spectrum for "$+TARSTR$+" Regression" ;
        TITLE(TITSTR) ;
      SURFACE(SEQA(1,1,COLS(MSPECT))',SEQA(1,1,ROWS(MSPECT)),MSPECT) ;


    ELSEIF IBAS == 8 ;
      BASTR = "Fourier" ;

      COEFFS = WVFFTD(M) ;
      COEFFS = ABS(COEFFS) ;

      IF IPLOT == 1 ;
        PSTR = "Abs(Coeffs)" ;
        OUT = COEFFS ;
      ELSEIF IPLOT == 2 ;
        PSTR = "Log]10[(Abs(Coeffs))" ;
        FLAG = (COEFFS .> 10^(-5)) ;
        COEFFS = COEFFS .* FLAG + (1 - FLAG) .* 10^(-5) ;
        OUT = LOG(COEFFS) ;
      ELSEIF IPLOT == 3 ;
        PSTR = "Sqrt(Abs(Coeffs))" ;
        OUT = SQRT(COEFFS) ;
      ENDIF ;

          _PLEGCTL = 0 ;
          XLABEL("") ;
          YLABEL(PSTR) ;
          TITSTR = BASTR ;
          TITSTR = TITSTR$+" Spectrum for "$+TARSTR$+" Regression" ;
        TITLE(TITSTR) ;
      XY(XGRID,OUT) ;

    ENDIF ;

    MREM[.,IB] = SORTC(COEFFS^2,1) ;
    MOUT[.,IB] = SORTC(OUT,1) ;

    IF IB == 1 ;
      _PLEGSTR = BASTR ;
    ELSE ;
      _PLEGSTR = _PLEGSTR$+""$+BASTR ;
           /*  FOR SOME REASON (NOT UNDERSTOOD), THIS WORKS, AND PUTTING
               /000 IN THE QUOTES DOESN'T   */
    ENDIF ;

    IB = IB + 1 ;
  ENDO ;



  SETWIND(3) ;

  MOUT = REV(MOUT) ;    /*  PUT IN DECREASING ORDER  */

    YLABEL(PSTR) ;
      TITSTR = "Sorted Spectra for "$+TARSTR$+" Regression" ;
    TITLE(TITSTR) ;
    _PLEGCTL = 1 ;
  XY(XGRID,MOUT) ;


  SETWIND(6) ;

  MREM = CUMSUMC(MREM) ;
  MREM = REV(MREM) ;    /*  PUT IN DECREASING ORDER  */
  MREM = LOG(MREM) ;

    _PDATE = "From WV2SPE1.PRG     " ;
    YTICS(-5,2,1,1) ;
    XLABEL("Proportion of Coeffs") ;
    YLABEL("log]10[(Power)") ;
    _PLEGCTL = 1 ;
      TITSTR = "`Power Remaining' for "$+TARSTR$+" Regression" ;
    TITLE(TITSTR) ;
  XY(XGRID,MREM) ;



  IF AUTOP == 1 ;
      PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\SPE1" ;
      PRSTR = PRSTR$+FTOS(IT,"%*.*lf",1,0) ;
      PRSTR = PRSTR$+".PLT" ;
    GRAPHPRT(PRSTR) ;
  ELSEIF AUTOP == 2 ;
      PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\SPE1" ;
      PRSTR = PRSTR$+FTOS(IT,"%*.*lf",1,0) ;
      PRSTR = PRSTR$+".PS" ;
    GRAPHPRT(PRSTR) ;
  ENDIF ;


  ENDWIND ;


  IT = IT + 1 ;
ENDO ;



END ;
