"GAUSS PROGRAM WV2TAR2.PRG" ;
/*   THIS IS FOR CHECKING THE PARAMETRIZATIONS OF THE
TARGET FUNCTIONS TYPED INTO THE JOHNSTONE, MARRON, NEUMANN, PATIL PAPER    */
/*  COPIED FROM WV2TAR1.PRG
2ND GENERATION WAVELET INVESTIGATION
FOR SHOWING TARGET FUNCTIONS AND NOISY DATA  */




N = 256 ;          /*   SAMPLE SIZE  = NUMBER OF GRID POINTS   */


ITARGET = 0 ;       /*   0 - LOOP THROUGH ALL    */
                    /*   1 - STEP       */
                    /*   2 - WAVE       */
                    /*   3 - BLIP       */
                    /*   4 - BLOCKS     */
                    /*   5 - BUMPS      */
                    /*   6 - HEAVSI     */
                    /*   7 - DOPPL      */
                    /*   8 - ANGLES     */
                    /*   9 - PARABS     */
                    /*   10 - SHSIN     */





NSTR = FTOS(N,"%*.*lf",1,0) ;
DELX = 1 / N ;
XGRID = SEQA(DELX/2,DELX,N) ;


                  /*  SET UP LOOPING STUFF  */
IF ITARGET == 0 ;
  ITS = 1 ;
  ITE = 10 ;
ELSE ;
  ITS = ITARGET ;
  ITE = ITARGET ;
ENDIF ;




IT = ITS ;      /*  LOOP THROUGH TARGET FUNCTIONS  */
DO WHILE IT <= ITE ;

      /*  HERE ARE PARAMETRIZATIONS USED IN PROGRAMS  */
  IF IT == 1 ;
    TARSTR = "Step" ;
    M = 0.2 ;      /*  BASE HEIGHT  */
    M = M + (1/3 .< XGRID) .* (XGRID .< .75) * .6 ;
                   /*  RAISE BY .4 ON THIS INTERVAL  */
    _PLEGCTL = 1|4|.37|0 ;
  ELSEIF IT == 2 ;
    TARSTR = "Wave" ;
    M = .2 * COS(XGRID * 2 * PI * 2) + .5 ;
    M = M + .1 * COS(XGRID * 2 * PI * 12) ;
    _PLEGCTL = 1|4|0.61|.8 ;
  ELSEIF IT == 3 ;
    TARSTR = "Blip" ;
    M = .6 * XGRID + .2 ;
    M = M + .3 * EXP(-100 * (XGRID - .5) .* (XGRID - .5)) ;
      RM = ROWS(M) ;
    M = M[(RM/5)+1:RM]|M[1:RM/5] ;
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 4 ;
    TARSTR = "Blocks" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|-5|3|-4|5|-4.2|2.1|4.3|-3.1|2.1|-4.2 ;
    M = XGRID' - T ;
      FLAG = M .> 0 ;
      FLAG0 = M .== 0 ;
    M = FLAG - (1 - FLAG - FLAG0) ;       /*  GIVES SGN(M)  */
    M = (1 + M) / 2 ;
    M = H .* M ;
    M = SUMC(M) ;                     /*  THIS IS NOW DJ'S BLOCKS   */
    M = (.6 / 9.2) * (M + 2) + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 5 ;
    TARSTR = "Bumps" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|5|3|4|5|4.2|2.1|4.3|3.1|5.1|4.2 ;
      W = .005|.005|.006|.01|.01|.03|.01|.01|.005|.008|.005 ;
    M = (XGRID' - T) ./ W ;
    M = 1 ./ (1 + ABS(M))^4 ;
    M = H .* M ;
    M = SUMC(M) ;                     /*  THIS IS NOW DJ'S BUMPS   */
    M = (.6/5.3437952) * M + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 6 ;
    TARSTR = "HeavSi" ;
    M = 4 * SIN(4 * PI * XGRID) ;
      FLAG = XGRID .> .3 ;
      FLAG0 = XGRID .== .3 ;
    M = M - (FLAG - (1 - FLAG - FLAG0)) ;
      FLAG = XGRID .> .72 ;
      FLAG0 = XGRID .== .72 ;
    M = M + (FLAG - (1 - FLAG - FLAG0)) ;     /*  DJ'S HEAVY SINE  */
    M = (.6 / 9) * (M + 5) + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 7 ;
    TARSTR = "Doppl" ;
    M = SQRT(XGRID .* (1 - XGRID)) ;
    M = M .* SIN(2 * PI * 1.05 ./ (XGRID + .05)) ;   /*  DJ'S DOPPLER   */
    M = (.6 / 1) * (M + .5) + .2 ;      /*  RESCALED TO [.2,.8]  */
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 8 ;
    TARSTR = "Angles" ;
    M = (XGRID .<= .15) .* (2 * XGRID + .5) ;
    M = M + (.15 .< XGRID) .* (XGRID .<= .2) .* (-12 * (XGRID -.15) + .8)  ;
    M = M + (.2 .< XGRID) .* (XGRID .<= .5) .* (.2)  ;
    M = M + (.5 .< XGRID) .* (XGRID .<= .6) .* (6 * (XGRID -.5) + .2)  ;
    M = M + (.6 .< XGRID) .* (XGRID .<= .65) .* (-10 * (XGRID -.6) + .8)  ;
    M = M + (.65 .< XGRID) .* (XGRID .<= .85) .* (-1/2 * (XGRID -.65) + .3) ;
    M = M + (.85 .< XGRID) .* (2 * (XGRID -.85) + .2)  ;
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 9 ;
    TARSTR = "Parabs" ;
    M = .8 .* ONES(N,1) ;
    M = M + (.1 .< XGRID) .* (-30 .* (XGRID - .1)^2) ;
    M = M + (.2 .< XGRID) .* (60 .* (XGRID - .2)^2) ;
    M = M + (.3 .< XGRID) .* (-30 .* (XGRID - .3)^2) ;
    M = M + (.35 .< XGRID) .* (500 .* (XGRID - .35)^2) ;
    M = M + (.37 .< XGRID) .* (-1000 .* (XGRID - .37)^2) ;
    M = M + (.41 .< XGRID) .* (1000 .* (XGRID - .41)^2) ;
    M = M + (.43 .< XGRID) .* (-500 .* (XGRID - .43)^2) ;
    M = M + (.5 .< XGRID) .* (7.5 .* (XGRID - .5)^2) ;
    M = M + (.7 .< XGRID) .* (-15 .* (XGRID - .7)^2) ;
    M = M + (.9 .< XGRID) .* (7.5 .* (XGRID - .9)^2) ;
    _PLEGCTL = 1|4|.6|0 ;
  ELSEIF IT == 10 ;
    TARSTR = "TShSin" ;
    TXGRID = (1 - COS(PI .* XGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 4 + XGRID / 2 ;
    M = .3 * SIN(6 .* PI .* TXGRID) + .5 ;
    _PLEGCTL = 1|4|.6|0 ;
  ENDIF ;

  MPROG = M ;





    /*  HERE COME PARAMETRIZATIONS USED IN PAPER  */
/*
   first define the sign function
      sgn(x)=1_{(0,\infty )}(x)-1_{(-\infty ,0)}(x),
*/
PROC SGN(X) ;
  LOCAL FLAG ;
  FLAG = (X .> 0) ;
  FLAG = FLAG - (X .< 0) ;
  RETP(FLAG) ;
ENDP ;

/*
   then define a shifted version
      ssgn(x)=\left( 1+sgn(x)\right) /2,
*/
PROC SSGN(X) ;
  RETP((1 + SGN(X)) / 2) ;
ENDP ;

/*
   first define $K_w(x)=( 1+| \frac xw| ^{-4}$,
*/
PROC K(W,X) ;
  RETP((1 + ABS(X ./ W))^(-4)) ;
ENDP ;

/*
first define the ``quadratic ramp function''
   $r_2(x,c)=(x-c)^21_{(c,1]}(x)$,
*/
PROC R2(X,C) ;
  RETP(((X - C)^2) .* (C .< X)) ;
ENDP ;

/*
first define the transformation
   g(x)=( 1 - cos ( pi x) ) / 2,
*/
PROC G(X) ;
  RETP((1 - COS(PI * X)) / 2) ;
ENDP ;


  IF IT == 1 ;
    TARSTR = "Step" ;
    M = 0.2 + 0.6 * ((XGRID .> 1/3) .* (XGRID .< 0.75)) ;
/*
m_1(x)=0.2+\left( 0.6\right) 1_{(\frac 13,0.75)}(x)
*/

  ELSEIF IT == 2 ;
    TARSTR = "Wave" ;
    M = 0.5 + 0.2 * cos (4 * pi * XGRID) + 0.1 * cos (24 * pi * XGRID) ;
/*
m_2(x)=0.5+(0.2)\cos (4\pi x)+(0.1)\cos (24\pi x)
*/

  ELSEIF IT == 3 ;
    TARSTR = "Blip" ;
    M = (0.32 + 0.6 * XGRID + 0.3 * EXP(-100 * (XGRID - 0.3)^2))
                   .* (XGRID .<= 0.8) +
        (-0.28 + 0.6 * XGRID + 0.3 * EXP(-100 * (XGRID - 1.3)^2))
                    .* (XGRID .> 0.8) ;
/*
m_3(x)= 0.32+0.6x+0.3e^{-100(x-0.3)^2} 1_{[0,0.8]}+
        -0.28+0.6x+0.3e^{-100(x-1.3)^2} 1_{(0.8,1]}
*/


  ELSEIF IT == 4 ;
    TARSTR = "Blocks" ;
    M = (0.6 / 9.2) * (4 * SSGN(XGRID-0.1) - 5 * SSGN(XGRID-0.13) +
           3 * SSGN(XGRID-0.15) - 4 * SSGN(XGRID-0.23)
                                           + 5 * SSGN(XGRID-0.25)
           - 4.2 * SSGN(XGRID-0.4) + 2.1 * SSGN(XGRID-0.44)
                                           + 4.3 * SSGN(XGRID-0.65)
           - 3.1 * SSGN(XGRID-0.76) + 2.1 * SSGN(XGRID-0.78)
                                           - 4.2 * SSGN(XGRID-0.81) + 2) + 0.2 ;
/*
This is Donoho and Johnstone's Blocks,
   vertically rescaled to $[0.2,0.8]$,
 m_4(x)=( \frac{0.6}{9.2}) { 4ssgn(x-0.1)-5ssgn(x-0.13)+
           3ssgn(x-0.15)-4ssgn(x-0.23)+5ssgn(x-0.25)
           -4.2ssgn(x-0.4)+2.1ssgn(x-0.44)+4.3ssgn(x-0.65)
           -3.1ssgn(x-0.76)+2.1ssgn(x-0.78)-4.2ssgn(x-0.81)} +0.2
*/

  ELSEIF IT == 5 ;
    TARSTR = "Bumps" ;
    M = (0.6 / 5.3437952) * (4 * K(0.005,XGRID-0.1)
          + 5 * K(0.005,XGRID-0.13)
          + 3 * K(0.006,XGRID-0.15) + 4 * K(0.01,XGRID-0.23)
          + 5 * K(0.01,XGRID-0.25) + 4.2 * K(0.03,XGRID-0.4)
          + 2.1 * K(0.01,XGRID-0.44) + 4.3 * K(0.01,XGRID-0.65)
          + 3.1 * K(0.005,XGRID-0.76) + 5.1 * K(0.008,XGRID-0.78)
          + 4.2 * K(0.005,XGRID-0.81)) + 0.2 ;
/*
This is Donoho and Johnstone's Bumps,
   vertically rescaled to approximately $[0.2,0.8]$
 m_5(x)= ( \frac{0.6}{5.3437952}) {4K_{0.005}(x-0.1)
          +5K_{0.005}(x-0.13)+
          +3K_{0.006}(x-0.15)+4K_{0.01}(x-0.23)+
          +5K_{0.01}(x-0.25)+4.2K_{0.03}(x-0.4)+
          +2.1K_{0.01}(x-0.44)+4.3K_{0.01}(x-0.65)+
          +3.1K_{0.005}(x-0.76)+5.1K_{0.008}(x-0.78)+
          +4.2K_{0.005}(x-0.81)\right\} +0.2
*/

  ELSEIF IT == 6 ;
    TARSTR = "HeavSi" ;
    M = (0.6 / 9) * ( 4 * sin (4 * pi * XGRID)
            + 5 - SGN(XGRID-0.3) + SGN(XGRID-0.72)) + 0.2 ;
/*
This is Donoho and Johnstone's HeaviSine,
   vertically rescaled to $[0.2,0.8]$,
m_6(x)=( \frac{0.6}9) ( 4\sin ( 4\pi x) +
            + 5-sgn(x-0.3)+sgn(x-0.72) +0.2
*/

  ELSEIF IT == 7 ;
    TARSTR = "Doppl" ;
    M = 0.6 * (sqrt(XGRID .* (1-XGRID)) .* sin ( (2.1 * pi) ./ (XGRID+0.05) )
                                             + 0.5) + 0.2 ;
/*
This is Donoho and Johnstone's Doppler,
   vertically rescaled to $[0.2,0.8]
m_7(x)=0.6( \sqrt{x(1-x)}\sin ( \frac{2.1\pi }{x+0.05}) +0.5) +0.2
*/

  ELSEIF IT == 8 ;
    TARSTR = "Angles" ;
    M = (2 * XGRID + 0.5)
                .* (XGRID .<= 0.15)
        + (-12 * (XGRID-0.15) + 0.8)
                .* (0.15 .< XGRID) .* (XGRID .<= 0.2)
        + (0.2)
                 .* (0.2 .< XGRID) .* (XGRID .<= 0.5)
        + (6 * (XGRID-.5) + 0.2)
                 .* (0.5 .< XGRID) .* (XGRID .<= 0.6)
        + (-10 * (XGRID-.6) + 0.8)
                 .* (0.6 .< XGRID) .* (XGRID .<= 0.65)
        + (-0.5 * (XGRID-.65) + 0.3)
                 .* (0.65 .< XGRID) .* (XGRID .<= 0.85)
        + (2 * (XGRID-.85) + 0.2)
                 .* (0.85 .< XGRID) .* (XGRID .<= 1) ;
/*
m_8(x)= ( 2x+0.5) 1_{[0,0.15]}(x)
        +( -12(x-0.15)+0.8\right) 1_{(0.15,0.2]}(x)
        +( 0.2\right) 1_{(0.2,0.5]}(x)
        +( 6(x-.5)+0.2\right) 1_{(0.5,0.6]}(x)+
        +( -10(x-.6)+0.8\right) 1_{(0.6,0.65]}(x)
        +( -0.5(x-.65)+0.3) 1_{(0.65,0.85]}(x)+
        +( 2(x-.85)+0.2\right) 1_{(0.85,1]}(x).
*/

  ELSEIF IT == 9 ;
    TARSTR = "Parabs" ;
    M = 0.8 - 30 * R2(XGRID,0.1) + 60 * R2(XGRID,0.2)
                           - 30 * R2(XGRID,0.3)
        + 500 * R2(XGRID,0.35) - 1000 * R2(XGRID,0.37)
        + 1000 * R2(XGRID,0.41) - 500 * R2(XGRID,0.43)
        + 7.5 * R2(XGRID,0.5) - 15 * R2(XGRID,0.7)
                           + 7.5 * R2(XGRID,0.9) ;
/*
m_9(x)=0.8-30r_2(x,0.1)+60r_2(x,0.2)-30r_2(x,0.3)+
        +500r_2(x,0.35)-1000r_2(x,0.37)+
        +1000r_2(x,0.41)-500r_2(x,0.43)+
        +7.5r_2(x,0.5)-15r_2(x,0.7)+7.5r_2(x,0.9)
*/

  ELSEIF IT == 10 ;
    TARSTR = "TShSin" ;
    M = 0.3 * sin ( 3 * pi * ( g( g( g( g(XGRID) ) ) )
                              + XGRID) ) + 0.5 ;
/*
m_{10}(x)=0.3\sin { 3 pi [ g( g( g( g(x) ) ) ) +x] } + 0.5
*/

  ENDIF ;






  MPAP = M ;

  ADIFF = ABS(MPROG - MPAP) ;

    FORMAT /RD 15,12 ;
  "FOR " TARSTR ;
  "BIGGEST DIFFERENCE WAS: "  MAXC(ADIFF) ;
  "ANY KEY TO CONT.   " ; WAIT ;
  ? ; ? ;


  IT = IT + 1 ;
ENDO ;

END ;
