"GAUSS PROGRAM WV2TT1.PRG " ;
/*  MAKES TRANSPARENCIES FOR TALK BASED ON WV2EG1.PRG
2ND GENERATION WAVELET INVESTIGATION
FOR SHOWING TARGET FUNCTIONS AND NOISY DATA
PLUS SOME WAVELET SMOOTHS   */

LIBRARY PGRAPH ;
GRAPHSET ;

AUTOP = 2 ;       /*  0 TO VIEW ON SCREEN   */
                  /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                  /*  2 TO WRITE AS POSTSCRIPT FILES  */

IEG = 8 ;          /*  1,2,3,4,5,6,7,8   */


IF IEG == 1 ;
  IT = 2 ;   /*  TARGET NUMBER  */
  IS = 2 ;   /*  SIGMA NUMBER  */
  VIBASIS = 1|5|8 ;       /*  LOOP THROUGH ENTRIES OF THIS VECTOR  */
  VJ0 = 6|6|6 ;
  ITH = 1 ;   /*  THRESHOLD TYPE AND VALUE  */
ELSEIF IEG == 2 ;
  IT = 1 ;   /*  TARGET NUMBER  */
  IS = 1 ;   /*  SIGMA NUMBER  */
  VIBASIS = 1|5|8 ;       /*  LOOP THROUGH ENTRIES OF THIS VECTOR  */
  VJ0 = 2|6|6 ;
  ITH = 1 ;   /*  THRESHOLD TYPE AND VALUE  */
ELSEIF IEG == 3 ;
  IT = 3 ;   /*  TARGET NUMBER  */
  IS = 2 ;   /*  SIGMA NUMBER  */
  VIBASIS = 1|5|8 ;       /*  LOOP THROUGH ENTRIES OF THIS VECTOR  */
  VJ0 = 5|5|6 ;
  ITH = 1 ;   /*  THRESHOLD TYPE AND VALUE  */
ELSEIF IEG == 4 ;
  IT = 10 ;   /*  TARGET NUMBER  */
  IS = 2 ;   /*  SIGMA NUMBER  */
  VIBASIS = 1|5|8 ;       /*  LOOP THROUGH ENTRIES OF THIS VECTOR  */
  VJ0 = 6|5|5 ;
  ITH = 1 ;   /*  THRESHOLD TYPE AND VALUE  */
ELSEIF IEG == 5 ;
  IT = 5 ;   /*  TARGET NUMBER  */
  IS = 1 ;   /*  SIGMA NUMBER  */
  VIBASIS = 1|5|8 ;       /*  LOOP THROUGH ENTRIES OF THIS VECTOR  */
  VJ0 = 6|6|6 ;
  ITH = 1 ;   /*  THRESHOLD TYPE AND VALUE  */
ELSEIF IEG == 6 ;
  IT = 5 ;   /*  TARGET NUMBER  */
  IS = 1 ;   /*  SIGMA NUMBER  */
  VIBASIS = 1|5|8 ;       /*  LOOP THROUGH ENTRIES OF THIS VECTOR  */
  VJ0 = 5|5|5 ;
  ITH = 3 ;   /*  THRESHOLD TYPE AND VALUE  */
ELSEIF IEG == 7 ;
  IT = 8 ;   /*  TARGET NUMBER  */
  IS = 1 ;   /*  SIGMA NUMBER  */
  VIBASIS = 1|5|8|2 ;       /*  LOOP THROUGH ENTRIES OF THIS VECTOR  */
  VJ0 = 6|5|5|5 ;
  ITH = 1 ;   /*  THRESHOLD TYPE AND VALUE  */
ELSEIF IEG == 8 ;
  IT = 1 ;   /*  TARGET NUMBER  */
  IS = 1 ;   /*  SIGMA NUMBER  */
  VIBASIS = 1 ;       /*  LOOP THROUGH ENTRIES OF THIS VECTOR  */
  VJ0 = 5 ;
  ITH = 4 ;   /*  THRESHOLD TYPE AND VALUE  */
ENDIF ;


/* TARGETS:              1 - STEP       */
                    /*   2 - WAVE       */
                    /*   3 - BLIP       */
                    /*   4 - BLOCKS     */
                    /*   5 - BUMPS      */
                    /*   6 - HEAVSI     */
                    /*   7 - DOPPL      */
                    /*   8 - ANGLES     */
                    /*   9 - PARABS     */
                    /*   10 - SHSIN     */

/* SIGMAS:               1 - "LOW NOISE"       */
                    /*   2 - "HIGH NOISE"       */

/* BASES:               1 - HAAR    */
                    /*  2 - DAUBECHIES 4    */
                    /*  3 - DAUBECHIES 6    */
                    /*  4 - SYMMLET 6    */
                    /*  5 - SYMMLET 8    */
                    /*  6 - COIFLET 2    */
                    /*  7 - COIFLET 3    */
                    /*  8 - FOURIER    */

/*  THRESHOLDS          1 - HARD, DENOISING  */
                    /*  2 - SOFT, DENOISING  */
                    /*  3 - SOFT, DJMO    */
                    /*  4 - PROJECTION   */

N = 1024 ;          /*   SAMPLE SIZE  = NUMBER OF GRID POINTS   */
                    /*   MUST BE A POWER OF 2  */



NSTR = FTOS(N,"%*.*lf",1,0) ;
DELX = 1 / N ;
XGRID = SEQA(DELX/2,DELX,N) ;

                  /*  SET GRAPHICS STUFF  */
FONTS("SIMPLEX SIMGRMA" ) ;
_PLWIDTH = 5 ;
_PSTYPE = 4 ;
_PTITLHT = .2 ;
_PLEGCTL = 0 ;
_PSYMSIZ = 2 ;
_PDATE = "" ;
  LEFT = 0 ;
  RIGHT = 1 ;
  XSTEP = .2 ;
  XMSD = 2 ;
XTICS(LEFT,RIGHT,XSTEP,XMSD) ;
  BOTTOM = 0 ;
  TOP = 1 ;
  YSTEP = .2 ;
  YMSD = 2 ;
YTICS(BOTTOM,TOP,YSTEP,YMSD) ;



NB = ROWS(VIBASIS) ;




IF IT == 1 ;
  TARSTR = "Step" ;
  M = 0.2 ;      /*  BASE HEIGHT  */
  M = M + (1/3 .< XGRID) .* (XGRID .< .75) * .6 ;
                 /*  RAISE BY .4 ON THIS INTERVAL  */
ELSEIF IT == 2 ;
  TARSTR = "Wave" ;
  M = .2 * COS(XGRID * 2 * PI * 2) + .5 ;
  M = M + .1 * COS(XGRID * 2 * PI * 12) ;
ELSEIF IT == 3 ;
  TARSTR = "Blip" ;
  M = .6 * XGRID + .2 ;
  M = M + .3 * EXP(-100 * (XGRID - .5) .* (XGRID - .5)) ;
    RM = ROWS(M) ;
  M = M[(RM/5)+1:RM]|M[1:RM/5] ;
ELSEIF IT == 4 ;
  TARSTR = "Blocks" ;
    T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
    H = 4|-5|3|-4|5|-4.2|2.1|4.3|-3.1|2.1|-4.2 ;
  M = XGRID' - T ;
    FLAG = M .> 0 ;
    FLAG0 = M .== 0 ;
  M = FLAG - (1 - FLAG - FLAG0) ;       /*  GIVES SGN(M)  */
  M = (1 + M) / 2 ;
  M = H .* M ;
  M = SUMC(M) ;                     /*  THIS IS NOW DJ'S BLOCKS   */
  M = (.6 / 9.2) * (M + 2) + .2 ;      /*  RESCALED TO [.2,.8]  */
ELSEIF IT == 5 ;
  TARSTR = "Bumps" ;
    T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
    H = 4|5|3|4|5|4.2|2.1|4.3|3.1|5.1|4.2 ;
    W = .005|.005|.006|.01|.01|.03|.01|.01|.005|.008|.005 ;
  M = (XGRID' - T) ./ W ;
  M = 1 ./ (1 + ABS(M))^4 ;
  M = H .* M ;
  M = SUMC(M) ;                     /*  THIS IS NOW DJ'S BUMPS   */
  M = (.6/5.3437952) * M + .2 ;      /*  RESCALED TO [.2,.8]  */
ELSEIF IT == 6 ;
  TARSTR = "HeavSi" ;
  M = 4 * SIN(4 * PI * XGRID) ;
    FLAG = XGRID .> .3 ;
    FLAG0 = XGRID .== .3 ;
  M = M - (FLAG - (1 - FLAG - FLAG0)) ;
    FLAG = XGRID .> .72 ;
    FLAG0 = XGRID .== .72 ;
  M = M + (FLAG - (1 - FLAG - FLAG0)) ;     /*  DJ'S HEAVY SINE  */
  M = (.6 / 9) * (M + 5) + .2 ;      /*  RESCALED TO [.2,.8]  */
ELSEIF IT == 7 ;
  TARSTR = "Doppl" ;
  M = SQRT(XGRID .* (1 - XGRID)) ;
  M = M .* SIN(2 * PI * 1.05 ./ (XGRID + .05)) ;   /*  DJ'S DOPPLER   */
  M = (.6 / 1) * (M + .5) + .2 ;      /*  RESCALED TO [.2,.8]  */
ELSEIF IT == 8 ;
  TARSTR = "Angles" ;
  M = (XGRID .<= .15) .* (2 * XGRID + .5) ;
  M = M + (.15 .< XGRID) .* (XGRID .<= .2) .* (-12 * (XGRID -.15) + .8)  ;
  M = M + (.2 .< XGRID) .* (XGRID .<= .5) .* (.2)  ;
  M = M + (.5 .< XGRID) .* (XGRID .<= .6) .* (6 * (XGRID -.5) + .2)  ;
  M = M + (.6 .< XGRID) .* (XGRID .<= .65) .* (-10 * (XGRID -.6) + .8)  ;
  M = M + (.65 .< XGRID) .* (XGRID .<= .85) .* (-1/2 * (XGRID -.65) + .3) ;
  M = M + (.85 .< XGRID) .* (2 * (XGRID -.85) + .2)  ;
ELSEIF IT == 9 ;
  TARSTR = "Parabs" ;
  M = .8 .* ONES(N,1) ;
  M = M + (.1 .< XGRID) .* (-30 .* (XGRID - .1)^2) ;
  M = M + (.2 .< XGRID) .* (60 .* (XGRID - .2)^2) ;
  M = M + (.3 .< XGRID) .* (-30 .* (XGRID - .3)^2) ;
  M = M + (.35 .< XGRID) .* (500 .* (XGRID - .35)^2) ;
  M = M + (.37 .< XGRID) .* (-1000 .* (XGRID - .37)^2) ;
  M = M + (.41 .< XGRID) .* (1000 .* (XGRID - .41)^2) ;
  M = M + (.43 .< XGRID) .* (-500 .* (XGRID - .43)^2) ;
  M = M + (.5 .< XGRID) .* (7.5 .* (XGRID - .5)^2) ;
  M = M + (.7 .< XGRID) .* (-15 .* (XGRID - .7)^2) ;
  M = M + (.9 .< XGRID) .* (7.5 .* (XGRID - .9)^2) ;
ELSEIF IT == 10 ;
  TARSTR = "TShSin" ;
  TXGRID = (1 - COS(PI .* XGRID)) / 2 ;
  TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
  TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
  TXGRID = (1 - COS(PI .* TXGRID)) / 4 + XGRID / 2 ;
  M = .3 * SIN(6 .* PI .* TXGRID) + .5 ;
ENDIF ;


IF IS == 1 ;
  SIGSTR = "Low Noise" ;
  SIG = .02 ;
ELSEIF IS == 2 ;
  SIGSTR = "High Noise" ;
  SIG = .1 ;
ENDIF ;


TITSTR = TARSTR$+" Regression" ;
TITSTR = TITSTR$+",    "$+SIGSTR ;
TITSTR = TITSTR$+",    n = " ;
TITSTR = TITSTR$+FTOS(N,"%*.*lf",1,0) ;


IF AUTOP == 1 ;
    PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\TT1E" ;
    PRSTR = PRSTR$+FTOS(IEG,"%*.*lf",1,0)$+"P1.PLT" ;
  GRAPHPRT(PRSTR) ;
ELSEIF AUTOP == 2 ;
    PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\TT1E" ;
    PRSTR = PRSTR$+FTOS(IEG,"%*.*lf",1,0)$+"P1.PS" ;
  GRAPHPRT(PRSTR) ;
ENDIF ;

  _PLTYPE = 4 ;
  _PLCTRL = 0 ;
  TITLE(TITSTR) ;
XY(XGRID,M) ; ? ;




  SEED = 932485732 ;
Y = M + SIG * RNDNS(N,1,SEED) ;


IF AUTOP == 1 ;
    PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\TT1E" ;
    PRSTR = PRSTR$+FTOS(IEG,"%*.*lf",1,0)$+"P2.PLT" ;
  GRAPHPRT(PRSTR) ;
ELSEIF AUTOP == 2 ;
    PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\TT1E" ;
    PRSTR = PRSTR$+FTOS(IEG,"%*.*lf",1,0)$+"P2.PS" ;
  GRAPHPRT(PRSTR) ;
ENDIF ;

  _PLTYPE = 6 ;
  _PLCTRL = -1 ;
  TITLE(TITSTR) ;
XY(XGRID,Y) ; ? ;



IF ITH == 1 ;
  LAMSIG = SQRT(2 * LN(N)) * SIG ;      /*  DENOISING THRESHOLD VALUE  */
  THSTR = ", Hard, \202l\201]D[" ;
ELSEIF ITH == 2 ;
  LAMSIG = SQRT(2 * LN(N)) * SIG ;      /*  DENOISING THRESHOLD VALUE  */
  THSTR = ", Soft, \202l\201]D[" ;
ELSEIF ITH == 3 ;
  THSTR = ", Soft, \202l\201]MO[" ;
  IF N == 64 ;      /*  DJ MINIMAX OPTIMAL  */
    LAMBDA = 1.47391 ;
  ELSEIF N == 128 ;
    LAMBDA = 1.66865 ;
  ELSEIF N == 256 ;
    LAMBDA = 1.85982 ;
  ELSEIF N == 512 ;
    LAMBDA = 2.04748 ;
  ELSEIF N == 1024 ;
    LAMBDA = 2.23203 ;
  ELSEIF N == 2048 ;
    LAMBDA = 2.41405 ;
  ELSEIF N == 4096 ;
    LAMBDA = 2.59427 ;
  ELSEIF N == 8192 ;
    LAMBDA = 2.77343 ;
  ELSEIF N == 16384 ;
    LAMBDA = 2.95218 ;
  ELSEIF N == 32768 ;
    LAMBDA = 3.13093 ;
  ELSEIF N == 65536 ;
    LAMBDA = 3.30975 ;
  ENDIF ;
 LAMSIG = LAMBDA * SIG ;
ELSEIF ITH == 4 ;
  LAMSIG = 0 ;      /*  DENOISING THRESHOLD VALUE  */
  THSTR = ", Proj" ;
ENDIF ;


IB = 1 ;      /*  LOOP THROUGH BASES  */
DO WHILE IB <= NB ;
  IBAS = VIBASIS[IB] ;
  J0 = VJ0[IB] ;

  IF IBAS <= 7 ;
    IF IBAS == 1 ;
      ITYPE = 1 ;
      IPAR = 0 ;
      BASTR = "Haar" ;
    ELSEIF IBAS == 2 ;
      ITYPE = 2 ;
      IPAR = 4 ;
      BASTR = "Daub4" ;
    ELSEIF IBAS == 3 ;
      ITYPE = 2 ;
      IPAR = 6 ;
      BASTR = "Daub6" ;
    ELSEIF IBAS == 4 ;
      ITYPE = 3 ;
      IPAR = 6 ;
      BASTR = "Symm6" ;
    ELSEIF IBAS == 5 ;
      ITYPE = 3 ;
      IPAR = 8 ;
      BASTR = "Symm8" ;
    ELSEIF IBAS == 6 ;
      ITYPE = 4 ;
      IPAR = 2 ;
      BASTR = "Coif2" ;
    ELSEIF IBAS == 7 ;
      ITYPE = 4 ;
      IPAR = 3 ;
      BASTR = "Coif3" ;
    ENDIF ;

            /*  GET WAVELET COEFFS OF DATA  */
    COEFFS = WV2D1(Y,ITYPE,IPAR,J0) ;

  ELSEIF IBAS == 8 ;
    BASTR = "Fourier" ;

    COEFFS = WVFFTD(Y) ;

  ENDIF ;

  "WORKING ON "$+SIGSTR$+"  "$+TARSTR$+"  "$+BASTR ;


  IF ITH == 1 ;      /*  DO HARD THRESHOLDING  */
    TCOEFFS = COEFFS[(2^J0)+1:N] ;      /* HIGHER FREQ THAN J0  */
    TCOEFFS = TCOEFFS .* (TCOEFFS .> LAMSIG) ;
    TCOEFFS = COEFFS[1:2^J0]|TCOEFFS ;   /*  COMBINE ALL COEFFS  */
  ELSEIF ITH == 2  OR  ITH == 3 ;      /*  DO SOFT THRESHOLDING  */
    TCOEFFS = COEFFS[(2^J0)+1:N] ;      /* HIGHER FREQ THAN J0  */
    FLAGP = TCOEFFS .> LAMSIG ;     /*  ONE AT VERY POSITIVE COEEFS  */
    FLAGN = TCOEFFS .< -LAMSIG ;     /*  ONE AT VERY NEGATIVE COEEFS  */
    TCOEFFS = (TCOEFFS - LAMSIG) .* FLAGP  +  (TCOEFFS + LAMSIG) .* FLAGN ;
    TCOEFFS = COEFFS[1:2^J0]|TCOEFFS ;   /*  COMBINE ALL COEFFS  */
  ELSEIF ITH == 4 ;      /*  DO PROJECTION  */
    TCOEFFS = COEFFS[1:2^J0]|ZEROS(N-2^J0,1) ;
  ENDIF ;


  IF IBAS <= 7 ;
    MHAT = WV2R1(TCOEFFS,ITYPE,IPAR,J0) ;
  ELSEIF IBAS == 8 ;
    MHAT = WVFFTR(TCOEFFS) ;
  ENDIF ;


  IF IBAS == 1 ;   /*  HAAR  */
    _PLTYPE = 6 ;
  ELSEIF IBAS == 5 ;   /*  SYMM8  */
    _PLTYPE = 1 ;
  ELSEIF IBAS == 8 ;   /*  FOURIER  */
    _PLTYPE = 3 ;
  ELSE ;
    _PLTYPE = 5 ;
  ENDIF ;


  _PMSGSTR = BASTR$+THSTR$+", j]0[ = " ;
  _PMSGSTR = _PMSGSTR$+FTOS(J0,"%*.*lf",1,0) ;
    MX = LEFT + .4 * (RIGHT - LEFT) ;
    MY = TOP - (.05 * IB) * (TOP - BOTTOM) ;
    MHT = .15 ;   /*  HEIGHT  */
    MTH = 2 ;     /*  THICKNESS  */
  _PMSGCTL = MX~MY~MHT~0~1~10~MTH ;

    LXS = LEFT + .1 * (RIGHT - LEFT) ;
    LXE = LEFT + .37 * (RIGHT - LEFT) ;
    LJUMP = .02 * (TOP - BOTTOM) ;
    LY = MY + LJUMP ;
  _PLINE = 1~_PLTYPE~LXS~LY~LXE~LY~1~10~_PLWIDTH ;


  IF AUTOP == 1 ;
      PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\TT1E" ;
      PRSTR = PRSTR$+FTOS(IEG,"%*.*lf",1,0)$+"P" ;
      PRSTR = PRSTR$+FTOS(IB+2,"%*.*lf",1,0)$+".PLT" ;
    GRAPHPRT(PRSTR) ;
  ELSEIF AUTOP == 2 ;
      PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\TT1E" ;
      PRSTR = PRSTR$+FTOS(IEG,"%*.*lf",1,0)$+"P" ;
      PRSTR = PRSTR$+FTOS(IB+2,"%*.*lf",1,0)$+".PS" ;
    GRAPHPRT(PRSTR) ;
  ENDIF ;

  _PLCTRL = 0 ;
    TITLE(TITSTR) ;
  XY(XGRID,MHAT) ; ? ;

  IB = IB + 1 ;
ENDO ;



END ;
