"GAUSS PROGRAM WV2TT14.PRG" ;
/*  MAKES TRANSPARENCY BASED ON
 FIGURE L IN THE JOHNSTONE, MARRON, NEUMANN, PATIL PAPER  */
/*  AND ALSO SOME "SUPPORTING PLOTS"   */
/* COPIED FROM WV2FIGL.PRG  */
/*  FOR THE SECOND GENERATION WAVELET STUDY,
THIS WINDOWS PLOTS OF VARIOUS WAYS OF ROW-WISE SPECTRA  */


LIBRARY PGRAPH ;
GRAPHSET ;

AUTOP = 2 ;         /*  0 TO VIEW ON SCREEN   */
                    /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                    /*  2 TO WRITE AS POSTSCRIPT FILES  */

ISTYLE = 3 ;        /*  1 - ORIGINAL, WITH X-AXIS = PROP. OF COEFFS   */
                    /*          THIS IS CURRENTLY SUPPORTING PLOT 1  */
                    /*  2 - EQUAL SPACING FOR FREQS, SHOWING ALL  */
                    /*          THIS IS CURRENTLY SUPPORTING PLOT 2  */
                    /*  3 - EQUAL SPACING FOR FREQS, SHOWING J>=2  */
                    /*          THIS IS CURRENTLY MAIN FIGURE  */


VIBASIS = 1|5|8 ;
                    /*  1 - HAAR    */
                    /*  2 - DAUBECHIES 4    */
                    /*  3 - DAUBECHIES 6    */
                    /*  4 - SYMMLET 6    */
                    /*  5 - SYMMLET 8    */
                    /*  6 - COIFLET 2    */
                    /*  7 - COIFLET 3    */
                    /*  8 - FOURIER    */

N = 1024 ;           /*   SAMPLE SIZE  = NUMBER OF GRID POINTS   */
                    /*   MUST BE A POWER OF 2  */

ITARGET = 0 ;       /*   0 - LOOP THROUGH ALL    */
                    /*   1 - STEP       */
                    /*   2 - WAVE       */
                    /*   3 - BLIP       */
                    /*   4 - BLOCKS     */
                    /*   5 - BUMPS      */
                    /*   6 - HEAVSI     */
                    /*   7 - DOPPL      */
                    /*   8 - ANGLES     */
                    /*   9 - PARABS     */
                    /*   10 - SHSIN     */



J0E = ROUND(LOG(N) / LOG(2)) ;
NSTR = FTOS(N,"%*.*lf",1,0) ;
DELX = 1 / N ;
XGRID = SEQA(DELX/2,DELX,N) ;


                  /*  SET UP LOOPING STUFF  */
IF ITARGET == 0 ;
  ITS = 1 ;
  ITE = 10 ;
ELSE ;
  ITS = ITARGET ;
  ITE = ITARGET ;
ENDIF ;

NB = ROWS(VIBASIS) ;

ISS = 1 ;
ISE = 2 ;

BEGWIND ;
WINDOW(3,4,0) ;
SETWIND(0) ;


IT = ITS ;      /*  LOOP THROUGH TARGET FUNCTIONS  */
DO WHILE IT <= ITE ;

  IF IT == 1 ;
    TARSTR = "Step" ;
    M = 0.2 ;      /*  BASE HEIGHT  */
    M = M + (1/3 .< XGRID) .* (XGRID .< .75) * .6 ;
                   /*  RAISE BY .4 ON THIS INTERVAL  */
  ELSEIF IT == 2 ;
    TARSTR = "Wave" ;
    M = .2 * COS(XGRID * 2 * PI * 2) + .5 ;
    M = M + .1 * COS(XGRID * 2 * PI * 12) ;
  ELSEIF IT == 3 ;
    TARSTR = "Blip" ;
    M = .6 * XGRID + .2 ;
    M = M + .3 * EXP(-100 * (XGRID - .5) .* (XGRID - .5)) ;
      RM = ROWS(M) ;
    M = M[(RM/5)+1:RM]|M[1:RM/5] ;
                   /*  ROTATE SO DISCONT NOT AT EDGE  */
  ELSEIF IT == 4 ;
    TARSTR = "Blocks" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|-5|3|-4|5|-4.2|2.1|4.3|-3.1|2.1|-4.2 ;
    M = XGRID' - T ;
      FLAG = M .> 0 ;
      FLAG0 = M .== 0 ;
    M = FLAG - (1 - FLAG - FLAG0) ;       /*  GIVES SGN(M)  */
    M = (1 + M) / 2 ;
    M = H .* M ;
    M = SUMC(M) ;               /*  THIS IS NOW DJ'S BLOCKS   */
    M = (.6 / 9.2) * (M + 2) + .2 ;  /*  RESCALED TO [.2,.8]  */
  ELSEIF IT == 5 ;
    TARSTR = "Bumps" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|5|3|4|5|4.2|2.1|4.3|3.1|5.1|4.2 ;
      W = .005|.005|.006|.01|.01|.03|.01|.01|.005|.008|.005 ;
    M = (XGRID' - T) ./ W ;
    M = 1 ./ (1 + ABS(M))^4 ;
    M = H .* M ;
    M = SUMC(M) ;                  /*  THIS IS NOW DJ'S BUMPS   */
    M = (.6/5.3437952) * M + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF IT == 6 ;
    TARSTR = "HeavSi" ;
    M = 4 * SIN(4 * PI * XGRID) ;
      FLAG = XGRID .> .3 ;
      FLAG0 = XGRID .== .3 ;
    M = M - (FLAG - (1 - FLAG - FLAG0)) ;
      FLAG = XGRID .> .72 ;
      FLAG0 = XGRID .== .72 ;
    M = M + (FLAG - (1 - FLAG - FLAG0)) ;  /*  DJ'S HEAVY SINE  */
    M = (.6 / 9) * (M + 5) + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF IT == 7 ;
    TARSTR = "Doppl" ;
    M = SQRT(XGRID .* (1 - XGRID)) ;
    M = M .* SIN(2 * PI * 1.05 ./ (XGRID + .05)) ; /* DJ'S DOPPLER */
    M = (.6 / 1) * (M + .5) + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF IT == 8 ;
    TARSTR = "Angles" ;
    M = (XGRID .<= .15) .* (2 * XGRID + .5) ;
    M = M + (.15 .< XGRID) .* (XGRID .<= .2) .* (-12 * (XGRID-.15) + .8) ;
    M = M + (.2 .< XGRID) .* (XGRID .<= .5) .* (.2)  ;
    M = M + (.5 .< XGRID) .* (XGRID .<= .6) .* (6 * (XGRID-.5) + .2) ;
    M = M + (.6 .< XGRID) .* (XGRID .<= .65) .* (-10 * (XGRID-.6) + .8) ;
    M = M + (.65 .< XGRID) .* (XGRID .<= .85) .* (-1/2 * (XGRID-.65)+.3) ;
    M = M + (.85 .< XGRID) .* (2 * (XGRID -.85) + .2)  ;
  ELSEIF IT == 9 ;
    TARSTR = "Parabs" ;
    M = .8 .* ONES(N,1) ;
    M = M + (.1 .< XGRID) .* (-30 .* (XGRID - .1)^2) ;
    M = M + (.2 .< XGRID) .* (60 .* (XGRID - .2)^2) ;
    M = M + (.3 .< XGRID) .* (-30 .* (XGRID - .3)^2) ;
    M = M + (.35 .< XGRID) .* (500 .* (XGRID - .35)^2) ;
    M = M + (.37 .< XGRID) .* (-1000 .* (XGRID - .37)^2) ;
    M = M + (.41 .< XGRID) .* (1000 .* (XGRID - .41)^2) ;
    M = M + (.43 .< XGRID) .* (-500 .* (XGRID - .43)^2) ;
    M = M + (.5 .< XGRID) .* (7.5 .* (XGRID - .5)^2) ;
    M = M + (.7 .< XGRID) .* (-15 .* (XGRID - .7)^2) ;
    M = M + (.9 .< XGRID) .* (7.5 .* (XGRID - .9)^2) ;
  ELSEIF IT == 10 ;
    TARSTR = "TShSin" ;
    TXGRID = (1 - COS(PI .* XGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 4 + XGRID / 2 ;
    M = .3 * SIN(6 .* PI .* TXGRID) + .5 ;
  ENDIF ;

  MREM = ZEROS(N,NB) ;


  IB = 1 ;      /*  LOOP THROUGH BASES  */
  DO WHILE IB <= NB ;
    IBAS = VIBASIS[IB] ;


    IF IBAS <= 7 ;
      IF IBAS == 1 ;
        ITYPE = 1 ;
        IPAR = 0 ;
        BASTR = "Haar" ;
      ELSEIF IBAS == 2 ;
        ITYPE = 2 ;
        IPAR = 4 ;
        BASTR = "Daub4" ;
      ELSEIF IBAS == 3 ;
        ITYPE = 2 ;
        IPAR = 6 ;
        BASTR = "Daub6" ;
      ELSEIF IBAS == 4 ;
        ITYPE = 3 ;
        IPAR = 6 ;
        BASTR = "Symm6" ;
      ELSEIF IBAS == 5 ;
        ITYPE = 3 ;
        IPAR = 8 ;
        BASTR = "Symm8" ;
      ELSEIF IBAS == 6 ;
        ITYPE = 4 ;
        IPAR = 2 ;
        BASTR = "Coif2" ;
      ELSEIF IBAS == 7 ;
        ITYPE = 4 ;
        IPAR = 3 ;
        BASTR = "Coif3" ;
      ENDIF ;

              /*  GET WAVELET COEFFS OF TARGET  */
      COEFFS = WV2D1(M,ITYPE,IPAR,-1) ;
                    /*  RECALL -1 GIVES LOWEST LEVEL POSSIBLE  */
      COEFFS = ABS(COEFFS) ;

    ELSEIF IBAS == 8 ;
      BASTR = "Fourier" ;

      COEFFS = WVFFTD(M) ;
      COEFFS = ABS(COEFFS) ;

    ENDIF ;



    J = 3 ;
    REMRW = COEFFS[1:2^J]^2 ;
    REMRW = SORTC(REMRW,1) ;
    REMRW = REV(REMRW) ;
    DO WHILE J <= J0E - 1 ;
      RRW = COEFFS[(2^J)+1:2^(J+1)]^2 ;
      RRW = SORTC(RRW,1) ;
      RRW = CUMSUMC(RRW) ;
      RRW = REV(RRW) ;
      REMRW = REMRW|RRW ;
      J = J + 1 ;
    ENDO ;

    MREM[.,IB] = REMRW ;


    IF IB == 1 ;
      _PLEGSTR = BASTR ;
    ELSE ;
      _PLEGSTR = _PLEGSTR$+"\000"$+BASTR ;
/*
      _PLEGSTR = _PLEGSTR$+""$+BASTR ;
           /*  FOR SOME REASON (NOT UNDERSTOOD), THIS WORKS, AND PUTTING
               /000 IN THE QUOTES DOESN'T   */
*/
    ENDIF ;

    IB = IB + 1 ;
  ENDO ;




  NEXTWIND ;

  FLAG = (MREM .> 10^(-8)) ;
  MREM = MREM .* FLAG + (1 - FLAG) .* 10^(-8) ;
  MREM = LOG(MREM) ;

    _PLWIDTH = 3 ;
    FONTS("SIMPLEX SIMGRMA" ) ;
    _PLTYPE = 6|1|3|4|4 ;
    _PDATE = "" ;
    YTICS(-5,2,1,1) ;
    YLABEL("log]10[(Row-wise Power Rem.)") ;
    _PLEGCTL = 2|8|6.2|4.4 ;
      _PTITLHT = .4 ;
          TITSTR = "#"$+FTOS(IT,"%*.*lf",1,0)$+" " ;
          TITSTR = TITSTR$+TARSTR ;
    TITLE(TITSTR) ;
  IF ISTYLE == 1 ;
      XTICS(0,1,.25,4) ;
      XLABEL("Proportion of Coeffs") ;
    XY(XGRID,MREM) ;
  ELSEIF ISTYLE == 2 ;
      XTICS(-2,10,1,1) ;
      XLABEL("j") ;
    XY((LOG(XGRID)/LOG(2)+10),MREM) ;
  ELSEIF ISTYLE == 3 ;
      XTICS(2,10,1,1) ;
      XLABEL("j") ;
    XY((LOG(XGRID)/LOG(2)+10),MREM) ;
  ENDIF ;

  IT = IT + 1 ;
ENDO ;




/*  NOW DO PLOTS FOR NOISE  */

NOISEREM = ZEROS(N,2)  ;
IS = ISS ;      /*  LOOP THROUGH SIGMAS  */
DO WHILE IS <= ISE ;

  IF IS == 1 ;
    SIGSTR = "Low Noise" ;
    SIG = .02 ;
  ELSEIF IS == 2 ;
    SIGSTR = "High Noise" ;
    SIG = .1 ;
  ENDIF ;

  ? ; "WORKING ON "$+SIGSTR ;


    SEED = 932485732 ;
  Y =  SIG * RNDNS(N,1,SEED) ;
/*  NO M TO GET "PURE NOISE" VERSION   */


  MREM = SORTC(Y^2,1) ;


  MREM = CUMSUMC(MREM) ;
  MREM = REV(MREM) ;    /*  PUT IN DECREASING ORDER  */
  MREM = LOG(MREM) ;

  NOISEREM[.,IS] = MREM ;

  IF IS == 1 ;
    _PLEGSTR = _PLEGSTR$+"\202s\201 = "$+FTOS(SIG,"%*.*lf",3,2) ;
  ELSEIF IS == 2 ;
    _PLEGSTR = _PLEGSTR$+"\000\202s\201 = "$+FTOS(SIG,"%*.*lf",3,2) ;
  ENDIF ;


  IS = IS + 1 ;
ENDO ;



IT = 1 ;      /*  LOOP THROUGH TARGET FUNCTIONS  */
DO WHILE IT <= 2 ;
  IF IT == 1 ;
    ITT = 1 ;
  ELSEIF IT == 2 ;
    ITT = 8 ;
  ENDIF ;


  NEXTWIND ;


  IF ITT == 1 ;
    TARSTR = "Step" ;
    M = 0.2 ;      /*  BASE HEIGHT  */
    M = M + (1/3 .< XGRID) .* (XGRID .< .75) * .6 ;
                   /*  RAISE BY .4 ON THIS INTERVAL  */
  ELSEIF ITT == 2 ;
    TARSTR = "Wave" ;
    M = .2 * COS(XGRID * 2 * PI * 2) + .5 ;
    M = M + .1 * COS(XGRID * 2 * PI * 12) ;
  ELSEIF ITT == 3 ;
    TARSTR = "Blip" ;
    M = .6 * XGRID + .2 ;
    M = M + .3 * EXP(-100 * (XGRID - .5) .* (XGRID - .5)) ;
      RM = ROWS(M) ;
    M = M[(RM/5)+1:RM]|M[1:RM/5] ;
                   /*  ROTATE SO DISCONT NOT AT EDGE  */
  ELSEIF ITT == 4 ;
    TARSTR = "Blocks" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|-5|3|-4|5|-4.2|2.1|4.3|-3.1|2.1|-4.2 ;
    M = XGRID' - T ;
      FLAG = M .> 0 ;
      FLAG0 = M .== 0 ;
    M = FLAG - (1 - FLAG - FLAG0) ;       /*  GIVES SGN(M)  */
    M = (1 + M) / 2 ;
    M = H .* M ;
    M = SUMC(M) ;               /*  THIS IS NOW DJ'S BLOCKS   */
    M = (.6 / 9.2) * (M + 2) + .2 ;  /*  RESCALED TO [.2,.8]  */
  ELSEIF ITT == 5 ;
    TARSTR = "Bumps" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|5|3|4|5|4.2|2.1|4.3|3.1|5.1|4.2 ;
      W = .005|.005|.006|.01|.01|.03|.01|.01|.005|.008|.005 ;
    M = (XGRID' - T) ./ W ;
    M = 1 ./ (1 + ABS(M))^4 ;
    M = H .* M ;
    M = SUMC(M) ;                  /*  THIS IS NOW DJ'S BUMPS   */
    M = (.6/5.3437952) * M + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF ITT == 6 ;
    TARSTR = "HeavSi" ;
    M = 4 * SIN(4 * PI * XGRID) ;
      FLAG = XGRID .> .3 ;
      FLAG0 = XGRID .== .3 ;
    M = M - (FLAG - (1 - FLAG - FLAG0)) ;
      FLAG = XGRID .> .72 ;
      FLAG0 = XGRID .== .72 ;
    M = M + (FLAG - (1 - FLAG - FLAG0)) ;  /*  DJ'S HEAVY SINE  */
    M = (.6 / 9) * (M + 5) + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF ITT == 7 ;
    TARSTR = "Doppl" ;
    M = SQRT(XGRID .* (1 - XGRID)) ;
    M = M .* SIN(2 * PI * 1.05 ./ (XGRID + .05)) ; /* DJ'S DOPPLER */
    M = (.6 / 1) * (M + .5) + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF ITT == 8 ;
    TARSTR = "Angles" ;
    M = (XGRID .<= .15) .* (2 * XGRID + .5) ;
    M = M + (.15 .< XGRID) .* (XGRID .<= .2) .* (-12 * (XGRID-.15) + .8) ;
    M = M + (.2 .< XGRID) .* (XGRID .<= .5) .* (.2)  ;
    M = M + (.5 .< XGRID) .* (XGRID .<= .6) .* (6 * (XGRID-.5) + .2) ;
    M = M + (.6 .< XGRID) .* (XGRID .<= .65) .* (-10 * (XGRID-.6) + .8) ;
    M = M + (.65 .< XGRID) .* (XGRID .<= .85) .* (-1/2 * (XGRID-.65)+.3) ;
    M = M + (.85 .< XGRID) .* (2 * (XGRID -.85) + .2)  ;
  ELSEIF ITT == 9 ;
    TARSTR = "Parabs" ;
    M = .8 .* ONES(N,1) ;
    M = M + (.1 .< XGRID) .* (-30 .* (XGRID - .1)^2) ;
    M = M + (.2 .< XGRID) .* (60 .* (XGRID - .2)^2) ;
    M = M + (.3 .< XGRID) .* (-30 .* (XGRID - .3)^2) ;
    M = M + (.35 .< XGRID) .* (500 .* (XGRID - .35)^2) ;
    M = M + (.37 .< XGRID) .* (-1000 .* (XGRID - .37)^2) ;
    M = M + (.41 .< XGRID) .* (1000 .* (XGRID - .41)^2) ;
    M = M + (.43 .< XGRID) .* (-500 .* (XGRID - .43)^2) ;
    M = M + (.5 .< XGRID) .* (7.5 .* (XGRID - .5)^2) ;
    M = M + (.7 .< XGRID) .* (-15 .* (XGRID - .7)^2) ;
    M = M + (.9 .< XGRID) .* (7.5 .* (XGRID - .9)^2) ;
  ELSEIF ITT == 10 ;
    TARSTR = "TShSin" ;
    TXGRID = (1 - COS(PI .* XGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 4 + XGRID / 2 ;
    M = .3 * SIN(6 .* PI .* TXGRID) + .5 ;
  ENDIF ;


  MREM = ZEROS(N,NB) ;

  IB = 1 ;      /*  LOOP THROUGH BASES  */
  DO WHILE IB <= NB ;
    IBAS = VIBASIS[IB] ;


    IF IBAS <= 7 ;
      IF IBAS == 1 ;
        ITYPE = 1 ;
        IPAR = 0 ;
        BASTR = "Haar" ;
      ELSEIF IBAS == 2 ;
        ITYPE = 2 ;
        IPAR = 4 ;
        BASTR = "Daub4" ;
      ELSEIF IBAS == 3 ;
        ITYPE = 2 ;
        IPAR = 6 ;
        BASTR = "Daub6" ;
      ELSEIF IBAS == 4 ;
        ITYPE = 3 ;
        IPAR = 6 ;
        BASTR = "Symm6" ;
      ELSEIF IBAS == 5 ;
        ITYPE = 3 ;
        IPAR = 8 ;
        BASTR = "Symm8" ;
      ELSEIF IBAS == 6 ;
        ITYPE = 4 ;
        IPAR = 2 ;
        BASTR = "Coif2" ;
      ELSEIF IBAS == 7 ;
        ITYPE = 4 ;
        IPAR = 3 ;
        BASTR = "Coif3" ;
      ENDIF ;

              /*  GET WAVELET COEFFS OF TARGET  */
      COEFFS = WV2D1(M,ITYPE,IPAR,-1) ;
                    /*  RECALL -1 GIVES LOWEST LEVEL POSSIBLE  */
      COEFFS = ABS(COEFFS) ;

    ELSEIF IBAS == 8 ;
      BASTR = "Fourier" ;

      COEFFS = WVFFTD(M) ;
      COEFFS = ABS(COEFFS) ;

    ENDIF ;


    MREM[.,IB] = SORTC(COEFFS^2,1) ;

    IB = IB + 1 ;
  ENDO ;


  MREM = CUMSUMC(MREM) ;
  MREM = REV(MREM) ;    /*  PUT IN DECREASING ORDER  */
  FLAG = (MREM .> 10^(-8)) ;
  MREM = MREM .* FLAG + (1 - FLAG) .* 10^(-8) ;
  MREM = LOG(MREM) ;


    XTICS(0,1,.25,4) ;
    XLABEL("Proportion of Coeffs") ;
    YLABEL("log]10[(Power Rem.)") ;
    _PLEGCTL = 2|8|5.8|3.8 ;
      TITSTR = "#"$+FTOS(ITT,"%*.*lf",1,0)$+" " ;
      TITSTR = TITSTR$+TARSTR ;
      TITSTR = TITSTR$+",  with Pure Noise" ;
    TITLE(TITSTR) ;
  XY(XGRID,MREM~NOISEREM) ;



  IT = IT + 1 ;
ENDO ;





IF AUTOP == 1 ;
  PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\TT14.PLT" ;
  GRAPHPRT(PRSTR) ;
ELSEIF AUTOP == 2 ;
  PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\TT14.PS" ;
  GRAPHPRT(PRSTR) ;
ENDIF ;

ENDWIND ;



END ;
