"GAUSS PROGRAM WV2TT2.PRG " ;
/*  MAKES TRANSPARENCIES FOR TALK ON WAVELETS  */
/*  THIS ONE DOES WAVELET BASIS FUNCTIONS  */

LIBRARY PGRAPH ;  GRAPHSET ;

AUTOP = 2 ;         /*  0 TO VIEW ON SCREEN   */
                    /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                    /*  2 TO WRITE AS POSTSCRIPT FILES  */

IPIC = 0 ;    /*  PICTURE 0 - DO ALL */
              /*          1 - FOURIER BASIS  */
              /*          2 - HAAR BASIS, FATHERS  */
              /*          3 - HAAR BASIS, MOTHERS  */
              /*          4 - HAAR BASIS, MIXED  */
              /*          5 - SYMM8 BASIS   */
              /*          6 - DAUB4 BASIS   */


N = 256 ;
DELX = 1 / N ;
XGRID = SEQA((DELX / 2),DELX,N) ;
ZEROBAR = ZEROS(N,1) ;

FONTS("SIMPLEX SIMGRMA" ) ;
_PLTYPE = 6|2 ;
_PLWIDTH = 2|1 ;
XTICS(0,1,1,1) ;


IF  IPIC == 0  OR  IPIC == 1 ;

  _PMSGCTL = 5.6~6.3~.4~0~2~9~1 ;

  YTICS(-1.2,1.2,2.4,1) ;
  ASCLABEL("."|".","."|".") ;

  BEGWIND ;
  WINDOW(4,5,0) ;

    SETWIND(1) ;
    OUT = ONES(N,1) ;
    _PMSGSTR = "Const" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(6) ;
    OUT = SIN(2 * PI * XGRID) ;
    _PMSGSTR = "Sin(2\202p\201x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(7) ;
    OUT = COS(2 * PI * XGRID) ;
    _PMSGSTR = "Cos(2\202p\201x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(11) ;
    OUT = SIN(2 * PI * 2 * XGRID) ;
    _PMSGSTR = "Sin(2\202p\2012x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(12) ;
    OUT = COS(2 * PI * 2 * XGRID) ;
    _PMSGSTR = "Cos(2\202p\2012x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(16) ;
    OUT = SIN(2 * PI * 3 * XGRID) ;
    _PMSGSTR = "Sin(2\202p\2013x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(17) ;
    OUT = COS(2 * PI * 3 * XGRID) ;
    _PMSGSTR = "Cos(2\202p\2013x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(4) ;
    OUT = SIN(2 * PI * 4 * XGRID) ;
    _PMSGSTR = "Sin(2\202p\2014x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(5) ;
    OUT = COS(2 * PI * 4 * XGRID) ;
    _PMSGSTR = "Cos(2\202p\2014x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(9) ;
    OUT = SIN(2 * PI * 5 * XGRID) ;
    _PMSGSTR = "Sin(2\202p\2015x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(10) ;
    OUT = COS(2 * PI * 5 * XGRID) ;
    _PMSGSTR = "Cos(2\202p\2015x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(14) ;
    OUT = SIN(2 * PI * 6 * XGRID) ;
    _PMSGSTR = "Sin(2\202p\2016x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(15) ;
    OUT = COS(2 * PI * 6 * XGRID) ;
    _PMSGSTR = "Cos(2\202p\2016x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(19) ;
    _PMSGSTR = "Sin(2\202p\2017x)" ;
    OUT = SIN(2 * PI * 7 * XGRID) ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(20) ;
    OUT = COS(2 * PI * 7 * XGRID) ;
    _PMSGSTR = "Cos(2\202p\2017x)" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;



  IF AUTOP == 1 ;
      PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\TT2P1.PLT" ;
    GRAPHPRT(PRSTR) ;
  ELSEIF AUTOP == 2 ;
      PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\TT2P1.PS" ;
    GRAPHPRT(PRSTR) ;
  ENDIF ;

  ENDWIND ;

ENDIF ;



IF  IPIC == 0  OR  IPIC == 2 ;

  _PMSGCTL = 6.7~6.2~.6~0~2~9~1 ;

  YTICS(-.2,1.2,1.4,1) ;
  ASCLABEL("."|".","."|".") ;

  BEGWIND ;
  WINDOW(4,5,0) ;

    SETWIND(1) ;
    OUT = ONES(N,1) ;
    _PMSGSTR = "\202f\201]0,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(6) ;
    OUT = (XGRID .<= .5) ;
    _PMSGSTR = "\202f\201]1,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(7) ;
    OUT = (.5 .< XGRID) ;
    _PMSGSTR = "\202f\201]1,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(11) ;
    OUT = (XGRID .<= .25) ;
    _PMSGSTR = "\202f\201]2,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(12) ;
    OUT = (.25 .< XGRID) .* (XGRID .<= .5) ;
    _PMSGSTR = "\202f\201]2,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(13) ;
    OUT = (.5 .< XGRID) .* (XGRID .<= .75) ;
    _PMSGSTR = "\202f\201]2,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(14) ;
    OUT = (.75 .< XGRID) .* (XGRID .<= 1) ;
    _PMSGSTR = "\202f\201]2,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(16) ;
    OUT = (0 .< XGRID) .* (XGRID .<= .125) ;
    _PMSGSTR = "\202f\201]3,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(17) ;
    OUT = (.125 .< XGRID) .* (XGRID .<= .25) ;
    _PMSGSTR = "\202f\201]3,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(18) ;
    OUT = (.25 .< XGRID) .* (XGRID .<= .375) ;
    _PMSGSTR = "\202f\201]3,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(19) ;
    OUT = (.375 .< XGRID) .* (XGRID .<= .5) ;
    _PMSGSTR = "\202f\201]3,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(20) ;
    OUT = (.5 .< XGRID) .* (XGRID .<= .625) ;
    _PMSGSTR = "\202f\201]3,4[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

  IF AUTOP == 1 ;
      PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\TT2P2.PLT" ;
    GRAPHPRT(PRSTR) ;
  ELSEIF AUTOP == 2 ;
      PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\TT2P2.PS" ;
    GRAPHPRT(PRSTR) ;
  ENDIF ;

  ENDWIND ;

ENDIF ;



IF  IPIC == 0  OR  IPIC == 3 ;

  _PMSGCTL = 6.7~6.2~.6~0~2~9~1 ;

  YTICS(-1.2,1.2,2.4,1) ;
  ASCLABEL("."|".","."|".") ;

  BEGWIND ;
  WINDOW(4,5,0) ;

    SETWIND(1) ;
    OUT = (XGRID .<= .5) - (.5 .< XGRID) ;
    _PMSGSTR = "\202y\201]0,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(5) ;
    OUT = ONES(N,1) ;
    _PMSGSTR = "\202f\201]0,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(6) ;
    OUT = (XGRID .<= .25) ;
    OUT = OUT - (.25 .< XGRID) .* (XGRID .<= .5) ;
    _PMSGSTR = "\202y\201]1,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(7) ;
    OUT = (.5 .< XGRID) .* (XGRID .<= .75) ;
    OUT = OUT - (.75 .< XGRID) .* (XGRID .<= 1) ;
    _PMSGSTR = "\202y\201]1,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(11) ;
    OUT = (XGRID .<= .125) ;
    OUT = OUT - (.125 .< XGRID) .* (XGRID .<= .25) ;
    _PMSGSTR = "\202y\201]2,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(12) ;
    OUT = (.25 .< XGRID) .* (XGRID .<= .375) ;
    OUT = OUT - (.375 .< XGRID) .* (XGRID .<= .5) ;
    _PMSGSTR = "\202y\201]2,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(13) ;
    OUT = (.5 .< XGRID) .* (XGRID .<= .625) ;
    OUT = OUT - (.625 .< XGRID) .* (XGRID .<= .75) ;
    _PMSGSTR = "\202y\201]2,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(14) ;
    OUT = (.75 .< XGRID) .* (XGRID .<= .875) ;
    OUT = OUT - (.875 .< XGRID) .* (XGRID .<= 1) ;
    _PMSGSTR = "\202y\201]2,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(16) ;
    OUT = (0 .< XGRID) .* (XGRID .<= .0625) ;
    OUT = OUT - (.0625 .< XGRID) .* (XGRID .<= .125) ;
    _PMSGSTR = "\202y\201]3,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(17) ;
    OUT = (.125 .< XGRID) .* (XGRID .<= .1875) ;
    OUT = OUT - (.1875 .< XGRID) .* (XGRID .<= .25) ;
    _PMSGSTR = "\202y\201]3,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(18) ;
    OUT = (.25 .< XGRID) .* (XGRID .<= .3125) ;
    OUT = OUT - (.3125 .< XGRID) .* (XGRID .<= .375) ;
    _PMSGSTR = "\202y\201]3,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(19) ;
    OUT = (.375 .< XGRID) .* (XGRID .<= .4375) ;
    OUT = OUT - (.4375 .< XGRID) .* (XGRID .<= .5) ;
    _PMSGSTR = "\202y\201]3,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(20) ;
    OUT = (.5 .< XGRID) .* (XGRID .<= .5625) ;
    OUT = OUT - (.5625 .< XGRID) .* (XGRID .<= .625) ;
    _PMSGSTR = "\202y\201]3,4[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

  IF AUTOP == 1 ;
      PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\TT2P3.PLT" ;
    GRAPHPRT(PRSTR) ;
  ELSEIF AUTOP == 2 ;
      PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\TT2P3.PS" ;
    GRAPHPRT(PRSTR) ;
  ENDIF ;

  ENDWIND ;

ENDIF ;




IF  IPIC == 0  OR  IPIC == 4 ;

  _PMSGCTL = 6.7~6.2~.6~0~2~9~1 ;

  YTICS(-1.2,1.2,2.4,1) ;
  ASCLABEL("."|".","."|".") ;

  BEGWIND ;
  WINDOW(4,5,0) ;

    SETWIND(2) ;
    OUT = (XGRID .<= .25) ;
    _PMSGSTR = "\202f\201]2,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(3) ;
    OUT = (.25 .< XGRID) .* (XGRID .<= .5) ;
    _PMSGSTR = "\202f\201]2,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(4) ;
    OUT = (.5 .< XGRID) .* (XGRID .<= .75) ;
    _PMSGSTR = "\202f\201]2,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(5) ;
    OUT = (.75 .< XGRID) .* (XGRID .<= 1) ;
    _PMSGSTR = "\202f\201]2,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(11) ;
    OUT = (XGRID .<= .125) ;
    OUT = OUT - (.125 .< XGRID) .* (XGRID .<= .25) ;
    _PMSGSTR = "\202y\201]2,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(12) ;
    OUT = (.25 .< XGRID) .* (XGRID .<= .375) ;
    OUT = OUT - (.375 .< XGRID) .* (XGRID .<= .5) ;
    _PMSGSTR = "\202y\201]2,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(13) ;
    OUT = (.5 .< XGRID) .* (XGRID .<= .625) ;
    OUT = OUT - (.625 .< XGRID) .* (XGRID .<= .75) ;
    _PMSGSTR = "\202y\201]2,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(14) ;
    OUT = (.75 .< XGRID) .* (XGRID .<= .875) ;
    OUT = OUT - (.875 .< XGRID) .* (XGRID .<= 1) ;
    _PMSGSTR = "\202y\201]2,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(16) ;
    OUT = (0 .< XGRID) .* (XGRID .<= .0625) ;
    OUT = OUT - (.0625 .< XGRID) .* (XGRID .<= .125) ;
    _PMSGSTR = "\202y\201]3,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(17) ;
    OUT = (.125 .< XGRID) .* (XGRID .<= .1875) ;
    OUT = OUT - (.1875 .< XGRID) .* (XGRID .<= .25) ;
    _PMSGSTR = "\202y\201]3,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(18) ;
    OUT = (.25 .< XGRID) .* (XGRID .<= .3125) ;
    OUT = OUT - (.3125 .< XGRID) .* (XGRID .<= .375) ;
    _PMSGSTR = "\202y\201]3,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(19) ;
    OUT = (.375 .< XGRID) .* (XGRID .<= .4375) ;
    OUT = OUT - (.4375 .< XGRID) .* (XGRID .<= .5) ;
    _PMSGSTR = "\202y\201]3,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(20) ;
    OUT = (.5 .< XGRID) .* (XGRID .<= .5625) ;
    OUT = OUT - (.5625 .< XGRID) .* (XGRID .<= .625) ;
    _PMSGSTR = "\202y\201]3,4[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

  IF AUTOP == 1 ;
      PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\TT2P4.PLT" ;
    GRAPHPRT(PRSTR) ;
  ELSEIF AUTOP == 2 ;
      PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\TT2P4.PS" ;
    GRAPHPRT(PRSTR) ;
  ENDIF ;

  ENDWIND ;

ENDIF ;



IF  IPIC == 0  OR  IPIC == 5 ;

  _PMSGCTL = 6.7~6.2~.6~0~2~9~1 ;

  YTICS(-1.2,1.2,2.4,1) ;
  ASCLABEL("."|".","."|".") ;

  ITYPE = 3 ;
  IPAR = 8 ;
  J0 = 3 ;

  BEGWIND ;
  WINDOW(4,5,0) ;

    SETWIND(2) ;
      COEFFS = 0|0|0|1|ZEROS(N-4,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202f\201]2,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(3) ;
      COEFFS = 0|0|0|0|1|ZEROS(N-5,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202f\201]2,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(4) ;
      COEFFS = 0|0|0|0|0|1|ZEROS(N-6,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202f\201]2,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(5) ;
      COEFFS = 0|0|0|0|0|0|1|ZEROS(N-7,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202f\201]2,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(11) ;
      COEFFS = ZEROS(11,1)|1|ZEROS(N-12,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]2,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(12) ;
      COEFFS = ZEROS(12,1)|1|ZEROS(N-13,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]2,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(13) ;
      COEFFS = ZEROS(13,1)|1|ZEROS(N-14,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]2,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(14) ;
      COEFFS = ZEROS(14,1)|1|ZEROS(N-15,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]2,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(16) ;
      COEFFS = ZEROS(19,1)|1|ZEROS(N-20,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]3,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(17) ;
      COEFFS = ZEROS(20,1)|1|ZEROS(N-21,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]3,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(18) ;
      COEFFS = ZEROS(21,1)|1|ZEROS(N-22,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]3,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(19) ;
      COEFFS = ZEROS(22,1)|1|ZEROS(N-23,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]3,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(20) ;
      COEFFS = ZEROS(23,1)|1|ZEROS(N-24,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]3,4[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;


  IF AUTOP == 1 ;
      PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\TT2P5.PLT" ;
    GRAPHPRT(PRSTR) ;
  ELSEIF AUTOP == 2 ;
      PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\TT2P5.PS" ;
    GRAPHPRT(PRSTR) ;
  ENDIF ;

  ENDWIND ;

ENDIF ;




IF  IPIC == 0  OR  IPIC == 6 ;

  _PMSGCTL = 6.7~6.2~.6~0~2~9~1 ;

  YTICS(-1.2,1.2,2.4,1) ;
  ASCLABEL("."|".","."|".") ;

  BEGWIND ;
  WINDOW(4,5,0) ;

  ITYPE = 2 ;    /*  3 FOR SYMMLETS  */
  IPAR = 4 ;     /*  8 FOR SYMM8  */
  J0 = 2 ;


    SETWIND(2) ;
      COEFFS = 1|ZEROS(N-1,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202f\201]2,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(3) ;
      COEFFS = 0|1|ZEROS(N-2,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202f\201]2,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(4) ;
      COEFFS = 0|0|1|ZEROS(N-3,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202f\201]2,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(5) ;
      COEFFS = 0|0|0|1|ZEROS(N-4,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202f\201]2,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(11) ;
      COEFFS = ZEROS(5,1)|1|ZEROS(N-6,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]2,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(12) ;
      COEFFS = ZEROS(6,1)|1|ZEROS(N-7,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]2,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(13) ;
      COEFFS = ZEROS(7,1)|1|ZEROS(N-8,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]2,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(14) ;
      COEFFS = ZEROS(8,1)|1|ZEROS(N-9,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]2,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(16) ;
      COEFFS = ZEROS(9,1)|1|ZEROS(N-10,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]3,0[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(17) ;
      COEFFS = ZEROS(10,1)|1|ZEROS(N-11,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]3,1[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(18) ;
      COEFFS = ZEROS(11,1)|1|ZEROS(N-12,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]3,2[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(19) ;
      COEFFS = ZEROS(12,1)|1|ZEROS(N-13,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]3,3[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;

    SETWIND(20) ;
      COEFFS = ZEROS(13,1)|1|ZEROS(N-14,1) ;
    OUT = WV2R1(COEFFS,ITYPE,IPAR,J0) ;
    OUT = OUT / MAXC(ABS(OUT)) ;
    _PMSGSTR = "\202y\201]3,4[" ;
  XY(XGRID,OUT~ZEROBAR) ; ? ;


  IF AUTOP == 1 ;
      PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\TT2P6.PLT" ;
    GRAPHPRT(PRSTR) ;
  ELSEIF AUTOP == 2 ;
      PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\TT2P6.PS" ;
    GRAPHPRT(PRSTR) ;
  ENDIF ;

  ENDWIND ;

ENDIF ;

