"  GAUSS PROGRAM WV2TT4.PRG " ;
/*  FOR MAKING FIGURE A IN THE 2ND GENERATION WAVELET INVESTIGATION
COPIED FROM    WV2FIGA.PRG
FOR SHOWING TARGET FUNCTIONS AND NOISY DATA  */

LIBRARY PGRAPH ;
GRAPHSET ;

AUTOP = 2 ;       /*  0 TO VIEW ON SCREEN   */
                  /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                  /*  2 TO WRITE AS POSTSCRIPT FILES  */


NXGRID = 2048 ;     /*   NUMBER OF GRID POINTS FOR TARGET PLOTS  */

N = 256 ;           /*   SAMPLE SIZE  FOR DATA PART   */
                    /*   MUST BE A POWER OF 2  */



NSTR = FTOS(N,"%*.*lf",1,0) ;
DELX = 1 / N ;
DATGRID = SEQA(DELX/2,DELX,N) ;
DELX = 1 / NXGRID ;
XGRID = SEQA(DELX/2,DELX,NXGRID) ;

                  /*  SET GRAPHICS STUFF  */
FONTS("SIMPLEX SIMGRMA" ) ;
_PLTYPE = 6 ;
_PLCTRL = 0|-1 ;
_PLWIDTH = 3 ;
_PSTYPE = 4 ;
_PSYMSIZ = 1 ;
_PNUM = 0 ;
_PTITLHT = .5 ;
_PDATE = "" ;
  LEFT = 0 ;
  RIGHT = 1 ;
  XSTEP = 1 ;
  XMSD = 1 ;
XTICS(LEFT,RIGHT,XSTEP,XMSD) ;
  BOTTOM = 0 ;
  TOP = 1 ;
  YSTEP = 1 ;
  YMSD = 1 ;
YTICS(BOTTOM,TOP,YSTEP,YMSD) ;

                  /*  SET UP LOOPING STUFF  */
ITS = 1 ;
ITE = 10 ;

ISS = 1 ;
ISE = 2 ;


BEGWIND ;
/*
WINDOW(4,3,1) ;
*/
WINDOW(3,4,1) ;
SETWIND(0) ;



IT = ITS ;      /*  LOOP THROUGH TARGET FUNCTIONS  */
DO WHILE IT <= ITE ;
  NEXTWIND ;

  IF IT == 1 ;
    TARSTR = "Step" ;
    M = 0.2 ;      /*  BASE HEIGHT  */
    M = M + (1/3 .< XGRID) .* (XGRID .< .75) * .6 ;
                   /*  RAISE BY .4 ON THIS INTERVAL  */
  ELSEIF IT == 2 ;
    TARSTR = "Wave" ;
    M = .2 * COS(XGRID * 2 * PI * 2) + .5 ;
    M = M + .1 * COS(XGRID * 2 * PI * 12) ;
  ELSEIF IT == 3 ;
    TARSTR = "Blip" ;
    M = .6 * XGRID + .2 ;
    M = M + .3 * EXP(-100 * (XGRID - .5) .* (XGRID - .5)) ;
      RM = ROWS(M) ;
    M = M[(RM/5)+1:RM]|M[1:RM/5] ;
  ELSEIF IT == 4 ;
    TARSTR = "Blocks" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|-5|3|-4|5|-4.2|2.1|4.3|-3.1|2.1|-4.2 ;
    M = XGRID' - T ;
      FLAG = M .> 0 ;
      FLAG0 = M .== 0 ;
    M = FLAG - (1 - FLAG - FLAG0) ;       /*  GIVES SGN(M)  */
    M = (1 + M) / 2 ;
    M = H .* M ;
    M = SUMC(M) ;                     /*  THIS IS NOW DJ'S BLOCKS   */
    M = (.6 / 9.2) * (M + 2) + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF IT == 5 ;
    TARSTR = "Bumps" ;
      T = .1|.13|.15|.23|.25|.40|.44|.65|.76|.78|.81 ;
      H = 4|5|3|4|5|4.2|2.1|4.3|3.1|5.1|4.2 ;
      W = .005|.005|.006|.01|.01|.03|.01|.01|.005|.008|.005 ;
    M = (XGRID' - T) ./ W ;
    M = 1 ./ (1 + ABS(M))^4 ;
    M = H .* M ;
    M = SUMC(M) ;                     /*  THIS IS NOW DJ'S BUMPS   */
    M = (.6/5.3437952) * M + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF IT == 6 ;
    TARSTR = "HeavSi" ;
    M = 4 * SIN(4 * PI * XGRID) ;
      FLAG = XGRID .> .3 ;
      FLAG0 = XGRID .== .3 ;
    M = M - (FLAG - (1 - FLAG - FLAG0)) ;
      FLAG = XGRID .> .72 ;
      FLAG0 = XGRID .== .72 ;
    M = M + (FLAG - (1 - FLAG - FLAG0)) ;     /*  DJ'S HEAVY SINE  */
    M = (.6 / 9) * (M + 5) + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF IT == 7 ;
    TARSTR = "Doppl" ;
    M = SQRT(XGRID .* (1 - XGRID)) ;
    M = M .* SIN(2 * PI * 1.05 ./ (XGRID + .05)) ;   /*  DJ'S DOPPLER   */
    M = (.6 / 1) * (M + .5) + .2 ;      /*  RESCALED TO [.2,.8]  */
  ELSEIF IT == 8 ;
    TARSTR = "Angles" ;
    M = (XGRID .<= .15) .* (2 * XGRID + .5) ;
    M = M + (.15 .< XGRID) .* (XGRID .<= .2) .* (-12 * (XGRID -.15) + .8)  ;
    M = M + (.2 .< XGRID) .* (XGRID .<= .5) .* (.2)  ;
    M = M + (.5 .< XGRID) .* (XGRID .<= .6) .* (6 * (XGRID -.5) + .2)  ;
    M = M + (.6 .< XGRID) .* (XGRID .<= .65) .* (-10 * (XGRID -.6) + .8)  ;
    M = M + (.65 .< XGRID) .* (XGRID .<= .85) .* (-1/2 * (XGRID -.65) + .3) ;
    M = M + (.85 .< XGRID) .* (2 * (XGRID -.85) + .2)  ;
  ELSEIF IT == 9 ;
    TARSTR = "Parabs" ;
    M = .8 .* ONES(NXGRID,1) ;
    M = M + (.1 .< XGRID) .* (-30 .* (XGRID - .1)^2) ;
    M = M + (.2 .< XGRID) .* (60 .* (XGRID - .2)^2) ;
    M = M + (.3 .< XGRID) .* (-30 .* (XGRID - .3)^2) ;
    M = M + (.35 .< XGRID) .* (500 .* (XGRID - .35)^2) ;
    M = M + (.37 .< XGRID) .* (-1000 .* (XGRID - .37)^2) ;
    M = M + (.41 .< XGRID) .* (1000 .* (XGRID - .41)^2) ;
    M = M + (.43 .< XGRID) .* (-500 .* (XGRID - .43)^2) ;
    M = M + (.5 .< XGRID) .* (7.5 .* (XGRID - .5)^2) ;
    M = M + (.7 .< XGRID) .* (-15 .* (XGRID - .7)^2) ;
    M = M + (.9 .< XGRID) .* (7.5 .* (XGRID - .9)^2) ;
  ELSEIF IT == 10 ;
    TARSTR = "TShSin" ;
    TXGRID = (1 - COS(PI .* XGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 2 ;
    TXGRID = (1 - COS(PI .* TXGRID)) / 4 + XGRID / 2 ;
    M = .3 * SIN(6 .* PI .* TXGRID) + .5 ;
  ENDIF ;

  ? ; "WORKING ON "$+TARSTR ;

      TITSTR = "#"$+FTOS(IT,"%*.*lf",1,0)$+" " ;
      TITSTR = TITSTR$+TARSTR ;
    TITLE(TITSTR) ;
  XY(XGRID,M) ;


  IT = IT + 1 ;
ENDO ;



TARSTR = "Step" ;
M = 0.2 ;      /*  BASE HEIGHT  */
M = M + (1/3 .< DATGRID) .* (DATGRID .< .75) * .6 ;
               /*  RAISE BY .4 ON THIS INTERVAL  */


IS = ISS ;      /*  LOOP THROUGH SIGMAS  */
DO WHILE IS <= ISE ;
  NEXTWIND ;

  IF IS == 1 ;
    SIGSTR = "Low Noise" ;
    SIG = .02 ;
  ELSEIF IS == 2 ;
    SIGSTR = "High Noise" ;
    SIG = .1 ;
  ENDIF ;

  ? ; "WORKING ON "$+SIGSTR ;


    SEED = 932485732 ;
  Y = M + SIG * RNDNS(N,1,SEED) ;


      TITSTR = SIGSTR$+", \202s\201 = "$+FTOS(SIG,"%*.*lf",3,2) ;
    TITLE(TITSTR) ;
  XY(DATGRID,M~Y) ;

  IS = IS + 1 ;
ENDO ;

  IF AUTOP == 1 ;
      PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\TT4" ;
      PRSTR = PRSTR$+".PLT" ;
    GRAPHPRT(PRSTR) ;
  ELSEIF AUTOP == 2 ;
      PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\TT4" ;
      PRSTR = PRSTR$+".PS" ;
    GRAPHPRT(PRSTR) ;
  ENDIF ;


ENDWIND ;


END ;
