/* =========================== START PROC WVBEN1 ======================== */
PROC WVBEN1(Y) ;
    /*  NAIVE "ROW-WISE" TYPE BOCK WAVELET      */
    /*          NONPARAMETRIC REGRESSION ESTIMATOR  */
    /*  Y IS Y'S, WHERE X'S ARE ASSUMED TO BE:    */
    /*              0,1,2,...,(2^M - 1)     (FOR SOME M)   */
    /*  I.E. NUMBERS ON ENTRIES IN Y NEEDS TO BE A POWER OF 2  */
    /*       CAUTION:  THIS ASSUMES "CIRCULAR DESIGN"   */
    /*  OUTPUT IS MATRIX, EACH OF WHOSE COLUMNS REPRESENTS A "SMOOTH"  */
    /*    FIRST COLUMN IS WAVELET RECONSTRUCTION OF RAW DATA  */
    /*    SECOND COLUMN MISSES "HIGHEST FREQUENCY COEFFICIENTS", ETC.  */
    /*  USES PROCS WVBD.G AND WVBR.G   */

  LOCAL N,M,YR,SMOOTH,NJ,IS,IE ;

  N = ROWS(Y) ;
  M = LOG(N) ./ LOG(2) ;      /*  LOG BASE 2  */
  M = ROUND(M) ;

  IF ABS(2^M - N) > 10^(-10) ;
    "******************************************************" ;
    "***   CAREFUL n IS NOT A POWER OF 2, RETURNING 0   ***" ;
    "******************************************************" ;
   RETP(0) ;
  ENDIF ;

  YR = WVBD(Y) ;

  SMOOTH = WVBR(YR) ;

  NJ = N ;
  IE = 0 ;
  DO WHILE NJ >= 4 ;

    NJ = NJ / 2 ;
    IS = IE + 1 ;
    IE = IE + NJ ;

    YR[IS:IE,2] = ZEROS(NJ,1) ;
    SMOOTH = SMOOTH~WVBR(YR) ;

  ENDO ;

  RETP(SMOOTH) ;
ENDP ;
/* ============================ END PROC WVBEN1 ========================= */
