/* =========================== START PROC WVBR ======================== */
PROC WVBR(YR) ;
    /*  DOES "RECONSTRUCTION STEP" IN BOCK WAVELET ESTIMATOR   */
    /*  FOR REGRESSION, WHERE X'S ARE ASSUMED TO BE:    */
    /*              0,1,2,...,(2^M - 1)     (FOR SOME M)   */
    /*  I.E. NUMBERS ON ENTRIES IN Y NEEDS TO BE A POWER OF 2  */
    /*                NOTE THIS ALGORITHM ASSUMES A "CIRCULAR DESIGN"  */
    /*  YR IS A 2 COLUMN MATRIX,    */
    /*      THE FIRST COLUMN IS THE "PREDICTED VALUES"   */
    /*      THE SECOND COLUMN IS THE "MODIFIED DISCREPANCIES"   */
    /*              (USUALLY "SHRUNK" OR "THRESHOLDED")    */
    /*  AS OUTPUT BY WVBD.G  */
    /*  GENERAL ALGORITHM STRUCTURE IS AN ADAPTATION OF THE IDEAS   */
    /*  IN BOCK (1992) STAT. COMP. AND STAT. GRA. NEWS., 3, 27-34.  */

  LOCAL N,M,C,DENOM,Y,IS,J,NJ,IE,YOLD,R,YEVEN,YODD ;

  N = ROWS(YR) + 2 ;
  M = LOG(N) ./ LOG(2) ;      /*  LOG BASE 2  */
  M = ROUND(M) ;

  IF ABS(2^M - N) > 10^(-10) ;
    "******************************************************" ;
    "***   CAREFUL n IS NOT A POWER OF 2, RETURNING 0   ***" ;
    "******************************************************" ;
   RETP(0) ;
  ENDIF ;

  C = (1+SQRT(3))|(3+SQRT(3))|(3-SQRT(3))|(1-SQRT(3)) ;
  C = C / 4 ;
  DENOM = SQRT(3) - 2 ;

  Y = YR[(N-3):(N-2),1] ;      /*  LAST 2 VALUES  */
  IS = N - 1 ;

  J = M - 1 ;
  DO WHILE J >= 1 ;     /*  LOOP THROUGH LEVELS  */

    NJ = 2^(M-J) ;

    IE = IS - 1 ;
    IS = IE - NJ + 1 ;

    YOLD = Y ;
    R = YR[IS:IE,2] ;      /*  NEXT SET OF R VALUES  */

    YEVEN = C[1] * YOLD + C[3] * (YOLD[NJ]|YOLD[1:(NJ-1)]) ;
    YEVEN = YEVEN + (C[2] * (R[NJ]|R[1:(NJ-1)]) + C[4] * R) / DENOM ;

    YODD = C[2] * YOLD + C[4] * (YOLD[NJ]|YOLD[1:(NJ-1)]) ;
    YODD = YODD - (C[1] * (R[NJ]|R[1:(NJ-1)]) + C[3] * R) / DENOM ;

    Y = RESHAPE(YEVEN~YODD,2*NJ,1) ;

    J = J - 1 ;
  ENDO ;

  RETP(Y) ;
ENDP ;
/* ============================ END PROC WVBR ========================= */
