/* =========================== START PROC WVERMSE1 ======================== */
PROC WVERMSE1(THETA,SIG2,LAMBDA,J0,ITHRE) ;
    /*   FOR EXACT RISK ANALYSIS IN WAVELETS     */
    /*   THIS CALCULATES MY VERSION OF IAIN JOHNSTONE'S    */
    /*   EXACT MEAN SQUARED ERROR FOR AN    */
    /*   ORTHOGONAL SERIES FOR A REGRESSION ESTIMATOR    */
    /*   DIFFERENCE WITH OTHER VERSIONS COMES FROM MY WAVELET   */
    /*   TRANSFORM EXACTLY PRESERVING POWER (NO 1/N FACTOR)  */
    /*   INPUTS ARE:     */
    /*     THETA = THE WAVELET COEFFS OF TARGET CURVE    */
    /*                       (VECTOR OF LENGTH N=2^JE)  */
    /*     SIG2 = VARIANCE OF ASSUMED IID N(0,1) NOISE    */
    /*     LAMBDA = THRESHOLD VALUE   (E.G. SQRT(2LOGN))   */
    /*           CAN BE SCALAR, OR JE VECTOR   */
    /*     J0 = INDEX OF LOWEST FREQUENCY THRESHOLDED   */
    /*     ITHRE = 0   FOR 0 THRESHHOLDING (I.E. LO FREQ RECON.)   */
    /*           = 1   FOR HARD THRESHOLDING   */
    /*           = 2   FOR SOFT THRESHOLDING    */
    /*   OUTPUT IS MEAN SQUARE ERROR (SUMMED OVER LOCATIONS)    */

  LOCAL N,JE,SIG,MU,R,MSE ;

  N = ROWS(THETA) ;
  JE = ROUND(LOG(N) / LOG(2)) ;
  SIG = SQRT(SIG2) ;
  MU = THETA / SIG ;

  R = WVERTR1(MU,LAMBDA,J0,ITHRE) ;    /*  IAIN'S R FUNCTION  */

  MSE = 2^J0 ;
  MSE = MSE + SUMC(R) ;    /*  THIS IS ENOUGH, SINCE MVERTR1 RETURNS
                                  0 IN OTHER ENTRIES    */
  MSE = MSE * SIG2 ;

  RETP(MSE) ;
ENDP ;
/* ============================ END PROC WVERMSE1 ========================= */
