/* =========================== START PROC WVFFTR ======================== */
PROC WVFFTR(YD) ;
    /*  THE INVERSE OF WVFFTD.G, WHICH IS        */
    /*  A FAST FOURIER TRANSFORM, EXCEPT MODIFIED TO:     */
    /*      1. BE POWER PRESERVING,                      */
    /*           (I.E. SUMS OF SQUARES OF FFT = THAT OF DATA)   */
    /*      2. HAVE OUPUT IS SAME FORM AS WV2D1.G        */
    /*           (I.E. A SINGLE COLUMN VECTOR, LOW FREQS 1ST)   */
    /*  INPUT VECTOR YD MUST BE REAL VALUED         */
    /*           AND ITS LENGTH MUST BE A POWER OF 2    */

  LOCAL N,RN,SYD,CPART,FFTY,Y ;

  N = ROWS(YD) ;
  RN = SQRT(N) ;

  SYD = YD / RN ;      /*  BACK ON ORIGINAL SCALE   */

          /*  GET COMPLEX PART   */
  CPART = SYD[2:N-1] ;
  CPART = RESHAPE(CPART,(N/2)-1,2) ;
  CPART = CPART[.,1] + SQRT(-1) * CPART[.,2] ;
  CPART = CPART / SQRT(2) ;      /*  AGAIN BACK ON ORIGINAL SCALE  */

  FFTY = SYD[1]|CPART|SYD[N]|REV(CONJ(CPART)) ;

  Y = RFFTI(FFTY) ;

  RETP(Y) ;
ENDP ;
/* ============================ END PROC WVFFTR ========================= */
