/* =========================== START PROC WVHR ======================== */
PROC WVHR(YR) ;
    /*  DOES "RECONSTRUCTION STEP" IN HAAR WAVELET ESTIMATOR   */
    /*  FOR REGRESSION, WHERE X'S ARE ASSUMED TO BE:    */
    /*              0,1,2,...,(2^M - 1)     (FOR SOME M)   */
    /*  I.E. NUMBERS ON ENTRIES IN Y NEEDS TO BE A POWER OF 2  */
    /*  YR IS A 2 COLUMN MATRIX,    */
    /*      THE FIRST COLUMN IS THE "PREDICTED VALUES"   */
    /*      THE SECOND COLUMN IS THE "MODIFIED DISCREPANCIES"   */
    /*              (USUALLY "SHRUNK" OR "THRESHOLDED")    */
    /*  AS OUTPUT BY WVHD.G  */
    /*  OUTPUT IS A "SMOOTH"      */
    /*  GENERAL ALGORITHM STRUCTURE IS AN ADAPTATION OF THE IDEAS   */
    /*  IN BOCK (1992) STAT. COMP. AND STAT. GRA. NEWS., 3, 27-34.  */
    /*  COEFFICIENTS CHOSEN TO PRESERVE POWER OF SIGNAL  */

  LOCAL R2,N,M,Y,IS,J,NJ,IE,YOLD,R,Y ;

  R2 = sqrt(2) ;
  N = ROWS(YR) + 1 ;
  M = LOG(N) ./ LOG(2) ;      /*  LOG BASE 2  */
  M = ROUND(M) ;

  IF ABS(2^M - N) > 10^(-10) ;
    "******************************************************" ;
    "***   CAREFUL n IS NOT A POWER OF 2, RETURNING 0   ***" ;
    "******************************************************" ;
   RETP(0) ;
  ENDIF ;

  Y = YR[N-1,1] ;      /*  LAST Y VALUE, YBAR  */
  IS = N ;

  J = M ;
  DO WHILE J >= 1 ;     /*  LOOP THROUGH LEVELS  */

    NJ = 2^(M-J) ;

    IE = IS - 1 ;
    IS = IE - NJ + 1 ;

    YOLD = Y ;
    R = YR[IS:IE,2] ;      /*  NEXT SET OF R VALUES  */

             /*  INVERSION OF HI AND LO PASS FILTERING  */
    Y = (YOLD + R) / R2 ;
    Y = Y~((YOLD - R) / R2) ;
    Y = RESHAPE(Y,2*NJ,1) ;

    J = J - 1 ;
  ENDO ;

  RETP(Y) ;
ENDP ;
/* ============================ END PROC WVHR ========================= */
